/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easymybatis.pagination;

import cn.easyproject.easymybatis.pagination.EasyMyBatisPaginationException;
import cn.easyproject.easymybatis.pagination.PageBean;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class EasyMybatisPaginationPlugin
implements Interceptor {
    public static Logger logger = LoggerFactory.getLogger(EasyMybatisPaginationPlugin.class);
    private int dialect = -1;

    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof StatementHandler) {
            block35: {
                RoutingStatementHandler statementHandler = (RoutingStatementHandler)invocation.getTarget();
                Object args = statementHandler.getBoundSql().getParameterObject();
                if (args != null && args.getClass().equals(PageBean.class)) {
                    PageBean pb = (PageBean)args;
                    Connection connection = (Connection)invocation.getArgs()[0];
                    PreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = connection.prepareStatement(pb.getAutoCountSQL().replaceAll("\\#\\{[\\ ]*(\\S*)[\\ ]*\\}", "?"));
                            statementHandler.parameterize((Statement)pstmt);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                int totalRecord = rs.getInt(1);
                                pb.setRowsCount(totalRecord);
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                                if (pstmt != null) {
                                    pstmt.close();
                                }
                                break block35;
                            }
                            catch (SQLException e2) {
                                e2.printStackTrace();
                            }
                            break block35;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            if (pstmt != null) {
                                pstmt.close();
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            Object result = invocation.proceed();
            return result;
        }
        if (invocation.getTarget() instanceof Executor) {
            if (invocation.getArgs() != null && invocation.getArgs().length > 2 && invocation.getArgs()[1] != null && invocation.getArgs()[1].getClass().equals(PageBean.class)) {
                PageBean pb = (PageBean)invocation.getArgs()[1];
                Executor ex = (Executor)invocation.getTarget();
                Connection connection = ex.getTransaction().getConnection();
                if (pb.getDialect() == -1) {
                    if (this.dialect == -1) {
                        DatabaseMetaData dbmd = connection.getMetaData();
                        String productName = dbmd.getDatabaseProductName().replace(" ", "").toLowerCase();
                        String version = dbmd.getDriverVersion().replace(" ", "").toLowerCase();
                        if (productName.contains("oracle") && version.startsWith("12.")) {
                            this.dialect = 10;
                        } else if (productName.contains("oracle")) {
                            this.dialect = 1;
                        } else if (productName.contains("mysql")) {
                            this.dialect = 3;
                        } else if (productName.contains("sqlserver") && version.startsWith("sqlserver2012")) {
                            this.dialect = 20;
                        } else if (productName.contains("sqlserver")) {
                            this.dialect = 2;
                        } else {
                            throw new EasyMyBatisPaginationException("Sorry, the database '" + dbmd.getDatabaseProductName() + "' now not support(Only support: oracle12c, oracle, sqlserver2012, sqlserver, mysql). Please contact 'inthinkcolor@gmail.com' or edit source code write yourself support!");
                        }
                    }
                    pb.setDialect(this.dialect);
                }
            }
            Object result = invocation.proceed();
            if (invocation.getArgs() != null && invocation.getArgs().length > 2 && invocation.getArgs()[1] != null && invocation.getArgs()[1].getClass().equals(PageBean.class)) {
                PageBean pb = (PageBean)invocation.getArgs()[1];
                pb.setData((List)result);
            }
            return result;
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        Object dialectValue = properties.get("dialect");
        if (dialectValue == null) {
            logger.warn("EasyMyBatisPagination - the defualt 'dialect' parameter is not set!");
            return;
        }
        String dialectValueStr = dialectValue.toString();
        if (dialectValueStr.equalsIgnoreCase("ORACLE")) {
            this.dialect = 1;
        } else if (dialectValueStr.equalsIgnoreCase("ORACLE_12C")) {
            this.dialect = 10;
        } else if (dialectValueStr.equalsIgnoreCase("SQLSERVER")) {
            this.dialect = 2;
        } else if (dialectValueStr.equalsIgnoreCase("SQLSERVER_2012")) {
            this.dialect = 20;
        } else if (dialectValueStr.equalsIgnoreCase("MYSQL")) {
            this.dialect = 3;
        } else {
            logger.warn("EasyMyBatisPagination - Unkonw defualt 'dialect' parameter value '" + dialectValueStr + "'!");
        }
    }
}

