/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easymybatis.pagination;

import cn.easyproject.easymybatis.pagination.EasyMyBatisPaginationException;
import cn.easyproject.easymybatis.pagination.PageBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class EasyMybatisPaginationPlugin
implements Interceptor {
    private int dbType = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof StatementHandler) {
            RoutingStatementHandler statementHandler = (RoutingStatementHandler)invocation.getTarget();
            Object args = statementHandler.getBoundSql().getParameterObject();
            if (args != null && args.getClass().equals(PageBean.class)) {
                PageBean pb = (PageBean)args;
                pb.dbType = this.dbType;
                Connection connection = (Connection)invocation.getArgs()[0];
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = connection.prepareStatement(pb.getAutoCountSQL().replaceAll("\\#\\{[\\ ]*(\\S*)[\\ ]*\\}", "?"));
                    statementHandler.parameterize((Statement)pstmt);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        int totalRecord = rs.getInt(1);
                        pb.setRowsCount(totalRecord);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            Object result = invocation.proceed();
            return result;
        }
        if (invocation.getTarget() instanceof Executor) {
            Object result = invocation.proceed();
            if (invocation.getArgs() != null && invocation.getArgs().length > 2 && invocation.getArgs()[1] != null && invocation.getArgs()[1].getClass().equals(PageBean.class)) {
                PageBean pb = (PageBean)invocation.getArgs()[1];
                pb.setData((List)result);
            }
            return result;
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        Object dialectValue = properties.get("dialect");
        if (dialectValue == null) {
            throw new EasyMyBatisPaginationException("Property 'dialect' could not is null!");
        }
        String dialect = dialectValue.toString();
        if (dialect.equalsIgnoreCase("ORACLE")) {
            this.dbType = 1;
        } else if (dialect.equalsIgnoreCase("ORACLE_12C")) {
            this.dbType = 10;
        } else if (dialect.equalsIgnoreCase("SQLSERVER")) {
            this.dbType = 2;
        } else if (dialect.equalsIgnoreCase("SQLSERVER_2012")) {
            this.dbType = 20;
        } else if (dialect.equalsIgnoreCase("MYSQL")) {
            this.dbType = 3;
        } else {
            throw new EasyMyBatisPaginationException("the dialect '" + dialect + "' unkonw!");
        }
    }
}

