package cn.easyproject.easymonitor.monitor;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.easyproject.easymonitor.EasyMonitor;
import cn.easyproject.easymonitor.MonitorRuntime;
import cn.easyproject.easymonitor.MonitorType;
import cn.easyproject.easymonitor.configuration.MonitorConfiguration;
import cn.easyproject.easymonitor.configuration.GlobalMonitorConfiguration;
import cn.easyproject.easymonitor.job.JobManager;
import cn.easyproject.easymonitor.monitor.validator.MonitorValidator;
import cn.easyproject.easymonitor.monitor.validator.PortMonitorValidator;
import cn.easyproject.easymonitor.monitor.validator.ProcessMonitorValidator;
import cn.easyproject.easymonitor.monitor.validator.URLMonitorValidator;
import cn.easyproject.easymonitor.sender.Sender;
import cn.easyproject.easymonitor.sender.mail.MailSender;
import cn.easyproject.easymonitor.util.EasyMonitorUtil;
import cn.easyproject.easymonitor.util.SpringUtil;

/**
 * Standard Monitor, EasyMonitor core
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class StdMonitor implements Monitor {
	
	static Logger logger=LoggerFactory.getLogger(StdMonitor.class);
	
	/**
	 * 全局 EasyMonitor 配置
	 */
	private static GlobalMonitorConfiguration globalConfig=new GlobalMonitorConfiguration();
	/**
	 * 监控 Monitor 配置
	 */
	private static List<MonitorConfiguration> monitors=new ArrayList<MonitorConfiguration>();


	/**
	 * 初始化配置数据
	 */
	@SuppressWarnings("rawtypes")
	public void initMonitorConfig(){
		Properties p=EasyMonitor.getProperties();
		/*
		 * GlobalConfig init
		 */
		String globalEnable=p.getProperty("easymonitor.enable", "on");
		String globalCronExpression=p.getProperty("easymonitor.cronexpression", "0/10 * * * * ?");
		String globalCmd=p.getProperty("easymonitor.cmd",null);
		
	
		
		Integer globalMaxfailure=10;
		try {
			globalMaxfailure = Integer.valueOf(p.getProperty("easymonitor.maxfailure", "10"));
		} catch (NumberFormatException e) {
			logger.warn("'easymonitor.maxfailure' is not a integer, use default 10.");
		}
		Integer globalMailPort=25;
		try {
			globalMailPort = Integer.valueOf(p.getProperty("easymonitor.mail.sender.port", "25"));
		} catch (NumberFormatException e) {
			logger.warn("'easymonitor.mail.sender.port' is not a integer, use default 25.");
		}
		Integer globalMailSenderInterval=0;
		try {
			globalMailSenderInterval = Integer.valueOf(p.getProperty("easymonitor.mail.sender.interval", "0"));
		} catch (NumberFormatException e) {
			logger.warn("'easymonitor.mail.sender.interval' is not a integer, use default 0, not repeat.");
		}
		String globalMailReceiver=p.getProperty("easymonitor.mail.receiver",null);
		String globalMailSender=p.getProperty("easymonitor.mail.sender",null);
		String globalMailSenderPassword=p.getProperty("easymonitor.mail.sender.passowrd",null);
		String globalMailSenderHost=p.getProperty("easymonitor.mail.sender.host",null);
		String globalMailSenderSsl=p.getProperty("easymonitor.mail.sender.ssl",null);
		String globalMailSenderTitle=p.getProperty("easymonitor.mail.sender.title",null);
		String globalMailSenderTemplate=p.getProperty("easymonitor.mail.sender.template",null);
		
		globalConfig.setEnable(EasyMonitorUtil.isTrue(globalEnable));
		globalConfig.setCronExpression(globalCronExpression);
		globalConfig.setCmd(EasyMonitorUtil.isNotEmpty(globalCmd)?globalCmd.split(";"):null);
		globalConfig.setMaxfailure(globalMaxfailure);
		globalConfig.setMailReceiver(EasyMonitorUtil.isNotEmpty(globalMailReceiver)?globalMailReceiver.split(";"):null);
		globalConfig.setMailSender(globalMailSender);
		globalConfig.setMailSenderInterval(globalMailSenderInterval);
		globalConfig.setMailSenderPassword(globalMailSenderPassword);
		globalConfig.setMailSenderHost(globalMailSenderHost);
		globalConfig.setMailSenderPort(globalMailPort);
		globalConfig.setMailSenderTitle(globalMailSenderTitle);
		globalConfig.setMailSenderTemplate(globalMailSenderTemplate);
		globalConfig.setMailSenderSsl(EasyMonitorUtil.isTrue(globalMailSenderSsl));
		
		/*
		 * Get Config Names
		 */
		Set<String> configNames=new HashSet<String>();
		Enumeration names=p.propertyNames();
		while(names.hasMoreElements()){
		    String key = (String) names.nextElement();
		    /*
			 * Judgment Config TYPE
			 */
		    if(key.startsWith("easymonitor.url.")){
		    	key=key.substring("easymonitor.url.".length());
		    	if(key.indexOf(".")==-1){
		    		configNames.add("URL:"+key);
		    	}
		    }else if(key.startsWith("easymonitor.port.")){
		    	key=key.substring("easymonitor.port.".length());
		    	if(key.indexOf(".")==-1){
		    		configNames.add("PORT:"+key);
		    	}
		    }else if(key.startsWith("easymonitor.process.")){
		    	key=key.substring("easymonitor.process.".length());
		    	if(key.indexOf(".")==-1){
		    		configNames.add("PROCESS:"+key);
		    	}
		    }else if(key.startsWith("easymonitor.user.")){
		    	key=key.substring("easymonitor.user.".length());
		    	if(key.indexOf(".")==-1){
		    		configNames.add("USER:"+key);
		    	}
		    }
		} 
		
		logger.debug("configNames: "+ configNames);
		
		/*
		 * Init MonitorConfig
		 */
		for (String name : configNames) {
			MonitorConfiguration monitorConfig=new MonitorConfiguration();
			
			/*
			 * Judgment Config TYPE
			 */
			String startWith="easymonitor.url.";
			if(name.startsWith("URL:")){
				startWith="easymonitor.url.";
				name=name.substring("URL:".length());
				monitorConfig.setType(MonitorType.URL);
				monitorConfig.setMonitorValidator(new URLMonitorValidator());
			}else if(name.startsWith("PORT:")){
				startWith="easymonitor.port.";
				name=name.substring("PORT:".length());
				monitorConfig.setType(MonitorType.PORT);
				monitorConfig.setMonitorValidator(new PortMonitorValidator());
			}else if(name.startsWith("PROCESS:")){
				startWith="easymonitor.process.";
				name=name.substring("PROCESS:".length());
				monitorConfig.setType(MonitorType.PROCESS);
				monitorConfig.setMonitorValidator(new ProcessMonitorValidator());
			}else if(name.startsWith("USER:")){
				startWith="easymonitor.user.";
				name=name.substring("USER:".length());
				monitorConfig.setType(MonitorType.USER);
//				monitorConfig.setMonitorValidator(new ProcessMonitorValidator());
			}
			
			
			String value=startWith+name;
			String enable=startWith+name+".enable";
			String server=startWith+name+".server";
			String cronexpression=startWith+name+".cronexpression";
			String maxfailure=startWith+name+".maxfailure";
			String receiver=startWith+name+".mail.receiver";
			String sender=startWith+name+".mail.sender";
			String senderInterval=startWith+name+".mail.sender.interval";
			String senderPassowrd=startWith+name+".mail.sender.passowrd";
			String senderHost=startWith+name+".mail.sender.host";
			String senderPort=startWith+name+".mail.sender.port";
			String senderSsl=startWith+name+".mail.sender.ssl";
			String senderTitle=startWith+name+".mail.sender.title";
			String senderTemplate=startWith+name+".mail.sender.template";
			String cmd=startWith+name+".cmd";
			String senderImpl=startWith+name+".sender.impl";
			String validatorClass=startWith+name+".validatorClass";
			
	
			value=p.getProperty(value,null);
			enable=p.getProperty(enable,null);
			server=p.getProperty(server,null);
			cmd=p.getProperty(cmd,null);
			cronexpression=p.getProperty(cronexpression,null);
			maxfailure=p.getProperty(maxfailure,null);
			receiver=p.getProperty(receiver,null);
			sender=p.getProperty(sender,null);
			senderInterval=p.getProperty(senderInterval,null);
			senderPassowrd=p.getProperty(senderPassowrd,null);
			senderHost=p.getProperty(senderHost,null);
			senderPort=p.getProperty(senderPort,null);
			senderTitle=p.getProperty(senderTitle,null);
			senderTemplate=p.getProperty(senderTemplate,null);
			senderSsl=p.getProperty(senderSsl,null);
			senderImpl=p.getProperty(senderImpl,null);
			validatorClass=p.getProperty(validatorClass,null);
			
			
			monitorConfig.setName(name);
			monitorConfig.setValue(value); // value
			monitorConfig.setEnable(enable!=null?EasyMonitorUtil.isTrue(enable):globalConfig.getEnable()); //enable
		
			
			
			
			// User MonitorValidator
			if(monitorConfig.getType()==MonitorType.USER){
				// if not configuration validatorClass, do not monitor
				if(validatorClass!=null){
					try {
						MonitorValidator monitorValidator=(MonitorValidator) Class.forName(validatorClass.trim()).newInstance();
						monitorConfig.setMonitorValidator(monitorValidator);
					} catch (InstantiationException e) {
						logger.error(monitorConfig.getType().name()+"-"+monitorConfig.getName()+": '"
								+"', Can not instance your validatorClass '"+validatorClass+"'.",e);
						continue;
					} catch (IllegalAccessException e) {
						logger.error(monitorConfig.getType().name()+"-"+monitorConfig.getName()+": '"
								+"', Can not instance your validatorClass '"+validatorClass+"'.",e);
						continue;
					} catch (ClassNotFoundException e) {
						logger.error(monitorConfig.getType().name()+"-"+monitorConfig.getName()+": '"
								+"', You validatorClass is not found '"+validatorClass+"'.",e);
						continue;
					}
					
				}else{
					logger.error(monitorConfig.getType().name()+"-"+monitorConfig.getName()+": '"
							+monitorConfig.getValue()
							+"', You are not configuration 'easymonitor.user."+monitorConfig.getName()+".validatorClass'.");
					continue;
				}
			}
			
			
			Integer monitorMaxfailure=globalConfig.getMaxfailure();
			if(maxfailure!=null){
				try {
					monitorMaxfailure = Integer.valueOf(maxfailure);
				} catch (NumberFormatException e) {
					logger.warn("'"+startWith+name+".maxfailure' is not a integer, use default "+monitorMaxfailure+".",e);
				}
			}
			
			Integer monitorMailPort=globalConfig.getMailSenderPort();
			if(senderPort!=null){
				try {
					monitorMailPort = Integer.valueOf(senderPort);
				} catch (NumberFormatException e) {
					logger.warn("'"+startWith+name+".mail.sender.interval' is not a integer, use default "+monitorMailPort+".",e);
				}
			}
			if(monitorMailPort==null){
				monitorMailPort=25; // default is 25
			}
			
			int monitorMailSenderInterval=globalConfig.getMailSenderInterval();
			if(senderInterval!=null){
				try {
					monitorMailSenderInterval = Integer.valueOf(senderInterval);
				} catch (NumberFormatException e) {
					logger.warn("'"+startWith+name+".mail.sender.port' is not a integer, use default "+monitorMailSenderInterval+".",e);
				}
			}
			
			
			monitorConfig.setCronExpression(cronexpression!=null?cronexpression:globalConfig.getCronExpression());; //cronexpression
			monitorConfig.setMaxfailure(monitorMaxfailure); //maxfailure
			monitorConfig.setMailSender(sender!=null?sender:globalConfig.getMailSender()); //mailSender
			monitorConfig.setMailSenderPort(monitorMailPort); //mailSender port
			monitorConfig.setMailSenderInterval(monitorMailSenderInterval); //mailSender interval
			monitorConfig.setMailSenderPassword(senderPassowrd!=null?senderPassowrd:globalConfig.getMailSenderPassword()); //password
			monitorConfig.setMailSenderHost(senderHost!=null?senderHost:globalConfig.getMailSenderHost()); //host
			monitorConfig.setMailSenderSsl(senderSsl!=null?EasyMonitorUtil.isTrue(senderSsl):globalConfig.getMailSenderSsl()); //ssl
			monitorConfig.setMailSenderTitle(senderTitle!=null?senderTitle:globalConfig.getMailSenderTitle()); //title
			monitorConfig.setMailSenderTemplate(senderTemplate!=null?senderTemplate:globalConfig.getMailSenderTemplate()); //template
			monitorConfig.setMailReceiver(receiver!=null?receiver.split(";"):globalConfig.getMailReceiver()); //mailReceiver
			monitorConfig.setCmd(cmd!=null?cmd.split(";"):globalConfig.getCmd()); //mailReceiver
			monitorConfig.setServer(server);
			
			
			// 邮件模板检测，如果不存在默认加载mail.tpl
			if(!EasyMonitorUtil.isNotEmpty(monitorConfig.getMailSenderTemplate())){
				logger.warn("Not configuration '"+startWith+name+".mail.sender.template'. Use default 'mail.tpl'");
				monitorConfig.setMailSenderTemplate("mail.tpl");
			}
			
			if(monitorConfig.getType()==MonitorType.PORT){
				// 检测端口是否为有效数字
				try {
					int port=Integer.valueOf(monitorConfig.getValue());
					monitorConfig.setPort(port);
				} catch (NumberFormatException e) {
					// 不为数字，无效任务，直接删除
					logger.error(monitorConfig.getType().name()+"-"+monitorConfig.getName()+": '"
					+monitorConfig.getValue()
					+"' is not a validate integer between 1~65535, the monitor is cancel.",e);
					continue;
				}
			}
			
			 
			
			
			List<Sender> userSenders=new ArrayList<Sender>();
			 
			// 自定义Sender
			if(senderImpl!=null){
				 String[] senderImpls=senderImpl.split(";");
				 if(senderImpls.length>0){
					 
					
					 for (String cls : senderImpls) {
						if(!"".equals(cls)){
							// 加载自定义Sender
							try {
								Sender userSender=(Sender) Class.forName(cls).newInstance();
								userSenders.add(userSender);
							} catch (InstantiationException e) {
								logger.error(monitorConfig.getType().name()+"-"+monitorConfig.getName()+": '"
										+monitorConfig.getValue()
										+"', the Sender class ["+cls+"] is not implements 'cn.easyproject.easymonitor.sender.Sender' interface.",
										e);
							} catch (IllegalAccessException e) {
								logger.error(monitorConfig.getType().name()+"-"+monitorConfig.getName()+": '"
										+monitorConfig.getValue()
										+"', the Sender class ["+cls+"] is IllegalAccessException.",
										e);
							} catch (ClassNotFoundException e) {
								logger.error(monitorConfig.getType().name()+"-"+monitorConfig.getName()+": '"
										+monitorConfig.getValue()
										+"', the Sender class ["+cls+"] is not found.",
										e);
							}
							
						}
					}
				 }
			}
			
			
	
			
			// MailSender
			if(
					monitorConfig.getMailSender()!=null
					&&
					monitorConfig.getMailReceiver()!=null
					&&
					monitorConfig.getMailReceiver().length!=0
			){
				userSenders.add(new MailSender());
			}
				
			monitorConfig.setSenderImpl(userSenders);
			
			
			monitors.add(monitorConfig);
			
			
		}
		
	}
	
	
	public void initJob(){
		
		MonitorRuntime.errorJobMonitorsOnStartup.clear();
		MonitorRuntime.runningMonitorsOnStartup.clear();
		MonitorRuntime.allMonitorsOnStartup.clear();
		// JobManager
		JobManager jobManager=SpringUtil.get("jobManager");
		
		// Initial monitor job
		if(monitors.size()==0){
			logger.info("No running monitoring service");
		}else{
			// 所有监控 Monitor 配置
			MonitorRuntime.allMonitorsOnStartup=monitors;
		}
		
		for (MonitorConfiguration configuration : monitors) {
			
			logger.info(configuration.toString());
			
			if(configuration.getEnable()){
				try {
					jobManager.addJob(configuration);
					// 运行的的监控 Monitor 配置
					MonitorRuntime.runningMonitorsOnStartup.add(configuration);
				} catch (Exception e) {
					logger.error("Add monitor job error!",e);
					MonitorRuntime.errorJobMonitorsOnStartup.add(configuration);
				}
			}
			
		}
		
		
		// ReloadConfiguration job
		jobManager.reloadConfigurationJob();
	}
	
	
	public void start() {
		// 初始化配置
		initMonitorConfig();
		// 初始化Job
		initJob();
		EasyMonitor.started=true;
	}
	
	
	
}
