package cn.easyproject.easymonitor.job;

import java.io.FileInputStream;
import java.io.IOException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

import cn.easyproject.easymonitor.EasyMonitor;
import cn.easyproject.easymonitor.monitor.Monitor;
import cn.easyproject.easymonitor.monitor.StdMonitor;
import cn.easyproject.easymonitor.util.SpringUtil;

/**
 * Auto reload the monitor job when easymonitor.properties update
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class ReloadConfigurationJob extends QuartzJobBean {

	static Logger logger=LoggerFactory.getLogger(ReloadConfigurationJob.class);
	
	public static long propertiesLastModify;
	
	@Override
	protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
		// 检测配置文件是否修改
				if(EasyMonitor.getPropertiesFile()!=null){
					try {
						long lastModify=EasyMonitor.getPropertiesFile().lastModified();
						// 如果配置文件被修改，则停止所有任务，重新加载		
						if(lastModify!=ReloadConfigurationJob.propertiesLastModify){
							EasyMonitor.getProperties().load(new FileInputStream(EasyMonitor.getPropertiesFile()));
							
							ReloadConfigurationJob.propertiesLastModify=lastModify;
							
							JobManager jobManager = SpringUtil.get("jobManager");
							jobManager.clear();
							
							Monitor stdMonitor=new StdMonitor();
							stdMonitor.start();
							logger.info("the EasyMonitor properties file ["+EasyMonitor.getPropertiesFile().getName()+"] already reload." );
						}
						
					} catch (IOException e) {
						logger.error("Read EasyMonitor properties file ["+EasyMonitor.getPropertiesFile().getName()+"]  error.",e );
					}
				}else{
					logger.error("easymonitor.properties file not found.");
				}
		
	}

}
