package cn.easyproject.easymonitor.configuration;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import cn.easyproject.easymonitor.MonitorType;
import cn.easyproject.easymonitor.monitor.validator.MonitorValidator;
import cn.easyproject.easymonitor.sender.Sender;

/**
 * MonitorConfiguration
 * 
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class MonitorConfiguration extends GlobalMonitorConfiguration implements Serializable{

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	
	/**
	 * Monitor Name
	 */
	private String name;
	/**
	 * Monitor Type
	 */
	private MonitorType type;
	
	/**
	 * Monitor value: url, process, port
	 */
	private String value;
	
	/**
	 * Port monitor server
	 */
	private String server;


	/**
	 * User Sender implements
	 */
	private List<Sender> senderImpl;
	
	/**
	 * Monitor Validator 
	 */
	private MonitorValidator monitorValidator;
	
	
	public MonitorType getType() {
		return type;
	}

	public void setType(MonitorType type) {
		this.type = type;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getServer() {
		return server;
	}

	public void setServer(String server) {
		this.server = server;
	}

	

	public MonitorConfiguration() {
		super();
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	

	public List<Sender> getSenderImpl() {
		return senderImpl;
	}

	public void setSenderImpl(List<Sender> senderImpl) {
		this.senderImpl = senderImpl;
	}

	public MonitorValidator getMonitorValidator() {
		return monitorValidator;
	}

	public void setMonitorValidator(MonitorValidator monitorValidator) {
		this.monitorValidator = monitorValidator;
	}

	@Override
	public String toString() {
		return "MonitorConfiguration [name=" + name + ", type=" + type + ", value=" + value + ", server=" + server
				+ ", senderImpl=" + senderImpl + ", monitorValidator=" + monitorValidator + ", enable=" + enable
				+ ", cronExpression=" + cronExpression + ", maxfailure=" + maxfailure + ", mailReceiver="
				+ Arrays.toString(mailReceiver) + ", mailSender=" + mailSender + ", mailSenderInterval="
				+ mailSenderInterval + ", mailSenderHost=" + mailSenderHost + ", mailSenderPort=" + mailSenderPort
				+ ", mailSenderSsl=" + mailSenderSsl + ", mailSenderPassword=******"
				+ ", mailSenderTitle=" + mailSenderTitle + ", mailSenderTemplate=" + mailSenderTemplate + ", cmd="
				+ Arrays.toString(cmd) + ", nowFailure=" + nowFailure + ", monitorError=" + monitorError
				+ ", monitorErrorTime=" + monitorErrorTime + ", lastSenderTime=" + lastSenderTime + ", port=" + port
				+ "]";
	}

}
