package cn.easyproject.easymonitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import cn.easyproject.easymonitor.EasyMonitor;
import cn.easyproject.easymonitor.job.ReloadConfigurationJob;
import cn.easyproject.easymonitor.monitor.Monitor;
import cn.easyproject.easymonitor.monitor.StdMonitor;

/**
 * EasyMonitor Run enter
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class EasyMonitor {

	static Logger logger=LoggerFactory.getLogger(EasyMonitor.class);
	
	public static boolean started = false;
	
	/*
	 * Properties information
	 */
	private static Properties properties=null;
	private static File propertiesFile;
	
	private static File userPropertiesFile;
	
	

	/**
	 * 启动 EasyMonitor
	 */
	public void start() {
		if (!started) {
			
			loadProperties(); // 加载初始化配置
			
			if(propertiesFile!=null){
				
				Monitor stdMonitor=new StdMonitor();
				stdMonitor.start();
				
				logger.info(":");
			}
			
		}else{
			logger.info("EasyMonitor is already started!");
		}
	}
	
	
	/**
	 * 默认配置文件
	 */
	private void loadProperties() {
		// 使用用户自定义 properties  配置文件
		if(EasyMonitor.userPropertiesFile!=null){
			// 使用用户自定义 properties  配置文件
			try {
				EasyMonitor.properties = new Properties();
				EasyMonitor.properties.load(new FileInputStream(userPropertiesFile));
				EasyMonitor.propertiesFile=userPropertiesFile;
				ReloadConfigurationJob.propertiesLastModify = propertiesFile.lastModified();
			} catch (IOException e) {
				logger.error("Read file:easymonitor.properties error.", e);
			}
			return;
		}
		
		// 搜索默认配置文件(运行相对目录；classpath)
		ResourceLoader rl = new PathMatchingResourcePatternResolver();
		Resource res = rl.getResource("file:easymonitor.properties");
		Resource res2 = rl.getResource("classpath:easymonitor.properties");

		if((!res.exists()) && (!res2.exists())){
			logger.error("easymonitor.properties not found.");
			return;
		}else{
			boolean loadProperties=false;
			if (res.exists()) {
				try {
					EasyMonitor.properties = new Properties();
					EasyMonitor.properties.load(res.getInputStream());
					EasyMonitor.propertiesFile=res.getFile();
					ReloadConfigurationJob.propertiesLastModify = propertiesFile.lastModified();
					loadProperties=true;
				} catch (IOException e) {
					logger.error("Read file:easymonitor.properties error.", e);
				}
			}
			
			if(!loadProperties){
				try {
					EasyMonitor.properties = new Properties();
					EasyMonitor.properties.load(res2.getInputStream());
					EasyMonitor.propertiesFile=res2.getFile();
					ReloadConfigurationJob.propertiesLastModify = propertiesFile.lastModified();
				} catch (IOException e) {
					logger.error("Read classpath:easymonitor.properties error.", e);
				}
			}
			
		}
	}
	

	/**
	 * Set your properties file
	 * @param userPropertiesFile easybackup.properties File
	 */
	public static void setPropertiesFile(File userPropertiesFile) {
		EasyMonitor.userPropertiesFile = userPropertiesFile;
	}

	public static File getPropertiesFile() {
		return userPropertiesFile!=null?userPropertiesFile:propertiesFile;
	}
	
	
	
	public static Properties getProperties() {
		return properties;
	}
	
	
	public static void main(String[] args) {
		new EasyMonitor().start();
	}
	
}
