/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easymonitor.sender.mail;

import cn.easyproject.easymonitor.configuration.MonitorConfiguration;
import cn.easyproject.easymonitor.sender.Sender;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

public class MailSender
implements Sender {
    static Logger logger = LoggerFactory.getLogger(MailSender.class);
    static Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
    private JavaMailSenderImpl sender = new JavaMailSenderImpl();

    public void send(MonitorConfiguration monitorConfig) {
        if (monitorConfig.getMailSender() == null || monitorConfig.getMailReceiver() == null || monitorConfig.getMailReceiver().length == 0) {
            logger.warn("You are not configuration Mail Sender or Receiver. Please Check your mail sender and recevier.");
            return;
        }
        try {
            logger.info(monitorConfig.getType().name() + "-" + monitorConfig.getName() + " Monitor Error, start send mail to [" + Arrays.toString(monitorConfig.getMailReceiver()) + "]");
            this.sender.setUsername(monitorConfig.getMailSender());
            this.sender.setPassword(monitorConfig.getMailSenderPassword());
            this.sender.setHost(monitorConfig.getMailSenderHost());
            this.sender.setPort(monitorConfig.getMailSenderPort().intValue());
            Properties senderProperties = new Properties();
            senderProperties.setProperty("mail.smtp.auth", "true");
            if (monitorConfig.getMailSenderSsl().booleanValue()) {
                senderProperties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            this.sender.setJavaMailProperties(senderProperties);
            MimeMessage mm = this.sender.createMimeMessage();
            MimeMessageHelper smm = new MimeMessageHelper(mm, false, "utf-8");
            smm.setFrom(monitorConfig.getMailSender());
            smm.setTo(monitorConfig.getMailReceiver());
            smm.setReplyTo(monitorConfig.getMailSender());
            smm.setSubject(monitorConfig.getMailSenderTitle());
            Template template = cfg.getTemplate(monitorConfig.getMailSenderTemplate());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("type", monitorConfig.getType().name());
            data.put("name", monitorConfig.getName());
            data.put("value", monitorConfig.getValue());
            data.put("stoptime", new Date(monitorConfig.getMonitorErrorTime()));
            data.put("monitorConfiguration", monitorConfig);
            String text = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, data);
            smm.setText(text, true);
            this.sender.send(mm);
            monitorConfig.setMonitorError(true);
            logger.info(monitorConfig.getType().name() + "-" + monitorConfig.getName() + " Monitor Error, already send mail to [" + Arrays.toString(monitorConfig.getMailReceiver()) + "], errortime is: " + monitorConfig.getMonitorErrorTime() + ", lasttime is: " + monitorConfig.getLastSenderTime());
        }
        catch (MailException e) {
            logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + " send mail error, please check you sender configuration", (Throwable)e);
        }
        catch (MessagingException e) {
            logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + " send mail error, please check you sender configuration", (Throwable)e);
        }
        catch (IOException e) {
            logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + " send mail error, please check you sender configuration", (Throwable)e);
        }
        catch (TemplateException e) {
            logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + " send mail template error, please check you mail.tpl configuration", (Throwable)e);
        }
        catch (Exception e) {
            logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + " send mail error, please check you sender configuration", (Throwable)e);
        }
    }

    static {
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setDefaultEncoding("UTF-8");
        try {
            File directory = new File("");
            String courseFile = directory.getCanonicalPath();
            cfg.setDirectoryForTemplateLoading(new File(courseFile, "template"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

