/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easymonitor.monitor.validator;

import cn.easyproject.easymonitor.configuration.MonitorConfiguration;
import cn.easyproject.easymonitor.monitor.validator.MonitorValidator;
import cn.easyproject.easymonitor.monitor.validator.ValidatorResult;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLMonitorValidator
implements MonitorValidator {
    static Logger logger = LoggerFactory.getLogger(URLMonitorValidator.class);

    public ValidatorResult validate(MonitorConfiguration configuration) {
        ValidatorResult result = ValidatorResult.INVALIDATION;
        try {
            String value = configuration.getValue();
            URL url = new URL(value);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.getResponseCode();
            logger.info(configuration.getType().name() + "-" + configuration.getName() + " is runing.");
            result = ValidatorResult.VALIDATION;
        }
        catch (MalformedURLException e) {
            logger.info(configuration.getType().name() + "-" + configuration.getName() + " is ignore runing.");
            result = ValidatorResult.IGNORE;
        }
        catch (IOException e) {
            logger.info(configuration.getType().name() + "-" + configuration.getName() + " is not runing.");
            result = ValidatorResult.INVALIDATION;
        }
        return result;
    }
}

