/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easymonitor.monitor.validator;

import cn.easyproject.easymonitor.configuration.MonitorConfiguration;
import cn.easyproject.easymonitor.monitor.validator.MonitorValidator;
import cn.easyproject.easymonitor.monitor.validator.ValidatorResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMonitorValidator
implements MonitorValidator {
    static Logger logger = LoggerFactory.getLogger(ProcessMonitorValidator.class);

    public ValidatorResult validate(MonitorConfiguration configuration) {
        ValidatorResult result = null;
        boolean run = false;
        String cmd = "ps -ef";
        try {
            String os = System.getProperties().getProperty("os.name");
            if (os != null && os.toLowerCase().contains("windows")) {
                cmd = "tasklist";
            }
            Process proc = Runtime.getRuntime().exec(cmd);
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String info = null;
            while ((info = br.readLine()) != null) {
                if (info.toLowerCase().indexOf(configuration.getValue().toLowerCase()) < 0) continue;
                run = true;
                break;
            }
            if (!run) {
                result = ValidatorResult.INVALIDATION;
                logger.info(configuration.getType().name() + "-" + configuration.getName() + " is not runing.");
            } else {
                result = ValidatorResult.VALIDATION;
                logger.info(configuration.getType().name() + "-" + configuration.getName() + " is runing.");
            }
        }
        catch (IOException e) {
            result = ValidatorResult.IGNORE;
            logger.info(configuration.getType().name() + "-" + configuration.getName() + " is ignore runing.");
        }
        return result;
    }
}

