/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easymonitor.monitor;

import cn.easyproject.easymonitor.MonitorType;
import cn.easyproject.easymonitor.configuration.GlobalMonitorConfiguration;
import cn.easyproject.easymonitor.configuration.MonitorConfiguration;
import cn.easyproject.easymonitor.job.JobManager;
import cn.easyproject.easymonitor.monitor.Monitor;
import cn.easyproject.easymonitor.monitor.validator.MonitorValidator;
import cn.easyproject.easymonitor.monitor.validator.PortMonitorValidator;
import cn.easyproject.easymonitor.monitor.validator.ProcessMonitorValidator;
import cn.easyproject.easymonitor.monitor.validator.URLMonitorValidator;
import cn.easyproject.easymonitor.sender.Sender;
import cn.easyproject.easymonitor.sender.mail.MailSender;
import cn.easyproject.easymonitor.util.EasyMonitorUtil;
import cn.easyproject.easymonitor.util.SpringUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdMonitor
implements Monitor {
    static Logger logger = LoggerFactory.getLogger(StdMonitor.class);
    private static GlobalMonitorConfiguration globalConfig = new GlobalMonitorConfiguration();
    private static List<MonitorConfiguration> monitors = new ArrayList<MonitorConfiguration>();

    public void initMonitorConfig() {
        Properties p = GlobalMonitorConfiguration.properties;
        String globalEnable = p.getProperty("easymonitor.enable", "on");
        String globalCronExpression = p.getProperty("easymonitor.cronexpression", "0/10 * * * * ?");
        String globalCmd = p.getProperty("easymonitor.cmd", null);
        Integer globalMaxfailure = 10;
        try {
            globalMaxfailure = Integer.valueOf(p.getProperty("easymonitor.maxfailure", "10"));
        }
        catch (NumberFormatException e) {
            logger.warn("'easymonitor.maxfailure' is not a integer, use default 10.");
        }
        Integer globalMailPort = 25;
        try {
            globalMailPort = Integer.valueOf(p.getProperty("easymonitor.mail.sender.port", "25"));
        }
        catch (NumberFormatException e) {
            logger.warn("'easymonitor.mail.sender.port' is not a integer, use default 25.");
        }
        Integer globalMailSenderInterval = 0;
        try {
            globalMailSenderInterval = Integer.valueOf(p.getProperty("easymonitor.mail.sender.interval", "0"));
        }
        catch (NumberFormatException e) {
            logger.warn("'easymonitor.mail.sender.interval' is not a integer, use default 0, not repeat.");
        }
        String globalMailReceiver = p.getProperty("easymonitor.mail.receiver", null);
        String globalMailSender = p.getProperty("easymonitor.mail.sender", null);
        String globalMailSenderPassword = p.getProperty("easymonitor.mail.sender.passowrd", null);
        String globalMailSenderHost = p.getProperty("easymonitor.mail.sender.host", null);
        String globalMailSenderSsl = p.getProperty("easymonitor.mail.sender.ssl", null);
        String globalMailSenderTitle = p.getProperty("easymonitor.mail.sender.title", null);
        String globalMailSenderTemplate = p.getProperty("easymonitor.mail.sender.template", null);
        globalConfig.setEnable(EasyMonitorUtil.isTrue(globalEnable));
        globalConfig.setCronExpression(globalCronExpression);
        globalConfig.setCmd(EasyMonitorUtil.isNotEmpty(globalCmd) ? globalCmd.split("##") : null);
        globalConfig.setMaxfailure(globalMaxfailure);
        globalConfig.setMailReceiver(EasyMonitorUtil.isNotEmpty(globalMailReceiver) ? globalMailReceiver.split("##") : null);
        globalConfig.setMailSender(globalMailSender);
        globalConfig.setMailSenderInterval(globalMailSenderInterval);
        globalConfig.setMailSenderPassword(globalMailSenderPassword);
        globalConfig.setMailSenderHost(globalMailSenderHost);
        globalConfig.setMailSenderPort(globalMailPort);
        globalConfig.setMailSenderTitle(globalMailSenderTitle);
        globalConfig.setMailSenderTemplate(globalMailSenderTemplate);
        globalConfig.setMailSenderSsl(EasyMonitorUtil.isTrue(globalMailSenderSsl));
        HashSet<String> configNames = new HashSet<String>();
        Enumeration<?> names = p.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (key.startsWith("easymonitor.url.")) {
                if ((key = key.substring("easymonitor.url.".length())).indexOf(".") != -1) continue;
                configNames.add("URL:" + key);
                continue;
            }
            if (key.startsWith("easymonitor.port.")) {
                if ((key = key.substring("easymonitor.port.".length())).indexOf(".") != -1) continue;
                configNames.add("PORT:" + key);
                continue;
            }
            if (key.startsWith("easymonitor.process.")) {
                if ((key = key.substring("easymonitor.process.".length())).indexOf(".") != -1) continue;
                configNames.add("PROCESS:" + key);
                continue;
            }
            if (!key.startsWith("easymonitor.user.") || (key = key.substring("easymonitor.user.".length())).indexOf(".") != -1) continue;
            configNames.add("USER:" + key);
        }
        logger.debug("configNames: " + configNames);
        for (String name : configNames) {
            String[] senderImpls;
            String senderImpl;
            String cmd;
            String senderTemplate;
            String senderTitle;
            String senderSsl;
            String senderPort;
            String senderHost;
            String senderPassowrd;
            String senderInterval;
            String sender;
            String receiver;
            String maxfailure;
            String cronexpression;
            String server;
            String startWith;
            MonitorConfiguration monitorConfig;
            block45: {
                monitorConfig = new MonitorConfiguration();
                startWith = "easymonitor.url.";
                if (name.startsWith("URL:")) {
                    startWith = "easymonitor.url.";
                    name = name.substring("URL:".length());
                    monitorConfig.setType(MonitorType.URL);
                    monitorConfig.setMonitorValidator(new URLMonitorValidator());
                } else if (name.startsWith("PORT:")) {
                    startWith = "easymonitor.port.";
                    name = name.substring("PORT:".length());
                    monitorConfig.setType(MonitorType.PORT);
                    monitorConfig.setMonitorValidator(new PortMonitorValidator());
                } else if (name.startsWith("PROCESS:")) {
                    startWith = "easymonitor.process.";
                    name = name.substring("PROCESS:".length());
                    monitorConfig.setType(MonitorType.PROCESS);
                    monitorConfig.setMonitorValidator(new ProcessMonitorValidator());
                } else if (name.startsWith("USER:")) {
                    startWith = "easymonitor.user.";
                    name = name.substring("USER:".length());
                    monitorConfig.setType(MonitorType.USER);
                }
                String value = startWith + name;
                String enable = startWith + name + ".enable";
                server = startWith + name + ".server";
                cronexpression = startWith + name + ".cronexpression";
                maxfailure = startWith + name + ".maxfailure";
                receiver = startWith + name + ".mail.receiver";
                sender = startWith + name + ".mail.sender";
                senderInterval = startWith + name + ".mail.sender.interval";
                senderPassowrd = startWith + name + ".mail.sender.passowrd";
                senderHost = startWith + name + ".mail.sender.host";
                senderPort = startWith + name + ".mail.sender.port";
                senderSsl = startWith + name + ".mail.sender.ssl";
                senderTitle = startWith + name + ".mail.sender.title";
                senderTemplate = startWith + name + ".mail.sender.template";
                cmd = startWith + name + ".cmd";
                senderImpl = startWith + name + ".sender.impl";
                String validatorClass = startWith + name + ".validatorClass";
                value = p.getProperty(value, null);
                enable = p.getProperty(enable, null);
                server = p.getProperty(server, null);
                cmd = p.getProperty(cmd, null);
                cronexpression = p.getProperty(cronexpression, null);
                maxfailure = p.getProperty(maxfailure, null);
                receiver = p.getProperty(receiver, null);
                sender = p.getProperty(sender, null);
                senderInterval = p.getProperty(senderInterval, null);
                senderPassowrd = p.getProperty(senderPassowrd, null);
                senderHost = p.getProperty(senderHost, null);
                senderPort = p.getProperty(senderPort, null);
                senderTitle = p.getProperty(senderTitle, null);
                senderTemplate = p.getProperty(senderTemplate, null);
                senderSsl = p.getProperty(senderSsl, null);
                senderImpl = p.getProperty(senderImpl, null);
                validatorClass = p.getProperty(validatorClass, null);
                monitorConfig.setName(name);
                monitorConfig.setValue(value);
                monitorConfig.setEnable(enable != null ? EasyMonitorUtil.isTrue(enable) : globalConfig.getEnable());
                if (monitorConfig.getType() == MonitorType.USER) {
                    if (validatorClass != null) {
                        try {
                            MonitorValidator monitorValidator = (MonitorValidator)Class.forName(validatorClass.trim()).newInstance();
                            monitorConfig.setMonitorValidator(monitorValidator);
                            break block45;
                        }
                        catch (InstantiationException e) {
                            logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + ": '" + "', Can not instance your validatorClass '" + validatorClass + "'.", (Throwable)e);
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + ": '" + "', Can not instance your validatorClass '" + validatorClass + "'.", (Throwable)e);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + ": '" + "', You validatorClass is not found '" + validatorClass + "'.", (Throwable)e);
                            continue;
                        }
                    }
                    logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + ": '" + monitorConfig.getValue() + "', You are not configuration 'easymonitor.user." + monitorConfig.getName() + ".validatorClass'.");
                    continue;
                }
            }
            Integer monitorMaxfailure = globalConfig.getMaxfailure();
            if (maxfailure != null) {
                try {
                    monitorMaxfailure = Integer.valueOf(maxfailure);
                }
                catch (NumberFormatException e) {
                    logger.warn("'" + startWith + name + ".maxfailure' is not a integer, use default " + monitorMaxfailure + ".", (Throwable)e);
                }
            }
            Integer monitorMailPort = globalConfig.getMailSenderPort();
            if (senderPort != null) {
                try {
                    monitorMailPort = Integer.valueOf(senderPort);
                }
                catch (NumberFormatException e) {
                    logger.warn("'" + startWith + name + ".mail.sender.interval' is not a integer, use default " + monitorMailPort + ".", (Throwable)e);
                }
            }
            if (monitorMailPort == null) {
                monitorMailPort = 25;
            }
            int monitorMailSenderInterval = globalConfig.getMailSenderInterval();
            if (senderInterval != null) {
                try {
                    monitorMailSenderInterval = Integer.valueOf(senderInterval);
                }
                catch (NumberFormatException e) {
                    logger.warn("'" + startWith + name + ".mail.sender.port' is not a integer, use default " + monitorMailSenderInterval + ".", (Throwable)e);
                }
            }
            monitorConfig.setCronExpression(cronexpression != null ? cronexpression : globalConfig.getCronExpression());
            monitorConfig.setMaxfailure(monitorMaxfailure);
            monitorConfig.setMailSender(sender != null ? sender : globalConfig.getMailSender());
            monitorConfig.setMailSenderPort(monitorMailPort);
            monitorConfig.setMailSenderInterval(monitorMailSenderInterval);
            monitorConfig.setMailSenderPassword(senderPassowrd != null ? senderPassowrd : globalConfig.getMailSenderPassword());
            monitorConfig.setMailSenderHost(senderHost != null ? senderHost : globalConfig.getMailSenderHost());
            monitorConfig.setMailSenderSsl(senderSsl != null ? EasyMonitorUtil.isTrue(senderSsl) : globalConfig.getMailSenderSsl());
            monitorConfig.setMailSenderTitle(senderTitle != null ? senderTitle : globalConfig.getMailSenderTitle());
            monitorConfig.setMailSenderTemplate(senderTemplate != null ? senderTemplate : globalConfig.getMailSenderTemplate());
            monitorConfig.setMailReceiver(receiver != null ? receiver.split("##") : globalConfig.getMailReceiver());
            monitorConfig.setCmd(cmd != null ? cmd.split("##") : globalConfig.getCmd());
            monitorConfig.setServer(server);
            if (!EasyMonitorUtil.isNotEmpty(monitorConfig.getMailSenderTemplate())) {
                logger.warn("Not configuration '" + startWith + name + ".mail.sender.template'. Use default 'mail.tpl'");
                monitorConfig.setMailSenderTemplate("mail.tpl");
            }
            if (monitorConfig.getType() == MonitorType.PORT) {
                try {
                    int port = Integer.valueOf(monitorConfig.getValue());
                    monitorConfig.setPort(port);
                }
                catch (NumberFormatException e) {
                    logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + ": '" + monitorConfig.getValue() + "' is not a validate integer between 1~65535, the monitor is cancel.", (Throwable)e);
                    continue;
                }
            }
            ArrayList<Sender> userSenders = new ArrayList<Sender>();
            if (senderImpl != null && (senderImpls = senderImpl.split("##")).length > 0) {
                for (String cls : senderImpls) {
                    if ("".equals(cls)) continue;
                    try {
                        Sender userSender = (Sender)Class.forName(cls).newInstance();
                        userSenders.add(userSender);
                    }
                    catch (InstantiationException e) {
                        logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + ": '" + monitorConfig.getValue() + "', the Sender class [" + cls + "] is not implements 'cn.easyproject.easymonitor.sender.Sender' interface.", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + ": '" + monitorConfig.getValue() + "', the Sender class [" + cls + "] is IllegalAccessException.", (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error(monitorConfig.getType().name() + "-" + monitorConfig.getName() + ": '" + monitorConfig.getValue() + "', the Sender class [" + cls + "] is not found.", (Throwable)e);
                    }
                }
            }
            if (monitorConfig.getMailSender() != null && monitorConfig.getMailReceiver() != null && monitorConfig.getMailReceiver().length != 0) {
                userSenders.add(new MailSender());
            }
            monitorConfig.setSenderImpl(userSenders);
            monitors.add(monitorConfig);
        }
    }

    public void initJob() {
        JobManager jobManager = (JobManager)SpringUtil.get("jobManager");
        if (monitors.size() == 0) {
            logger.info("No running monitoring service");
        }
        for (MonitorConfiguration monitorConfig : monitors) {
            logger.info(monitorConfig.toString());
            jobManager.addJob(monitorConfig);
        }
        jobManager.reloadConfigurationJob();
    }

    public void start() {
        this.initMonitorConfig();
        this.initJob();
    }
}

