/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easymonitor.job;

import cn.easyproject.easymonitor.configuration.GlobalMonitorConfiguration;
import cn.easyproject.easymonitor.job.JobManager;
import cn.easyproject.easymonitor.monitor.StdMonitor;
import cn.easyproject.easymonitor.util.SpringUtil;
import java.io.IOException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ReloadConfigurationJob
extends QuartzJobBean {
    static Logger logger = LoggerFactory.getLogger(ReloadConfigurationJob.class);
    public static long propertiesLastModify;

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        PathMatchingResourcePatternResolver rl = new PathMatchingResourcePatternResolver();
        Resource res = rl.getResource("file:easymonitor.properties");
        if (res.exists()) {
            try {
                long lastModify = res.getFile().lastModified();
                if (lastModify != propertiesLastModify) {
                    GlobalMonitorConfiguration.properties.load(res.getInputStream());
                    propertiesLastModify = lastModify;
                    JobManager jobManager = (JobManager)SpringUtil.get("jobManager");
                    jobManager.clear();
                    StdMonitor stdMonitor = new StdMonitor();
                    stdMonitor.start();
                    logger.info("easymonitor.properties already reload.");
                }
            }
            catch (IOException e) {
                logger.error("Read easymonitor.properties error.", (Throwable)e);
            }
        } else {
            logger.error("easymonitor.properties not found.");
        }
    }
}

