/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easymonitor.job;

import cn.easyproject.easymonitor.configuration.MonitorConfiguration;
import cn.easyproject.easymonitor.job.JobManager;
import cn.easyproject.easymonitor.monitor.validator.MonitorValidator;
import cn.easyproject.easymonitor.monitor.validator.ValidatorResult;
import cn.easyproject.easymonitor.sender.Sender;
import cn.easyproject.easymonitor.util.SpringUtil;
import java.io.IOException;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

@DisallowConcurrentExecution
public class MonitorJob
extends QuartzJobBean {
    static Logger logger = LoggerFactory.getLogger(MonitorJob.class);

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        MonitorConfiguration configuration = (MonitorConfiguration)jobDataMap.get((Object)"configuration");
        if (configuration == null) {
            return;
        }
        MonitorValidator monitorValidator = configuration.getMonitorValidator();
        ValidatorResult res = monitorValidator.validate(configuration);
        if (res == ValidatorResult.VALIDATION) {
            this.renewMonitor(configuration);
        } else if (res == ValidatorResult.INVALIDATION) {
            configuration.getNowFailure().incrementAndGet();
        }
        if (configuration.isMonitorError()) {
            logger.info(configuration.getType().name() + "-" + configuration.getName() + " is error status.");
            if (configuration.getMailSenderInterval() != null && configuration.getMailSenderInterval() > 0) {
                if ((System.currentTimeMillis() - configuration.getLastSenderTime()) / 1000L < (long)configuration.getMailSenderInterval().intValue()) {
                    return;
                }
                logger.info(configuration.getType().name() + "-" + configuration.getName() + " repeate send error notify.");
            } else {
                return;
            }
        }
        logger.info(configuration.getType().name() + "-" + configuration.getName() + " failure count: " + configuration.getNowFailure());
        if (configuration.getNowFailure().get() >= configuration.getMaxfailure()) {
            configuration.getNowFailure().set(0);
            long time = System.currentTimeMillis();
            if (configuration.getMonitorErrorTime() == 0L) {
                configuration.setMonitorErrorTime(time);
            }
            configuration.setLastSenderTime(time);
            JobManager jobManager = (JobManager)SpringUtil.get("jobManager");
            jobManager.pauseJob(context);
            for (Sender sender : configuration.getSenderImpl()) {
                sender.send(configuration);
            }
            this.commandExecute(configuration);
            jobManager.resumeJob(context);
        }
    }

    private boolean commandExecute(MonitorConfiguration configuration) {
        String[] cmds;
        boolean res = false;
        for (String cmd : cmds = configuration.getCmd()) {
            try {
                Process proc = Runtime.getRuntime().exec(cmd);
                proc.waitFor();
            }
            catch (IOException e) {
                logger.error(configuration.getType().name() + "-" + configuration.getName() + " execute command [" + cmd + "] error.", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error(configuration.getType().name() + "-" + configuration.getName() + " execute command [" + cmd + "] error.", (Throwable)e);
            }
        }
        return res;
    }

    private void renewMonitor(MonitorConfiguration configuration) {
        configuration.getNowFailure().set(0);
        configuration.setMonitorError(false);
        configuration.setMonitorErrorTime(0L);
        configuration.setLastSenderTime(0L);
    }
}

