/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easymonitor.job;

import cn.easyproject.easymonitor.configuration.MonitorConfiguration;
import cn.easyproject.easymonitor.job.MonitorJob;
import cn.easyproject.easymonitor.job.ReloadConfigurationJob;
import java.util.Date;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager {
    static Logger logger = LoggerFactory.getLogger(JobManager.class);
    Scheduler scheduler;
    private int reloadIntervalInSeconds = 3;

    public void reloadConfigurationJob() {
        String jobGroup = "ReloadConfiguraion";
        String jobName = "EasyMonitor";
        JobKey jobKey = new JobKey(jobName, jobGroup);
        try {
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.deleteJob(jobKey);
            }
        }
        catch (SchedulerException e1) {
            logger.error("delete job [" + jobKey + "] error.", (Throwable)e1);
        }
        try {
            if (this.scheduler.checkExists(jobKey)) {
                jobKey = new JobKey(jobName + "_" + new Date().getTime(), jobGroup);
            }
        }
        catch (SchedulerException e1) {
            jobKey = new JobKey(jobName + "_" + new Date().getTime(), jobGroup);
        }
        JobDetail jobDetail = JobBuilder.newJob(ReloadConfigurationJob.class).withIdentity(jobKey).build();
        TriggerKey triggerKey = new TriggerKey(jobKey.getName(), jobKey.getGroup());
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(this.reloadIntervalInSeconds).repeatForever()).build();
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            logger.error("ReloadConfiguration Job can not fire!", (Throwable)e);
        }
    }

    public void addJob(MonitorConfiguration configuration) {
        if (configuration.getEnable().booleanValue()) {
            String jobGroup = configuration.getType().name();
            String jobName = jobGroup + "_" + configuration.getName();
            JobKey jobKey = new JobKey(jobName, jobGroup);
            try {
                if (this.scheduler.checkExists(jobKey)) {
                    this.scheduler.deleteJob(jobKey);
                }
            }
            catch (SchedulerException e1) {
                logger.error("delete job [" + jobKey + "] error.", (Throwable)e1);
            }
            try {
                if (this.scheduler.checkExists(jobKey)) {
                    jobKey = new JobKey(jobName + "_" + new Date().getTime(), jobGroup);
                }
            }
            catch (SchedulerException e1) {
                jobKey = new JobKey(jobName + "_" + new Date().getTime(), jobGroup);
            }
            JobDetail jobDetail = JobBuilder.newJob(MonitorJob.class).withIdentity(jobKey).build();
            TriggerKey triggerKey = new TriggerKey(jobKey.getName(), jobKey.getGroup());
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)configuration.getCronExpression()).withMisfireHandlingInstructionDoNothing()).build();
            jobDetail.getJobDataMap().put("configuration", (Object)configuration);
            try {
                this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            }
            catch (SchedulerException e) {
                logger.error("Your Job can not fire! [" + configuration + "]", (Throwable)e);
            }
        }
    }

    public void pauseJob(JobExecutionContext context) {
        JobKey key = context.getJobDetail().getKey();
        try {
            context.getScheduler().pauseJob(key);
        }
        catch (SchedulerException e) {
            logger.error("Your Job pause failure! [" + key + "]", (Throwable)e);
        }
    }

    public void resumeJob(JobExecutionContext context) {
        JobKey key = context.getJobDetail().getKey();
        try {
            context.getScheduler().resumeJob(key);
        }
        catch (SchedulerException e) {
            logger.error("Your Job pause failure! [" + key + "]", (Throwable)e);
        }
    }

    public void deleteJob(JobExecutionContext context) {
        JobKey key = context.getJobDetail().getKey();
        try {
            context.getScheduler().deleteJob(key);
        }
        catch (SchedulerException e) {
            logger.error("Your Job delete failure! [" + key + "]", (Throwable)e);
        }
    }

    public void clear() {
        try {
            this.scheduler.clear();
        }
        catch (SchedulerException e) {
            logger.error("Can not reload properties, clear job failure!", (Throwable)e);
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

