package cn.easyproject.easymonitor.monitor.validator;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.easyproject.easymonitor.configuration.MonitorConfiguration;

/**
 * URL MonitorValidator
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class URLMonitorValidator implements MonitorValidator{
	
	static Logger logger=LoggerFactory.getLogger(URLMonitorValidator.class);
	
	/**
	 * 检查URL是否存在
	 * @param configuration 配置对象
	 * @return 是否成功
	 */
	public ValidatorResult validate(MonitorConfiguration configuration) {
		ValidatorResult result= ValidatorResult.INVALIDATION;
		try {
			String value = configuration.getValue();
			URL url = new URL(value);
			HttpURLConnection con = (HttpURLConnection) url.openConnection();
			con.getResponseCode();

			logger.info(configuration.getType().name() + "-" + configuration.getName() + " is runing.");

			// 程序恢复，则重置错误标识
			result = ValidatorResult.VALIDATION;
		} catch (MalformedURLException e) {
//			logger.error(
//					configuration.getType().name() + "-" + configuration.getName() + " happen MalformedURLException.",
//					e);
			logger.info(
					configuration.getType().name() + "-" + configuration.getName() + " is ignore runing.");
			result=ValidatorResult.IGNORE;
		} catch (IOException e) {
			logger.info(
					configuration.getType().name() + "-" + configuration.getName() + " is not runing.");
			result = ValidatorResult.INVALIDATION;
		}
		return result;
	}
	
}
