package cn.easyproject.easymonitor.monitor.validator;

import java.io.IOException;
import java.net.Socket;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.easyproject.easymonitor.configuration.MonitorConfiguration;

/**
 * Port MonitorValidator
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class PortMonitorValidator implements MonitorValidator{

	static Logger logger=LoggerFactory.getLogger(PortMonitorValidator.class);
	
	public ValidatorResult validate(MonitorConfiguration configuration) {
		ValidatorResult result=null;
		try {
			Socket socket = new Socket(configuration.getServer(), configuration.getPort());
			socket.close();
			logger.info(configuration.getType().name() + "-" + configuration.getName() + " is runing.");

			result = ValidatorResult.VALIDATION;
		} catch (IOException e) {
			logger.info(
					configuration.getType().name() + "-" + configuration.getName() + " is not runing.");
//			logger.error(
//					configuration.getType().name() + "-" + configuration.getName() + " happen MalformedURLException.",
//					e);
			result= ValidatorResult.INVALIDATION;
		}
		
		return result;
	}

}
