package cn.easyproject.easymonitor.job;

import java.io.IOException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.scheduling.quartz.QuartzJobBean;

import cn.easyproject.easymonitor.configuration.GlobalMonitorConfiguration;
import cn.easyproject.easymonitor.monitor.Monitor;
import cn.easyproject.easymonitor.monitor.StdMonitor;
import cn.easyproject.easymonitor.util.SpringUtil;

/**
 * Auto reload the monitor job when easymonitor.properties update
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class ReloadConfigurationJob extends QuartzJobBean {

	static Logger logger=LoggerFactory.getLogger(ReloadConfigurationJob.class);
	
	public static long propertiesLastModify;
	
	@Override
	protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
		// 检测配置文件是否修改
		ResourceLoader rl=new PathMatchingResourcePatternResolver();
		Resource res = rl.getResource("file:easymonitor.properties");
		
		if(res.exists()){
			try {
				long lastModify=res.getFile().lastModified();
				// 如果配置文件被修改，则停止所有任务，重新加载		
				if(lastModify!=ReloadConfigurationJob.propertiesLastModify){
					GlobalMonitorConfiguration.properties.load(res.getInputStream());
					ReloadConfigurationJob.propertiesLastModify=lastModify;
					
					JobManager jobManager = SpringUtil.get("jobManager");
					jobManager.clear();
					
					Monitor stdMonitor=new StdMonitor();
					stdMonitor.start();
					logger.info("easymonitor.properties already reload." );
				}
				
			} catch (IOException e) {
				logger.error("Read easymonitor.properties error.",e );
			}
		}else{
			logger.error("easymonitor.properties not found.");
		}
		
	}

}
