package cn.easyproject.easymonitor;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import cn.easyproject.easymonitor.configuration.GlobalMonitorConfiguration;
import cn.easyproject.easymonitor.job.ReloadConfigurationJob;
import cn.easyproject.easymonitor.monitor.Monitor;
import cn.easyproject.easymonitor.monitor.StdMonitor;

/**
 * EasyMonitor Run enter
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class EasyMonitor {

	static Logger logger=LoggerFactory.getLogger(EasyMonitor.class);
	
	
	/**
	 * 初始化配置数据
	 */
	public  void start(){
		ResourceLoader rl=new PathMatchingResourcePatternResolver();
		Resource res = rl.getResource("file:easymonitor.properties");
		
		if(res.exists()){
			GlobalMonitorConfiguration.properties=new Properties();
			try {
				GlobalMonitorConfiguration.properties.load(res.getInputStream());
				ReloadConfigurationJob.propertiesLastModify=res.getFile().lastModified();
				
				Monitor stdMonitor=new StdMonitor();
				stdMonitor.start();
			} catch (IOException e) {
				logger.error("Read easymonitor.properties error.",e );
			}
		}else{
			logger.error("easymonitor.properties not found.");
		}

	}
	
	public static void main(String[] args) {
		new EasyMonitor().start();
	}
	
}
