package cn.easyproject.easymonitor.monitor.validator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.easyproject.easymonitor.configuration.MonitorConfiguration;

/**
 * Process MonitorValidator
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class ProcessMonitorValidator implements MonitorValidator{
	
	static Logger logger=LoggerFactory.getLogger(ProcessMonitorValidator.class);

	public ValidatorResult validate(MonitorConfiguration configuration) {
		ValidatorResult result=null;

		boolean run=false;
//		String[] cmd = { "sh", "-c", "ps -ef | grep java" };
		String cmd = "ps -ef";
		
		try {
			String os = System.getProperties().getProperty("os.name");
			// other os
			if (os != null && os.toLowerCase().contains("windows")) {
				// windows
				cmd = "tasklist";
			}

			Process proc = Runtime.getRuntime().exec(cmd);

			BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
			String info = null;
			while ((info = br.readLine()) != null) {
				if (info.toLowerCase().indexOf(configuration.getValue().toLowerCase()) >= 0) {
					run = true;
					break;
				}
			}
			
			
			if (!run) {
				result=ValidatorResult.INVALIDATION;
				logger.info(configuration.getType().name() + "-" + configuration.getName() + " is not runing.");
			}else{
				result=ValidatorResult.VALIDATION;
				logger.info(configuration.getType().name() + "-" + configuration.getName() + " is runing.");
			}

		} catch (IOException e) {
			// 命令执行错误，不计入错误统计
			result=ValidatorResult.IGNORE;
//			logger.error(configuration.getType().name() + "-" + configuration.getName() + " check process happen error, "
//					+ "Command [" + cmd + "] can not execute", e);
			
			logger.info(
					configuration.getType().name() + "-" + configuration.getName() + " is ignore runing.");
		}

		return result;
	}

}
