package cn.easyproject.easymonitor.configuration;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Global MonitorConfiguration
 * 
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class GlobalMonitorConfiguration {
	
	
	/*
	 * Properties information
	 */
	public static Properties properties;

	
	
	/**
	 * Turn EasyMonitor ON or OFF
	 */
	protected Boolean enable;
	/**
	 * Monitor trigger Cron-Expressions; default is '0/10 * * * * ?'
	 */
	protected String cronExpression;
	
	/**
	 * Max failure count
	 */
	protected Integer maxfailure=1;
	
	/**
	 * Monitor Mail receiver
	 */
	protected String[] mailReceiver;
	
	/**
	 * Monitor Mail sender
	 */
	protected String mailSender;
	
	/**
	 * When error repeat send mail interval(seconds); default is 0, not repeat
	 */
	protected Integer mailSenderInterval=0;
	
	/**
	 * Monitor Mail sender host(smtp.xxx.xxx)
	 */
	protected String mailSenderHost;
	
	/**
	 * Monitor Mail sender port, default is 25
	 */
	protected Integer mailSenderPort=25;
	
	/**
	 * Monitor Mail sender whether ssl, default is false
	 */
	protected Boolean mailSenderSsl=false;
	/**
	 * Monitor Mail sender password
	 */
	protected String mailSenderPassword;
	/**
	 * Monitor Mail sender title
	 */
	protected String mailSenderTitle;
	/**
	 * Monitor Mail sender template
	 */
	protected String mailSenderTemplate;
	
	
	/**
	 * Execute Command
	 */
	protected String cmd[];
	

	/**
	 * Now failure count
	 */
	protected AtomicInteger nowFailure=new AtomicInteger(0);

	/**
	 *  Current monitor whether is Error
	 */
	protected boolean monitorError=false;
	
	/**
	 * The time of monitor found error
	 */
	protected long monitorErrorTime=0;
	
	/**
	 * The time of last sender notify
	 */
	protected long lastSenderTime;
	
	/**
	 * PORT monitor value
	 */
	protected int port;
	
	
	public GlobalMonitorConfiguration() {
		super();
	}
	
	
	public Boolean getEnable() {
		return enable;
	}
	public void setEnable(Boolean enable) {
		this.enable = enable;
	}
	
	public String getCronExpression() {
		return cronExpression;
	}
	public void setCronExpression(String cronExpression) {
		this.cronExpression = cronExpression;
	}
	public String[] getMailReceiver() {
		return mailReceiver;
	}
	public void setMailReceiver(String[] mailReceiver) {
		this.mailReceiver = mailReceiver;
	}
	public String getMailSender() {
		return mailSender;
	}
	public void setMailSender(String mailSender) {
		this.mailSender = mailSender;
	}
	public String getMailSenderPassword() {
		return mailSenderPassword;
	}
	public void setMailSenderPassword(String mailSenderPassword) {
		this.mailSenderPassword = mailSenderPassword;
	}
	public String[] getCmd() {
		return cmd;
	}
	public void setCmd(String[] cmd) {
		this.cmd = cmd;
	}
	
	
	public Integer getMaxfailure() {
		return maxfailure;
	}
	public void setMaxfailure(Integer maxfailure) {
		this.maxfailure = maxfailure;
	}


	
	public String getMailSenderHost() {
		return mailSenderHost;
	}
	public void setMailSenderHost(String mailSenderHost) {
		this.mailSenderHost = mailSenderHost;
	}
	
	public Boolean getMailSenderSsl() {
		return mailSenderSsl;
	}
	public void setMailSenderSsl(Boolean mailSenderSsl) {
		this.mailSenderSsl = mailSenderSsl;
	}
	public AtomicInteger getNowFailure() {
		return nowFailure;
	}
	public void setNowFailure(AtomicInteger nowFailure) {
		this.nowFailure = nowFailure;
	}
	public Integer getMailSenderPort() {
		return mailSenderPort;
	}
	public void setMailSenderPort(Integer mailSenderPort) {
		this.mailSenderPort = mailSenderPort;
	}
	public String getMailSenderTitle() {
		return mailSenderTitle;
	}
	public void setMailSenderTitle(String mailSenderTitle) {
		this.mailSenderTitle = mailSenderTitle;
	}
	public String getMailSenderTemplate() {
		return mailSenderTemplate;
	}
	public void setMailSenderTemplate(String mailSenderTemplate) {
		this.mailSenderTemplate = mailSenderTemplate;
	}
	public Integer getMailSenderInterval() {
		return mailSenderInterval;
	}
	public void setMailSenderInterval(Integer mailSenderInterval) {
		this.mailSenderInterval = mailSenderInterval;
	}
	public boolean isMonitorError() {
		return monitorError;
	}
	public void setMonitorError(boolean monitorError) {
		this.monitorError = monitorError;
	}


	public long getMonitorErrorTime() {
		return monitorErrorTime;
	}


	public void setMonitorErrorTime(long monitorErrorTime) {
		this.monitorErrorTime = monitorErrorTime;
	}


	public long getLastSenderTime() {
		return lastSenderTime;
	}


	public void setLastSenderTime(long lastSenderTime) {
		this.lastSenderTime = lastSenderTime;
	}


	public int getPort() {
		return port;
	}


	public void setPort(int port) {
		this.port = port;
	}


	
	
}
