/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easycommons.imageutils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class EasyImageWaterMarkUtils {
    public static final void imageWatermark(File waterImgFile, File sourceImgFile) {
        try {
            BufferedImage src = ImageIO.read(sourceImgFile);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage waterImg = ImageIO.read(waterImgFile);
            int width_target = ((Image)waterImg).getWidth(null);
            int height_target = ((Image)waterImg).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = (Graphics2D)image.getGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.drawImage(waterImg, width - width_target - 10, height - height_target - 10, width_target, height_target, null);
            g.dispose();
            ImageIO.write((RenderedImage)image, "png", sourceImgFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void imageWatermark(File waterImgFile, File sourceImgFile, File targetImgFile) {
        try {
            BufferedImage src = ImageIO.read(sourceImgFile);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage waterImg = ImageIO.read(waterImgFile);
            int width_target = ((Image)waterImg).getWidth(null);
            int height_target = ((Image)waterImg).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = (Graphics2D)image.getGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.drawImage(waterImg, width - width_target - 10, height - height_target - 10, width_target, height_target, null);
            g.dispose();
            ImageIO.write((RenderedImage)image, "png", targetImgFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void imageWatermark(Object waterImgFile, Object sourceImgFile) {
        File watermarkFile = null;
        File targetFile = null;
        watermarkFile = waterImgFile instanceof File ? (File)waterImgFile : new File(waterImgFile.toString());
        targetFile = sourceImgFile instanceof File ? (File)sourceImgFile : new File(sourceImgFile.toString());
        EasyImageWaterMarkUtils.imageWatermark(watermarkFile, targetFile);
    }

    public static final void imageWatermark(Object waterImgFile, Object sourceImgFile, Object targetImgFile) {
        File watermarkFile = null;
        File sourceFile = null;
        File targetFile = null;
        watermarkFile = waterImgFile instanceof File ? (File)waterImgFile : new File(waterImgFile.toString());
        sourceFile = sourceImgFile instanceof File ? (File)sourceImgFile : new File(sourceImgFile.toString());
        targetFile = targetImgFile instanceof File ? (File)targetImgFile : new File(targetImgFile.toString());
        EasyImageWaterMarkUtils.imageWatermark(watermarkFile, sourceFile, targetFile);
    }

    public static final void textWatermark(File sourceImgFile, String content) {
        BufferedImage originalImg = null;
        try {
            originalImg = ImageIO.read(sourceImgFile);
            int width = ((Image)originalImg).getWidth(null);
            int height = ((Image)originalImg).getHeight(null);
            int fontSize = 15;
            double excursionWidth = (double)content.length() * ((double)fontSize / 1.9);
            double excursionHeight = (double)fontSize / 2.8;
            if ((double)width - excursionWidth > 200.0 && height - fontSize > 200) {
                BufferedImage newImg = new BufferedImage(width, height, 1);
                Graphics2D g = newImg.createGraphics();
                g.setColor(Color.BLACK);
                g.setFont(new Font("Arial", 0, fontSize));
                g.setColor(Color.RED);
                g.setBackground(Color.white);
                Font font = new Font("\u534e\u6587\u5f69\u4e91", 0, fontSize);
                g.setFont(font);
                g.drawImage((Image)originalImg, 0, 0, null);
                BufferedImage bottom_image = new BufferedImage(width, (int)((double)fontSize + excursionHeight), 2);
                Graphics2D g2 = bottom_image.createGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
                Color color = new Color(219, 219, 219);
                g2.setColor(color);
                g2.fillRect(0, 0, width, bottom_image.getHeight());
                g.drawImage(bottom_image, 0, height - bottom_image.getHeight(), width, bottom_image.getHeight(), null);
                int x = (int)((double)width - excursionWidth);
                int y = (int)((double)height - excursionHeight);
                g.drawString(content, x, y);
                g.dispose();
                ImageIO.write((RenderedImage)newImg, "png", sourceImgFile);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static final void textWatermark(File sourceImgFile, String content, File targetImgFile) {
        BufferedImage originalImg = null;
        try {
            originalImg = ImageIO.read(sourceImgFile);
            int width = ((Image)originalImg).getWidth(null);
            int height = ((Image)originalImg).getHeight(null);
            int fontSize = 15;
            double excursionWidth = (double)content.length() * ((double)fontSize / 1.9);
            double excursionHeight = (double)fontSize / 2.8;
            if ((double)width - excursionWidth > 200.0 && height - fontSize > 200) {
                BufferedImage newImg = new BufferedImage(width, height, 1);
                Graphics2D g = newImg.createGraphics();
                g.setColor(Color.BLACK);
                g.setFont(new Font("Arial", 0, fontSize));
                g.setColor(Color.RED);
                g.setBackground(Color.white);
                Font font = new Font("\u534e\u6587\u5f69\u4e91", 0, fontSize);
                g.setFont(font);
                g.drawImage((Image)originalImg, 0, 0, null);
                BufferedImage bottom_image = new BufferedImage(width, (int)((double)fontSize + excursionHeight), 2);
                Graphics2D g2 = bottom_image.createGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
                Color color = new Color(219, 219, 219);
                g2.setColor(color);
                g2.fillRect(0, 0, width, bottom_image.getHeight());
                g.drawImage(bottom_image, 0, height - bottom_image.getHeight(), width, bottom_image.getHeight(), null);
                int x = (int)((double)width - excursionWidth);
                int y = (int)((double)height - excursionHeight);
                g.drawString(content, x, y);
                g.dispose();
                ImageIO.write((RenderedImage)newImg, "png", targetImgFile);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static final void textWatermark(Object sourceImgFile, String content) {
        File targetFile = null;
        targetFile = sourceImgFile instanceof File ? (File)sourceImgFile : new File(sourceImgFile.toString());
        EasyImageWaterMarkUtils.textWatermark(targetFile, content);
    }

    public static final void textWatermark(Object sourceImgFile, String content, Object targetImgFile) {
        File targetFile = null;
        File sourceFile = null;
        targetFile = sourceImgFile instanceof File ? (File)sourceImgFile : new File(sourceImgFile.toString());
        sourceFile = targetImgFile instanceof File ? (File)targetImgFile : new File(targetImgFile.toString());
        EasyImageWaterMarkUtils.textWatermark(sourceFile, content, targetFile);
    }
}

