/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easycommons.imageutils;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;

public class EasyImageCompressionUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean bisToBos(BufferedInputStream bis, BufferedOutputStream bos) {
        boolean flag = false;
        try {
            byte[] buf = new byte[8192];
            int len = bis.read(buf);
            while (-1 != len) {
                bos.write(buf, 0, len);
                len = bis.read(buf);
            }
            flag = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != bis) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != bos) {
                try {
                    bos.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compressByMaxHeightCore(InputStream is, File sourceFile, File toFile, int maxHeight) {
        boolean flag = false;
        OutputStream out = null;
        BufferedImage img = null;
        try {
            img = ImageIO.read(is);
            if (img.getWidth(null) != -1) {
                double nowHeight = img.getHeight(null);
                if (nowHeight > (double)maxHeight) {
                    int newHeight = maxHeight;
                    double rate = nowHeight / (double)maxHeight;
                    int newWidth = (int)((double)img.getWidth(null) / rate);
                    BufferedImage tag = new BufferedImage(newWidth, newHeight, 1);
                    Image i = img.getScaledInstance(newWidth, newHeight, 4);
                    tag.getGraphics().drawImage(i, 0, 0, null);
                    out = new FileOutputStream(toFile);
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                    encoder.encode(tag);
                    flag = true;
                } else {
                    flag = sourceFile != null ? (sourceFile == toFile || sourceFile.getCanonicalFile().equals(toFile.getCanonicalFile()) ? true : EasyImageCompressionUtils.saveFile(sourceFile, toFile)) : EasyImageCompressionUtils.saveFile(is, toFile);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compressByMaxWidthAndMaxHeightCore(InputStream is, File sourceFile, File toFile, int maxWidth, int maxHeight) {
        boolean flag = false;
        OutputStream out = null;
        BufferedImage img = null;
        try {
            img = ImageIO.read(is);
            if (img.getWidth(null) != -1) {
                int newWidth = 0;
                int newHeight = 0;
                if ((double)img.getWidth(null) > (double)maxWidth || (double)img.getHeight(null) > (double)maxHeight) {
                    double rate2;
                    double rate1 = (double)img.getWidth(null) / (double)maxWidth + 0.1;
                    double rate = rate1 > (rate2 = (double)img.getHeight(null) / (double)maxHeight + 0.1) ? rate1 : rate2;
                    newWidth = (int)((double)img.getWidth(null) / rate);
                    newHeight = (int)((double)img.getHeight(null) / rate);
                    BufferedImage tag = new BufferedImage(newWidth, newHeight, 1);
                    Image i = img.getScaledInstance(newWidth, newHeight, 4);
                    tag.getGraphics().drawImage(i, 0, 0, null);
                    out = new FileOutputStream(toFile);
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                    encoder.encode(tag);
                    flag = true;
                } else {
                    flag = sourceFile != null ? (sourceFile == toFile || sourceFile.getCanonicalFile().equals(toFile.getCanonicalFile()) ? true : EasyImageCompressionUtils.saveFile(sourceFile, toFile)) : EasyImageCompressionUtils.saveFile(is, toFile);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compressByMaxWidthCore(InputStream is, File sourceFile, File toFile, int maxWidth) {
        boolean flag = false;
        OutputStream out = null;
        BufferedImage img = null;
        try {
            img = ImageIO.read(is);
            if (img.getWidth(null) != -1) {
                double nowWidth = img.getWidth(null);
                if (nowWidth > (double)maxWidth) {
                    int newWidth = maxWidth;
                    double rate = nowWidth / (double)maxWidth;
                    int newHeight = (int)((double)img.getHeight(null) / rate);
                    BufferedImage tag = new BufferedImage(newWidth, newHeight, 1);
                    Image i = img.getScaledInstance(newWidth, newHeight, 4);
                    tag.getGraphics().drawImage(i, 0, 0, null);
                    out = new FileOutputStream(toFile);
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                    encoder.encode(tag);
                    flag = true;
                } else {
                    flag = sourceFile != null ? (sourceFile == toFile || sourceFile.getCanonicalFile().equals(toFile.getCanonicalFile()) ? true : EasyImageCompressionUtils.saveFile(sourceFile, toFile)) : EasyImageCompressionUtils.saveFile(is, toFile);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compressByWidthAndHeightCore(InputStream is, File sourceFile, File toFile, int width, int height) {
        boolean flag = false;
        OutputStream out = null;
        BufferedImage img = null;
        try {
            img = ImageIO.read(is);
            if (img.getWidth(null) != -1) {
                double nowWidth = img.getWidth(null);
                double nowHeight = img.getHeight(null);
                if (nowWidth != (double)width || nowHeight != (double)height) {
                    int newWidth = width;
                    int newHeight = height;
                    if (newWidth == -1) {
                        newWidth = (int)nowWidth;
                    }
                    if (newHeight == -1) {
                        newWidth = (int)nowHeight;
                    }
                    BufferedImage tag = new BufferedImage(newWidth, newHeight, 1);
                    Image i = img.getScaledInstance(newWidth, newHeight, 4);
                    tag.getGraphics().drawImage(i, 0, 0, null);
                    out = new FileOutputStream(toFile);
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                    encoder.encode(tag);
                    flag = true;
                } else {
                    flag = sourceFile != null ? (sourceFile == toFile || sourceFile.getCanonicalFile().equals(toFile.getCanonicalFile()) ? true : EasyImageCompressionUtils.saveFile(sourceFile, toFile)) : EasyImageCompressionUtils.saveFile(is, toFile);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public static boolean compressPicByMaxHeight(File sourceFile, File toFile, int maxHeight) {
        boolean flag = false;
        FileInputStream is = null;
        try {
            is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByMaxHeightCore(is, sourceFile, toFile, maxHeight);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxHeight(File sourceFile, int maxHeight) {
        boolean flag = false;
        File toFile = sourceFile;
        try {
            FileInputStream is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByMaxHeightCore(is, toFile, sourceFile, maxHeight);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxHeight(File sourceFile, String toPath, int maxHeight) {
        boolean flag = false;
        FileInputStream is = null;
        File toFile = new File(toPath);
        try {
            is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByMaxHeightCore(is, sourceFile, toFile, maxHeight);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxHeight(String fromPath, File toFile, int maxHeight) {
        boolean flag = false;
        InputStream is = null;
        File sourceFile = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByMaxHeightCore(is, sourceFile, toFile, maxHeight);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxHeight(String fromPath, int maxHeight) {
        File sourceFile;
        boolean flag = false;
        File toFile = sourceFile = null;
        InputStream is = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByMaxHeightCore(is, sourceFile, toFile, maxHeight);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxHeight(String fromPath, String toPath, int maxHeight) {
        boolean flag = false;
        File sourceFile = null;
        File toFile = new File(toPath);
        InputStream is = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByMaxHeightCore(is, sourceFile, toFile, maxHeight);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidth(File sourceFile, File toFile, int maxWidth) {
        boolean flag = false;
        FileInputStream is = null;
        try {
            is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByMaxWidthCore(is, sourceFile, toFile, maxWidth);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidth(File sourceFile, int maxWidth) {
        boolean flag = false;
        File toFile = sourceFile;
        try {
            FileInputStream is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByMaxWidthCore(is, toFile, sourceFile, maxWidth);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidth(File sourceFile, String toPath, int maxWidth) {
        boolean flag = false;
        FileInputStream is = null;
        File toFile = new File(toPath);
        try {
            is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByMaxWidthCore(is, sourceFile, toFile, maxWidth);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidth(String fromPath, File toFile, int maxWidth) {
        boolean flag = false;
        InputStream is = null;
        File sourceFile = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByMaxWidthCore(is, sourceFile, toFile, maxWidth);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidth(String fromPath, int maxWidth) {
        File sourceFile;
        boolean flag = false;
        File toFile = sourceFile = null;
        InputStream is = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByMaxWidthCore(is, sourceFile, toFile, maxWidth);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidth(String fromPath, String toPath, int maxWidth) {
        boolean flag = false;
        File sourceFile = null;
        File toFile = new File(toPath);
        InputStream is = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByMaxWidthCore(is, sourceFile, toFile, maxWidth);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidthAndMaxHeight(File sourceFile, File toFile, int maxWidth, int maxHeight) {
        boolean flag = false;
        FileInputStream is = null;
        try {
            is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByMaxWidthAndMaxHeightCore(is, sourceFile, toFile, maxWidth, maxHeight);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidthAndMaxHeight(File sourceFile, int maxWidth, int maxHeight) {
        boolean flag = false;
        File toFile = sourceFile;
        try {
            FileInputStream is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByMaxWidthAndMaxHeightCore(is, toFile, sourceFile, maxWidth, maxHeight);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidthAndMaxHeight(File sourceFile, String toPath, int maxWidth, int maxHeight) {
        boolean flag = false;
        FileInputStream is = null;
        File toFile = new File(toPath);
        try {
            is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByMaxWidthAndMaxHeightCore(is, sourceFile, toFile, maxWidth, maxHeight);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidthAndMaxHeight(String fromPath, File toFile, int maxWidth, int maxHeight) {
        boolean flag = false;
        InputStream is = null;
        File sourceFile = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByMaxWidthAndMaxHeightCore(is, sourceFile, toFile, maxWidth, maxHeight);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidthAndMaxHeight(String fromPath, int maxWidth, int maxHeight) {
        File sourceFile;
        boolean flag = false;
        File toFile = sourceFile = null;
        InputStream is = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByMaxWidthAndMaxHeightCore(is, sourceFile, toFile, maxWidth, maxHeight);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByMaxWidthAndMaxHeight(String fromPath, String toPath, int maxWidth, int maxHeight) {
        boolean flag = false;
        File sourceFile = null;
        File toFile = new File(toPath);
        InputStream is = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByMaxWidthAndMaxHeightCore(is, sourceFile, toFile, maxWidth, maxHeight);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByWidthAndHeight(File sourceFile, File toFile, int width, int height) {
        boolean flag = false;
        FileInputStream is = null;
        try {
            is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByWidthAndHeightCore(is, sourceFile, toFile, width, height);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByWidthAndHeight(File sourceFile, int width, int height) {
        boolean flag = false;
        File toFile = sourceFile;
        try {
            FileInputStream is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByWidthAndHeightCore(is, toFile, sourceFile, width, height);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByWidthAndHeight(File sourceFile, String toPath, int width, int height) {
        boolean flag = false;
        FileInputStream is = null;
        File toFile = new File(toPath);
        try {
            is = new FileInputStream(sourceFile);
            flag = EasyImageCompressionUtils.compressByWidthAndHeightCore(is, sourceFile, toFile, width, height);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByWidthAndHeight(String fromPath, File toFile, int width, int height) {
        boolean flag = false;
        InputStream is = null;
        File sourceFile = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByWidthAndHeightCore(is, sourceFile, toFile, width, height);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByWidthAndHeight(String fromPath, int width, int height) {
        File sourceFile;
        boolean flag = false;
        File toFile = sourceFile = null;
        InputStream is = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByWidthAndHeightCore(is, sourceFile, toFile, width, height);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compressPicByWidthAndHeight(String fromPath, String toPath, int width, int height) {
        boolean flag = false;
        File sourceFile = null;
        File toFile = new File(toPath);
        InputStream is = null;
        try {
            if (fromPath.toLowerCase().startsWith("http://")) {
                URL u = new URL(fromPath);
                is = u.openStream();
            } else {
                sourceFile = new File(fromPath);
                is = new FileInputStream(sourceFile);
            }
            flag = EasyImageCompressionUtils.compressByWidthAndHeightCore(is, sourceFile, toFile, width, height);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    private static boolean saveFile(File sourceFile, File toFile) {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        boolean fileFlag = false;
        try {
            bis = new BufferedInputStream(new FileInputStream(sourceFile));
            bos = new BufferedOutputStream(new FileOutputStream(toFile));
            fileFlag = EasyImageCompressionUtils.bisToBos(bis, bos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return fileFlag;
    }

    private static boolean saveFile(InputStream is, File toFile) {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        boolean fileFlag = false;
        try {
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream(new FileOutputStream(toFile));
            fileFlag = EasyImageCompressionUtils.bisToBos(bis, bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileFlag;
    }
}

