package ${pkgName}.service;

import java.util.List;
import java.io.Serializable;

import org.springframework.transaction.annotation.Transactional;

import ${pkgName}.criteria.${ClassName}Criteria;
import ${pkgName}.entity.${ClassName};
import ${pageBeanImport};

/**
 * ${ClassName} Service, generated by EasyAuto
 * @author easyproject.cn
 * @version 1.0
 *
 */
@Transactional
public interface ${ClassName}Service {
	
	/**
	 * Save
	 * @param o Object
	 */
	public void save(${ClassName} o);
	
	/**
	 * Delete Object
	 * @param id oid
	 */
	public void delete(Serializable id);
<#if Oid??>	
	/**
	 * Delete All
	 * @param values oids
	 */
	public void delete(String[] values);

	/**
	 * Delete All with cascade
	 * @param values
	 */
	public void deleteCascade(String[] values);
</#if>		
	/**
	 * Update
	 * @param o
	 */
	public void update(${ClassName} o);
	
	/**
	 * Get
	 * @param id oid
	 * @return Object
	 */
	@Transactional(readOnly=true)
	public ${ClassName} get(Serializable id);
	
	/**
	 * Pagination
	 * @param pageBean PageBean
	 * @param empCriteria Criteria
	 */
	@Transactional(readOnly=true)
	@SuppressWarnings("rawtypes")
	public void findByPage(PageBean pageBean,${ClassName}Criteria ${ClassName?uncap_first}Criteria);
	
	/**
	 * Max Page
	 * @param rowPerPage Row Per Page
	 * @return maxPage
	 */
	@Transactional(readOnly=true)
	public int findMaxPage(int rowPerPage);
	
	
	/**
	 * Find All
	 * @return list 
	 */
	@Transactional(readOnly=true)
	public List<${ClassName}> findAll();
}
