<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%
	String path = request.getContextPath();
	String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
%>
<%@ taglib uri="http://shiro.apache.org/tags" prefix="shiro"%>

<%-- 1. 页面Datagrid初始化相关JS --%>
<%-- JS代码必须包含在页面中，引入外部JS文件会导致表格界面在未完成初始化前就显示，出现短暂的未初始化界面 --%>
<script type="text/javascript">
	//部门操作命名空间
	var ${ClassName} = {};
	$(function() {
		/*
		 * datagrid
		 */
		var dg = $("#${ClassName}DataGrid");

		// EasyUIEx datagrid
		$("#${ClassName}DataGrid").initDatagrid({
			// CRUD URL
			url : "${ClassName}/list",
			saveUrl : "${ClassName}/save",
			updateUrl : "${ClassName}/update",
			destroyUrl : "${ClassName}/<#if mutipleDelete>deleteBatch<#else>delete</#if>",
			// 主键列
			idField : "${Oid}", 
			
			showHeaderContextMenu : true, // 表头添加右键菜单，可选择显示的列
			
			<#if pagination>pagination : true,<#else>pagination : false,</#if> // 分页
			// pageSize: 10,
			// pageList: [10, 20, 30, 40, 50],
			
			//queryParams:{"rows":dg.datagrid("options").pageSize}, // 分页查询请求参数
			
			checkbox : true,
			checkOnSelect : true,
			singleSelect : false,
			
			clickCellEdit : true, //单元格编辑
			autoSave : true, // 自动保存
			
			<#if contextMenu>
			menuSelector : "#${ClassName}ContextMenu", //右键菜单
			showContextMenu : true,</#if>
			
			sendRowDataPrefix : "", //提交数据前缀
						
			showMsg : true, // 显示操作消息
			successKey : "statusCode", //服务器端返回的成功标记key
			successValue : "200" //服务器端返回的成功标记value
			
			<#if mutipleDelete>,mutipleDelete : true, // 多行提交删除
			mutipleDeleteProperty : "${Oid}" // 多行删除时提及给服务器的属性和值，不会添加sendRowDataPrefix前缀，支持使用数组指定多个属性名
			</#if>
		});

		/*
		 * Functions
		 */
		<#if toolbar>
		//搜索
		${ClassName}.doSearch = function() {
			dg.datagrid("load", {
				<#if Propertys??>
				<#list Propertys as item>
				<#assign info=item?split("#")>
				'${info[1]}' : $("#${ClassName?uncap_first}${info[1]?cap_first}").val()<#sep>,</#sep>
				</#list>
				</#if>
			});
		}
		
		// 清除所有搜索条件
		${ClassName}.clearAll = function() {
			$("#${ClassName}SearchForm")[0].reset();
			dg.datagrid("load", {
			});
		}
		</#if>
		
		<#if save>
		<%--
		// Dialog Add
		${ClassName}.toAdd = function() {
			uiEx.resetForm("#${ClassName}AddForm");
			uiEx.openDialog("#${ClassName}AddDialog", "${ClsLabel}添加");
		}
		--%></#if>
		
		<#if update>
		<%--
		// Dialog Eidt
		${ClassName}.toEdit = function() {
			var row = $("#${ClassName}DataGrid").datagrid('getSelected');
			if (row) {
				toEdit(row);
			} else {
				uiEx.msg("请选择要修改的行");
			}
		}
		function toEdit(row) {
			uiEx.resetForm("#${ClassName}EditForm");
			uiEx.openDialog("#${ClassName}EditDialog", "${ClsLabel}修改");
			uiEx.loadForm("#${ClassName}EditForm", row, "");
		}
		--%></#if>
		
	});
</script>

<%-- 2. 页面内容 --%>
<table id="${ClassName}DataGrid" title="${ClsLabel}列表" style="width: 100%"  <#if toolbar>toolbar="#${ClassName}Toolbar"</#if> idField="${Oid}" rownumbers="true" fitColumns="true" nowrap="false">
	<thead>
		<tr>
			<th field="ck" checkbox="true" width="50" sortable="true">多选框</th>
			<#if Autos??>
			<#list Autos as item>
			<#assign info=item?split("#")>
			<#if info[4]=="true">
			<th field="${info[0]}" width="50" sortable="true" <#if info[6]=="true">editor="{type:'textbox',options:{<#if info[3]=="true">required:true</#if>}}"</#if>>${info[2]}</th>
			</#if>
			</#list>
			</#if>
		</tr>
	</thead>
</table>
<#if toolbar>
<%-- 2. 搜索 ToolBar --%>
<div id="${ClassName}Toolbar">
	<div>
	<form action="" id="${ClassName}SearchForm" onsubmit="${ClassName}.doSearch();return false">
		<#if Propertys??>
		<#list Propertys as item>
		<#assign info=item?split("#")>
		<span>${info[4]}:</span> <input name="${info[1]}" id="${ClassName?uncap_first}${info[1]?cap_first}" class="${info[7]}" /> 
		</#list>
		</#if>
		<#if search>
		<a class="easyui-linkbutton" iconCls="icon-search" plain="true" onclick="${ClassName}.doSearch()">Search</a>
		<a class="easyui-linkbutton" iconCls="icon-clear" plain="true" onclick="${ClassName}.clearAll()">Clear</a>
		<input type="submit" style="display: none;"/></#if>
	</form>
	</div>
	
	<#if save><%--<a href="javascript:void(0)" class="easyui-linkbutton" data-options="iconCls:'icon-add',plain:true" onclick="${ClassName}.toAdd()">Dialog 添加${ClsLabel}</a>--%></#if>
	<#if update><%--<a href="javascript:void(0)" class="easyui-linkbutton" data-options="iconCls:'icon-edit',plain:true" onclick="${ClassName}.toEdit()">Dialog 修改${ClsLabel}</a>--%></#if>
	<#if save><a href="javascript:void(0)" class="easyui-linkbutton" data-options="iconCls:'icon-add',plain:true" onclick="$('#${ClassName}DataGrid').rowAdd()">添加${ClsLabel}</a></#if>
	<#if remove><a class="easyui-linkbutton" iconCls="icon-remove" plain="true" onclick="$('#${ClassName}DataGrid').rowDelete()">删除${ClsLabel}</a></#if>
	<a class="easyui-linkbutton" iconCls="icon-undo" plain="true" onclick="javascript:$('#${ClassName}DataGrid').rowCancelEdit()">撤销修改</a>
</div>
</#if>
<#if contextMenu>
<%-- 3. grid右键菜单 --%>
<div id="${ClassName}ContextMenu" class="easyui-menu" style="width:120px;">
	<#if save><div onclick="$('#${ClassName}DataGrid').rowAdd()" data-options="iconCls:'icon-add'">添加${ClsLabel}</div></#if>
	<#if remove><div onclick="$('#${ClassName}DataGrid').rowDelete()" data-options="iconCls:'icon-remove'">删除${ClsLabel}</div></#if>
	<a class="easyui-linkbutton" iconCls="icon-undo" plain="true" onclick="javascript:$('#${ClassName}DataGrid').rowCancelEdit()">撤销修改</a>
 </div>
</#if>

<%-- 
<%@ include file="/WEB-INF/content/dialog/${Module}/${ClassName}Add.jsp"%>  
<%@ include file="/WEB-INF/content/dialog/${Module}/${ClassName}Edit.jsp"%>  
--%>