/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easycommons.commondao.factory;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class JPAEntityManagerFactory {
    private static final String PERSISTENCE_UNIT_NAME = "EasyCommonDAO";
    private static final ThreadLocal<EntityManager> threadLocal = new ThreadLocal();
    private static EntityManagerFactory entityManagerFactory;

    private JPAEntityManagerFactory() {
    }

    public static EntityManager getEntityManager() {
        EntityManager entityManager = threadLocal.get();
        if (entityManager == null || !entityManager.isOpen()) {
            if (entityManagerFactory == null) {
                JPAEntityManagerFactory.rebuildEntityManagerFactory();
            }
            entityManager = entityManagerFactory != null ? entityManagerFactory.createEntityManager() : null;
            threadLocal.set(entityManager);
        }
        return entityManager;
    }

    public static void rebuildEntityManagerFactory() {
        try {
            entityManagerFactory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME);
        }
        catch (Exception e) {
            System.err.println("%%%% Error Creating EntityManagerFactory %%%%");
            e.printStackTrace();
        }
    }

    public static void closeEntityManager() {
        EntityManager entityManager = threadLocal.get();
        threadLocal.set(null);
        if (entityManager != null) {
            entityManager.close();
        }
    }

    public static void closeEntityManagerFactory() {
        if (entityManagerFactory != null) {
            entityManagerFactory.close();
        }
    }

    public static EntityManagerFactory getEntityManagerFactory() {
        return entityManagerFactory;
    }

    static {
        try {
            entityManagerFactory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME);
        }
        catch (Exception e) {
            System.err.println("%%%% Error Creating EntityManagerFactory %%%%");
            e.printStackTrace();
        }
    }
}

