/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easycommons.commondao;

import cn.easyproject.easycommons.commondao.CommonDAO;
import cn.easyproject.easycommons.commondao.factory.JPAEntityManagerFactory;
import cn.easyproject.easycommons.commondao.util.EasyCriteria;
import cn.easyproject.easycommons.commondao.util.PageBean;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;

public class CommonDAOImpl
implements CommonDAO {
    @Override
    public void batchUpdateSQL(final String sql, final Object[] values) {
        EntityManager entityManager = JPAEntityManagerFactory.getEntityManager();
        ((Session)entityManager.unwrap(Session.class)).doWork(new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection connection) throws SQLException {
                Statement pstmt = null;
                try {
                    connection.setAutoCommit(false);
                    pstmt = connection.prepareStatement(sql);
                    for (int i = 0; i < values.length; ++i) {
                        pstmt.setObject(1, values[i]);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        if (entityManager.isOpen()) {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public void batchUpdateSQL(final String sql, final Object[][] values) {
        EntityManager entityManager = JPAEntityManagerFactory.getEntityManager();
        ((Session)entityManager.unwrap(Session.class)).doWork(new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection connection) throws SQLException {
                PreparedStatement pstmt = null;
                try {
                    pstmt = connection.prepareStatement(sql);
                    for (Object[] row : values) {
                        for (int i = 0; i < row.length; ++i) {
                            pstmt.setObject(i + 1, row[i]);
                        }
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        if (entityManager.isOpen()) {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    private EntityManager beginTransaction() {
        EntityManager entityManager = JPAEntityManagerFactory.getEntityManager();
        entityManager.getTransaction().begin();
        return entityManager;
    }

    private void close() {
        JPAEntityManagerFactory.closeEntityManager();
    }

    private void commit(EntityManager entityManager) {
        entityManager.getTransaction().commit();
    }

    private Query createNamedQuery(EntityManager entityManager, String name, boolean cacheable, String cacheRegion, Object ... values) {
        Query query = entityManager.createNamedQuery(name.trim());
        if (cacheable) {
            query.setHint("org.hibernate.cacheable", (Object)"true");
            if (cacheRegion != null && !cacheRegion.equals("")) {
                query.setHint("org.hibernate.cacheRegion", (Object)cacheRegion);
            }
        }
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i + 1, values[i]);
            }
        }
        return query;
    }

    private Query createNativeQuery(EntityManager entityManager, String sql, Class resultClass, boolean mapResult, Object ... values) {
        Query query = null;
        query = resultClass != null ? entityManager.createNativeQuery(sql, resultClass) : entityManager.createNativeQuery(sql);
        if (mapResult) {
            ((org.hibernate.Query)query.unwrap(org.hibernate.Query.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        }
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i + 1, values[i]);
            }
        }
        return query;
    }

    private Query createQuery(EntityManager entityManager, String jpql, boolean cacheable, String cacheRegion, Object ... values) {
        Query query = entityManager.createQuery(jpql);
        if (cacheable) {
            query.setHint("org.hibernate.cacheable", (Object)"true");
            if (cacheRegion != null && !cacheRegion.equals("")) {
                query.setHint("org.hibernate.cacheRegion", (Object)cacheRegion);
            }
        }
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return query;
    }

    @Override
    public void remove(Class cls, Serializable id) {
        EntityManager entityManager = null;
        try {
            entityManager = this.beginTransaction();
            entityManager.remove(entityManager.find(cls, (Object)id));
            this.commit(entityManager);
        }
        catch (RuntimeException e) {
            this.rollback(entityManager);
            throw e;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void remove(Object o) {
        EntityManager entityManager = null;
        try {
            entityManager = this.beginTransaction();
            entityManager.remove(o);
            this.commit(entityManager);
        }
        catch (RuntimeException e) {
            this.rollback(entityManager);
            throw e;
        }
        finally {
            this.close();
        }
    }

    @Override
    public Integer deleteByValues(Class cls, String fieldName, Object[] values) {
        int res = 0;
        EntityManager entityManager = null;
        try {
            entityManager = this.beginTransaction();
            StringBuilder ins = new StringBuilder();
            ins.append("'");
            for (Object v : values) {
                ins.append(v).append("','");
            }
            String jpql = "delete from " + cls.getSimpleName() + " where " + fieldName + " in(" + ins.substring(0, ins.length() - 2) + ")";
            res = entityManager.createQuery(jpql).executeUpdate();
            this.commit(entityManager);
        }
        catch (RuntimeException e) {
            this.rollback(entityManager);
            throw e;
        }
        finally {
            this.close();
        }
        return res;
    }

    @Override
    public void deleteCascadeByValues(Class cls, String fieldName, Object[] values) {
        EntityManager entityManager = null;
        try {
            entityManager = this.beginTransaction();
            StringBuilder ins = new StringBuilder();
            ins.append("'");
            for (Object v : values) {
                ins.append(v).append("','");
            }
            String jpql = "from " + cls.getSimpleName() + " where " + fieldName + " in(" + ins.substring(0, ins.length() - 2) + ")";
            for (Object o : entityManager.createQuery(jpql).getResultList()) {
                entityManager.remove(o);
            }
            this.commit(entityManager);
        }
        catch (RuntimeException e) {
            this.rollback(entityManager);
            throw e;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void evict(Class cls) {
        JPAEntityManagerFactory.getEntityManagerFactory().getCache().evict(cls);
    }

    @Override
    public void evict(Class cls, Serializable id) {
        JPAEntityManagerFactory.getEntityManagerFactory().getCache().evict(cls, (Object)id);
    }

    @Override
    public void evictAll() {
        JPAEntityManagerFactory.getEntityManagerFactory().getCache().evictAll();
    }

    @Override
    public void evictCollectionRegion(String collectionRegion) {
        ((Session)JPAEntityManagerFactory.getEntityManager().unwrap(Session.class)).getSessionFactory().getCache().evictCollectionRegion(collectionRegion);
    }

    @Override
    public void evictCollectionRegion(String collectionRegion, Serializable id) {
        ((Session)JPAEntityManagerFactory.getEntityManager().unwrap(Session.class)).getSessionFactory().getCache().evictCollection(collectionRegion, id);
    }

    @Override
    public void evictQueries() {
        if (null != "org.hibernate.cache.internal.StandardQueryCache" || !"".equals("org.hibernate.cache.internal.StandardQueryCache")) {
            ((Session)JPAEntityManagerFactory.getEntityManager().unwrap(Session.class)).getSessionFactory().getCache().evictQueryRegion("org.hibernate.cache.internal.StandardQueryCache");
        } else {
            ((Session)JPAEntityManagerFactory.getEntityManager().unwrap(Session.class)).getSessionFactory().getCache().evictQueryRegions();
        }
    }

    @Override
    public void evictQueries(String queryCacheRegion) {
        ((Session)JPAEntityManagerFactory.getEntityManager().unwrap(Session.class)).getSessionFactory().getCache().evictQueryRegion(queryCacheRegion);
    }

    @Override
    public List find(String jpql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.find(jpql + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.find(jpql, new Object[0]);
    }

    @Override
    public List find(String jpql, Object ... values) {
        EntityManager entityManager = null;
        try {
            List list;
            entityManager = JPAEntityManagerFactory.getEntityManager();
            Query q = this.createQuery(entityManager, jpql, false, null, values);
            List list2 = list = q.getResultList();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public List findAll(Class cls) {
        EntityManager entityManager = null;
        try {
            entityManager = JPAEntityManagerFactory.getEntityManager();
            String queryString = "from " + cls.getName();
            List list = entityManager.createQuery(queryString).getResultList();
            this.initialize(list);
            List list2 = list;
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public List findByCache(String jpql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findByCache(jpql + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findByCache(jpql, new Object[0]);
    }

    @Override
    public List findByCache(String jpql, Object ... values) {
        EntityManager entityManager = null;
        try {
            List list;
            entityManager = JPAEntityManagerFactory.getEntityManager();
            String cacheRegion = null;
            if (null != "org.hibernate.cache.internal.StandardQueryCache" || !"".equals("org.hibernate.cache.internal.StandardQueryCache")) {
                cacheRegion = "org.hibernate.cache.internal.StandardQueryCache";
            }
            Query q = this.createQuery(entityManager, jpql, true, cacheRegion, values);
            List list2 = list = q.getResultList();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public List findByCache(String jpql, String queryCacheRegion, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findByCache(jpql + " " + easyCriteria.getCondition(), queryCacheRegion, easyCriteria.getValues().toArray());
        }
        return this.findByCache(jpql, queryCacheRegion, new Object[0]);
    }

    @Override
    public List findByCache(String jpql, String queryCacheRegion, Object ... values) {
        EntityManager entityManager = null;
        try {
            List list;
            entityManager = JPAEntityManagerFactory.getEntityManager();
            Query q = this.createQuery(entityManager, jpql, true, queryCacheRegion, values);
            List list2 = list = q.getResultList();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public void findByPage(PageBean pageBean) {
        this.findByPage(pageBean, new ArrayList());
    }

    @Override
    public void findByPage(PageBean pageBean, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            pageBean.setCondition(easyCriteria.getCondition());
            this.findByPage(pageBean, easyCriteria.getValues());
        } else {
            this.findByPage(pageBean);
        }
    }

    @Override
    public void findByPage(PageBean pageBean, List values) {
        String jpql = pageBean.getQuery() != null ? pageBean.getQuery() : pageBean.getAutoQuery();
        EntityManager entityManager = null;
        try {
            entityManager = JPAEntityManagerFactory.getEntityManager();
            Query query = this.createQuery(entityManager, jpql, false, null, values.toArray());
            query.setFirstResult(pageBean.getRowStart());
            query.setMaxResults(pageBean.getRowsPerPage());
            pageBean.setData(query.getResultList());
            String queryString = "";
            int end = jpql.length();
            if (jpql.indexOf("order by") != -1) {
                end = jpql.indexOf("order by");
            }
            if (jpql.toUpperCase().indexOf("SELECT") != -1) {
                int i = jpql.toUpperCase().indexOf("FROM");
                queryString = "select count(1) " + jpql.substring(i, end);
            } else {
                queryString = "select count(1) " + jpql.substring(0, end);
            }
            int j = queryString.toUpperCase().lastIndexOf("ORDER");
            if (j != -1) {
                queryString = queryString.substring(0, j);
            }
            Query cquery = this.createQuery(entityManager, queryString, false, null, values.toArray());
            int maxRow = Integer.valueOf(cquery.getSingleResult().toString());
            pageBean.setRowsCount(maxRow);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public List findByProperty(Class cls, String propertyName, Object value) {
        String queryString = "from " + cls.getName() + " model where model." + propertyName + "= ?";
        return this.find(queryString, value);
    }

    @Override
    public List findByPropertyIgnoreCase(Class cls, String propertyName, String value) {
        String queryString = "from " + cls.getName() + " model where lower(model." + propertyName + ")= ?";
        return this.find(queryString, value.toLowerCase());
    }

    @Override
    public List findBySQL(String sql, Class resultClass, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findBySQL(sql + " " + easyCriteria.getCondition(), resultClass, easyCriteria.getValues().toArray());
        }
        return this.findBySQL(sql, resultClass, new Object[0]);
    }

    @Override
    public List findBySQL(String sql, Class resultClass, Object ... values) {
        EntityManager entityManager = null;
        try {
            List list;
            entityManager = JPAEntityManagerFactory.getEntityManager();
            Query q = this.createNativeQuery(entityManager, sql, resultClass, false, values);
            List list2 = list = q.getResultList();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public List findBySQL(String sql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findBySQL(sql + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findBySQL(sql, new Object[0]);
    }

    @Override
    public List findBySQL(String sql, Object ... values) {
        EntityManager entityManager = null;
        try {
            List list;
            entityManager = JPAEntityManagerFactory.getEntityManager();
            Query q = this.createNativeQuery(entityManager, sql, null, false, values);
            List list2 = list = q.getResultList();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public int findCount(String jpql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findCount(jpql + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findCount(jpql, new Object[0]);
    }

    @Override
    public int findCount(String jpql, Object ... values) {
        EntityManager entityManager = null;
        try {
            entityManager = JPAEntityManagerFactory.getEntityManager();
            Query q = this.createQuery(entityManager, jpql, false, null, values);
            int n = Integer.valueOf(q.getSingleResult().toString());
            return n;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public List findMapResultBySQL(String sql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findMapResultBySQL(sql + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findMapResultBySQL(sql, new Object[0]);
    }

    @Override
    public List findMapResultBySQL(String sql, Object ... values) {
        EntityManager entityManager = null;
        try {
            List list;
            entityManager = JPAEntityManagerFactory.getEntityManager();
            Query q = this.createNativeQuery(entityManager, sql, null, true, values);
            List list2 = list = q.getResultList();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public int findMaxPage(String jpql, int rowsPerPage, EasyCriteria easyCriteria) {
        return (this.findCount(jpql, easyCriteria) - 1) / rowsPerPage + 1;
    }

    @Override
    public int findMaxPage(String jpql, int rowsPerPage, Object ... values) {
        return (this.findCount(jpql, values) - 1) / rowsPerPage + 1;
    }

    @Override
    public List findNamedQuery(String name, Object ... values) {
        EntityManager entityManager = null;
        try {
            entityManager = JPAEntityManagerFactory.getEntityManager();
            Query q = this.createNamedQuery(entityManager, name, false, null, values);
            List list = q.getResultList();
            return list;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public List findNamedQueryByCache(String name, String queryCacheRegion, Object ... values) {
        EntityManager entityManager = null;
        try {
            entityManager = JPAEntityManagerFactory.getEntityManager();
            Query q = this.createNamedQuery(entityManager, name, true, queryCacheRegion, values);
            List list = q.getResultList();
            return list;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public List findTop(String jpql, int topCount, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findTop(jpql + " " + easyCriteria.getCondition(), topCount, easyCriteria.getValues().toArray());
        }
        return this.findTop(jpql, topCount, new Object[0]);
    }

    @Override
    public List findTop(String jpql, int topCount, Object ... values) {
        EntityManager entityManager = null;
        try {
            List list;
            entityManager = JPAEntityManagerFactory.getEntityManager();
            Query q = entityManager.createQuery(jpql);
            q.setFirstResult(0);
            q.setMaxResults(topCount);
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    q.setParameter(i, values[i]);
                }
            }
            List list2 = list = q.getResultList();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public <T> T findVal(String jpql, EasyCriteria easyCriteria) {
        List list = this.find(jpql, easyCriteria);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public <T> T findVal(String jpql, Object ... values) {
        List list = this.find(jpql, values);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public <T> T find(Class cls, Serializable id) {
        EntityManager entityManager = null;
        try {
            entityManager = JPAEntityManagerFactory.getEntityManager();
            Object object = entityManager.find(cls, (Object)id);
            return (T)object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JPAEntityManagerFactory.closeEntityManager();
        }
    }

    @Override
    public EntityManager getCurrentEntityManager() {
        return JPAEntityManagerFactory.getEntityManager();
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory() {
        return JPAEntityManagerFactory.getEntityManagerFactory();
    }

    @Override
    public void initialize(Object proxy) {
        if (!Hibernate.isInitialized((Object)proxy)) {
            Hibernate.initialize((Object)proxy);
        }
    }

    @Override
    public void initializeDeep(Collection collection) {
        if (collection == null) {
            return;
        }
        for (Object obj : collection) {
            Method[] methods = obj.getClass().getMethods();
            if (methods == null) continue;
            for (int j = 0; j < methods.length; ++j) {
                String getName = methods[j].getName();
                if (getName.length() <= 3 || !getName.startsWith("get")) continue;
                String getFix = getName.substring(3, getName.length());
                for (int k = 0; k < methods.length; ++k) {
                    String setFix;
                    String setName = methods[k].getName();
                    if (setName.length() <= 3 || !setName.startsWith("set") || !getFix.equals(setFix = setName.substring(3, setName.length()))) continue;
                    try {
                        Object o = methods[j].invoke(obj, new Object[0]);
                        if (o == null) continue;
                        Hibernate.initialize((Object)o);
                        methods[k].invoke(obj, o);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void merge(Object o) {
        EntityManager entityManager = null;
        try {
            entityManager = this.beginTransaction();
            entityManager.merge(o);
            this.commit(entityManager);
        }
        catch (RuntimeException e) {
            this.rollback(entityManager);
            throw e;
        }
        finally {
            this.close();
        }
    }

    private void rollback(EntityManager entityManager) {
        EntityTransaction txn = entityManager.getTransaction();
        if (txn != null && txn.isActive()) {
            txn.rollback();
        }
    }

    @Override
    public void persist(Object o) {
        EntityManager entityManager = null;
        try {
            entityManager = this.beginTransaction();
            entityManager.persist(o);
            this.commit(entityManager);
        }
        catch (RuntimeException e) {
            this.rollback(entityManager);
            throw e;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void updateByJpql(String jpql, Object ... values) {
        EntityManager entityManager = null;
        try {
            entityManager = this.beginTransaction();
            Query query = entityManager.createQuery(jpql);
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    query.setParameter(i, values[i]);
                }
            }
            query.executeUpdate();
            this.commit(entityManager);
        }
        catch (RuntimeException e) {
            this.rollback(entityManager);
            throw e;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void updateBySQL(String sql, Object ... values) {
        EntityManager entityManager = null;
        try {
            entityManager = this.beginTransaction();
            Query query = entityManager.createNativeQuery(sql);
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    query.setParameter(i + 1, values[i]);
                }
            }
            query.executeUpdate();
            this.commit(entityManager);
        }
        catch (RuntimeException e) {
            this.rollback(entityManager);
            throw e;
        }
        finally {
            this.close();
        }
    }
}

