package cn.easyproject.easycommons.commondao.factory;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;


/**
 * EasyCommmonDAO JPAEntityManagerFactory
 * Configures and provides access to JPA EntityManager, tied to the
 * current thread of execution.  Follows the Thread Local EntityManager
 * pattern.
 * 
 * @author Ray
 * @author inthinkcolor@gmail.com
 * @author easyproject.cn
 * @since 1.0.0
 */
public class JPAEntityManagerFactory {
    /** 
     * Location of META-INF\persistence.xml file.
     * The default classpath location of the JPA config file is 
     * in the default package. Use #setConfigFile() to update 
     * the location of the configuration file for the current EntityManager.   
     */
	private static final String PERSISTENCE_UNIT_NAME="EasyCommonDAO";
	
	private static final ThreadLocal<EntityManager> threadLocal = new ThreadLocal<EntityManager>();
    private static EntityManagerFactory entityManagerFactory;
	
	static {
    	try {
    		entityManagerFactory = Persistence.createEntityManagerFactory(PERSISTENCE_UNIT_NAME);  
		} catch (Exception e) {
			System.err.println("%%%% Error Creating EntityManagerFactory %%%%");
			e.printStackTrace();
		}
    }
	
	
    private JPAEntityManagerFactory() {
    }
	
	/**
     * Returns the ThreadLocal EntityManager instance.  Lazy initialize
     * the <code>EntityManagerFactory</code> if needed.
     *
     *  @return EntityManager
     */
    public static EntityManager getEntityManager() {
    	EntityManager entityManager = (EntityManager) threadLocal.get();

		if (entityManager == null || !entityManager.isOpen()) {
			if (entityManagerFactory == null) {
				rebuildEntityManagerFactory();
			}
			entityManager = (entityManagerFactory != null) ? entityManagerFactory.createEntityManager()
					: null;
			threadLocal.set(entityManager);
		}

        return entityManager;
    }

	/**
     *  Rebuild JPA entityManager factory
     *
     */
	public static void rebuildEntityManagerFactory() {
		try {
			entityManagerFactory = Persistence.createEntityManagerFactory(PERSISTENCE_UNIT_NAME);  
		} catch (Exception e) {
			System.err.println("%%%% Error Creating EntityManagerFactory %%%%");
			e.printStackTrace();
		}
	}

	/**
     *  Close the single JPA EntityManager instance.
     *

     */
    public static void closeEntityManager() {
    	EntityManager entityManager = (EntityManager) threadLocal.get();
        threadLocal.set(null);

        if (entityManager != null) {
        	entityManager.close();
        }
    }
    /**
     *  Close the single JPA EntityManager instance.
     *
     */
    public static void closeEntityManagerFactory() {
    	if (entityManagerFactory != null) {
    		entityManagerFactory.close();
    	}
    }

	/**
     *  @return entityManager factory
     *
     */
	public static EntityManagerFactory getEntityManagerFactory() {
		return entityManagerFactory;
	}

}