package cn.easyproject.easycommons.commondao;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.jdbc.Work;
import org.hibernate.transform.Transformers;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;
import org.springframework.stereotype.Repository;

import cn.easyproject.easycommons.commondao.util.EasyCriteria;
import cn.easyproject.easycommons.commondao.util.PageBean;
import cn.easyproject.easycommons.commondao.factory.HibernateSessionFactory;

/**
 * Hibernat5 CommonDAO implement used spring.
 * 
 * @author Ray
 * @author inthinkcolor@gmail.com
 * @author easyproject.cn
 * @since 1.0.0
 * 
 */
@Repository("commonDAO")
@SuppressWarnings({ "rawtypes", "unchecked" })
public class CommonDAOSpringImpl extends HibernateDaoSupport implements CommonDAO {

	@Resource
	private SessionFactory mySessionFacotry;

	@PostConstruct
	public void injectSessionFactory() {
		super.setSessionFactory(mySessionFacotry);
	}

	@Override
	public void batchUpdateSQL(final String sql, final Object[] values) {
		getHibernateTemplate().bulkUpdate(sql, values);
	}

	@Override
	public void batchUpdateSQL(final String sql, final Object[][] values) {

		getHibernateTemplate().execute(new HibernateCallback<Boolean>() {

			@Override
			public Boolean doInHibernate(Session session) throws HibernateException {
				session.doWork(new Work() {
					@Override
					public void execute(Connection connection) throws SQLException {
						PreparedStatement pstmt = connection.prepareStatement(sql);// 预编译
						for (Object[] row : values) {
							for (int i = 0; i < row.length; i++) {
								pstmt.setObject(i + 1, row[i]);
							}
							pstmt.addBatch();
						}
						pstmt.executeBatch();// 将参数加入到批处理
					}
				});

				return true;
			}
		});
	}

	/**
	 * CommonDAO 内部方法，Query
	 * 
	 * @param hql
	 *            hql
	 * @param cacheable
	 *            cacheable
	 * @param cacheRegion
	 *            cacheRegion
	 * @param values
	 *            values
	 * @return List 对象
	 */
	private List createQuery(String hql, boolean cacheable, String cacheRegion, Object... values) {
		if (cacheable) {
			getHibernateTemplate().setCacheQueries(true);
			if (cacheRegion != null && (!cacheRegion.equals(""))) {
				getHibernateTemplate().setQueryCacheRegion(cacheRegion);
			}
		}

		List list = new ArrayList();
		if (values != null) {
			list = super.getHibernateTemplate().find(hql, values);
		} else {
			list = super.getHibernateTemplate().find(hql);
		}
		getHibernateTemplate().setCacheQueries(false);// 用完后立即关闭，防止其他查询被缓存
		return list;
	}

	@Override
	public void remove(Class cls, Serializable id) {
		getHibernateTemplate().delete(getHibernateTemplate().get(cls, id));
	}

	@Override
	public void remove(Object o) {
		getHibernateTemplate().delete(o);
	}

	@Override
	public Integer deleteByValues(Class cls, String fieldName, Object[] values) {

		StringBuilder ins = new StringBuilder();
		ins.append("'");
		for (Object v : values) {
			ins.append(v).append("','");
		}

		String hql = "delete from " + cls.getSimpleName() + " where " + fieldName + " in("
				+ ins.substring(0, ins.length() - 2) + ")";

		return getHibernateTemplate().bulkUpdate(hql);
	}

	@Override
	public void deleteCascadeByValues(Class cls, String fieldName, Object[] values) {
		StringBuilder ins = new StringBuilder();
		ins.append("'");
		for (Object v : values) {
			ins.append(v).append("','");
		}
		String hql = "from " + cls.getSimpleName() + " where " + fieldName + " in(" + ins.substring(0, ins.length() - 2)
				+ ")";

		List list = getHibernateTemplate().find(hql);

		for (Object o : list) {
			getHibernateTemplate().delete(o);
		}
	}

	@Override
	public void evict(Class cls) {
		HibernateSessionFactory.getSessionFactory().getCache().evictEntityRegion(cls);
	}

	@Override
	public void evict(Class cls, Serializable id) {
		HibernateSessionFactory.getSessionFactory().getCache().evictEntity(cls, id);
	}

	@Override
	public void evictAll() {
		HibernateSessionFactory.getSessionFactory().getCache().evictAllRegions();
	}

	@Override
	public void evictCollectionRegion(String collectionRegion) {
		HibernateSessionFactory.getSessionFactory().getCache().evictCollectionRegion(collectionRegion);
	}

	@Override
	public void evictCollectionRegion(String collectionRegion, Serializable id) {
		HibernateSessionFactory.getSessionFactory().getCache().evictCollection(collectionRegion, id);

	}

	@Override
	public void evictQueries() {
		if (null != DEFAULT_QUERY_CACHE_REGION || (!"".equals(DEFAULT_QUERY_CACHE_REGION))) {
			HibernateSessionFactory.getSessionFactory().getCache().evictQueryRegion(DEFAULT_QUERY_CACHE_REGION);
		} else {
			HibernateSessionFactory.getSessionFactory().getCache().evictQueryRegions();
		}
	}

	@Override
	public void evictQueries(String queryCacheRegion) {
		HibernateSessionFactory.getSessionFactory().getCache().evictQueryRegion(queryCacheRegion);
	}

	@Override
	public <T> T find(Class cls, Serializable id) {
		return (T) getHibernateTemplate().get(cls, id);
	}

	@Override
	public List find(String hql, EasyCriteria easyCriteria) {
		if (easyCriteria != null) {
			return find(hql + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
		} else {
			return find(hql);
		}

	}

	@Override
	public List find(String hql, Object... values) {
		return createQuery(hql, false, null, values);

	}

	@Override
	public List findAll(Class cls) {
		String queryString = "from " + cls.getName();
		return createQuery(queryString, false, null);
	}

	@Override
	public List findByCache(String hql, EasyCriteria easyCriteria) {

		if (easyCriteria != null) {
			return findByCache(hql + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
		} else {
			return findByCache(hql);
		}

	}

	@Override
	public List findByCache(String hql, Object... values) {
		return createQuery(hql, true, null, values);
	}

	@Override
	public List findByCache(String hql, String queryCacheRegion, EasyCriteria easyCriteria) {

		if (easyCriteria != null) {
			return findByCache(hql + " " + easyCriteria.getCondition(), queryCacheRegion,
					easyCriteria.getValues().toArray());
		} else {
			return findByCache(hql, queryCacheRegion);
		}
	}

	@Override
	public List findByCache(String hql, String queryCacheRegion, Object... values) {
		return createQuery(hql, true, queryCacheRegion, values);
	}

	@Override
	public void findByPage(PageBean pageBean) {
		this.findByPage(pageBean, new ArrayList());
	}

	@Override
	public void findByPage(PageBean pageBean, EasyCriteria easyCriteria) {
		if (easyCriteria != null) {
			pageBean.setCondition(easyCriteria.getCondition());
			this.findByPage(pageBean, easyCriteria.getValues());
		} else {
			this.findByPage(pageBean);
		}
	}

	@Override
	public void findByPage(final PageBean pageBean, final List values) {
		final String hql = pageBean.getAutoQuery();

		getHibernateTemplate().execute(new HibernateCallback<List>() {
			@Override
			public List doInHibernate(Session session) throws HibernateException {

				Query query = session.createQuery(hql);
				if (values != null && values.size() > 0) {
					for (int i = 0; i < values.size(); i++) {
						query.setParameter(i, values.get(i));
					}
				}
				query.setFirstResult(pageBean.getRowStart());
				query.setMaxResults(pageBean.getRowsPerPage());

				pageBean.setData(query.list());

				Query cquery = session.createQuery(pageBean.getAutoCountQuery());
				if (values != null && values.size() > 0) {
					for (int i = 0; i < values.size(); i++) {
						cquery.setParameter(i, values.get(i));
					}
				}

				int maxRow = (Integer.valueOf(cquery.uniqueResult().toString())).intValue();
				pageBean.setRowsCount(maxRow);
				return null;
			}
		});

	}

	@Override
	public List findByProperty(Class cls, String propertyName, Object value) {
		String queryString = "from " + cls.getName() + " model where model." + propertyName + "= ?";
		return find(queryString, value);
	}

	@Override
	public List findByPropertyIgnoreCase(Class cls, String propertyName, String value) {
		String queryString = "from " + cls.getName() + " model where lower(model." + propertyName + ")= ?";
		return find(queryString, value.toLowerCase());
	}

	@Override
	public List findBySQL(String sql, Class resultClass, EasyCriteria easyCriteria) {
		if (easyCriteria != null) {
			return findBySQL(sql + " " + easyCriteria.getCondition(), resultClass, easyCriteria.getValues().toArray());
		} else {
			return findBySQL(sql, resultClass);
		}
	}

	@Override
	public List findBySQL(final String sql, final Class resultClass, final Object... values) {
		return getHibernateTemplate().execute(new HibernateCallback<List>() {
			@Override
			public List doInHibernate(Session session) throws HibernateException {
				SQLQuery query = session.createSQLQuery(sql).addEntity(resultClass);

				if (values != null & values.length > 0) {
					for (int i = 0; i < values.length; i++) {
						query.setParameter(i + 1, values[i]);
					}
				}
				return query.list();
			}
		});

	}

	@Override
	public List findBySQL(String sql, EasyCriteria easyCriteria) {
		if (easyCriteria != null) {
			return findBySQL(sql + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
		} else {
			return findBySQL(sql);
		}
	}

	@Override
	public List findBySQL(final String sql, final Object... values) {
		return getHibernateTemplate().execute(new HibernateCallback<List>() {
			@Override
			public List doInHibernate(Session session) throws HibernateException {
				SQLQuery query = session.createSQLQuery(sql);

				if (values != null & values.length > 0) {
					for (int i = 0; i < values.length; i++) {
						query.setParameter(i + 1, values[i]);
					}
				}
				return query.list();
			}
		});
	}

	@Override
	public int findCount(String hql, EasyCriteria easyCriteria) {
		if (easyCriteria != null) {
			return findCount(hql + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
		} else {
			return findCount(hql);
		}
	}

	@Override
	public int findCount(final String hql, final Object... values) {
		return Integer.valueOf(getHibernateTemplate().find(hql, values).get(0).toString());
	}

	@Override
	public List findMapResultBySQL(String sql, EasyCriteria easyCriteria) {
		if (easyCriteria != null) {
			return findMapResultBySQL(sql + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
		} else {
			return findMapResultBySQL(sql);
		}
	}

	@Override
	public List findMapResultBySQL(final String sql, final Object... values) {

		return getHibernateTemplate().execute(new HibernateCallback<List>() {
			@Override
			public List doInHibernate(Session session) throws HibernateException {
				SQLQuery query = session.createSQLQuery(sql);
				if (values != null & values.length > 0) {
					for (int i = 0; i < values.length; i++) {
						query.setParameter(i + 1, values[i]);
					}
				}
				query.setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
				return query.list();
			}
		});
	}

	@Override
	public int findMaxPage(String hql, int rowsPerPage, EasyCriteria easyCriteria) {
		return (this.findCount(hql, easyCriteria) - 1) / rowsPerPage + 1;
	}

	@Override
	public int findMaxPage(String hql, int rowsPerPage, Object... values) {
		return (this.findCount(hql, values) - 1) / rowsPerPage + 1;
	}

	@Override
	public List findNamedQuery(String name, Object... values) {
		return getHibernateTemplate().findByNamedQuery(name, values);
	}

	@Override
	public List findNamedQueryByCache(String name, String queryCacheRegion, Object... values) {
		getHibernateTemplate().setCacheQueries(true);
		if (queryCacheRegion != null && (!queryCacheRegion.equals(""))) {
			getHibernateTemplate().setQueryCacheRegion(queryCacheRegion);
		}
		List list = getHibernateTemplate().findByNamedQuery(name, values);
		getHibernateTemplate().setCacheQueries(false);
		return list;
	}

	@Override
	public List findTop(String hql, int topCount, EasyCriteria easyCriteria) {

		if (easyCriteria != null) {
			return findTop(hql + " " + easyCriteria.getCondition(), topCount, easyCriteria.getValues().toArray());
		} else {
			return findTop(hql, topCount);

		}
	}

	@Override
	public List findTop(final String hql, final int topCount, final Object... values) {
		return getHibernateTemplate().execute(new HibernateCallback<List>() {
			@Override
			public List doInHibernate(Session session) throws HibernateException {
				Query q = session.createQuery(hql);
				q.setFirstResult(0);
				q.setMaxResults(topCount);
				if (values != null && values.length > 0) {
					for (int i = 0; i < values.length; i++) {
						q.setParameter(i, values[i]);
					}
				}
				return q.list();
			}
		});
	}

	@Override
	public <T> T findVal(String hql, EasyCriteria easyCriteria) {
		List list = this.find(hql, easyCriteria);
		return (T) (list.size() > 0 ? list.get(0) : null);
	}

	@Override
	public <T> T findVal(String hql, Object... values) {
		List list = this.find(hql, values);
		return (T) (list.size() > 0 ? list.get(0) : null);
	}

	@Override
	public Session getCurrentSession() {
		return HibernateSessionFactory.getSession();
	}

	@Override
	public void initialize(Object proxy) {
		if (!Hibernate.isInitialized(proxy)) {
			Hibernate.initialize(proxy);
		}
	}

	@Override
	public void initializeDeep(Collection collection) {

		if (collection == null) {
			return;
		}

		for (Object obj : collection) {
			Method[] methods = obj.getClass().getMethods();
			if (methods != null) {
				for (int j = 0; j < methods.length; j++) {
					String getName = methods[j].getName();
					if (getName.length() > 3 && getName.startsWith("get")) {
						String getFix = getName.substring(3, getName.length());
						for (int k = 0; k < methods.length; k++) {
							String setName = methods[k].getName();
							if (setName.length() > 3 && setName.startsWith("set")) {
								String setFix = setName.substring(3, setName.length());
								if (getFix.equals(setFix)) {
									try {
										Object o = methods[j].invoke(obj, new Object[0]);
										if (o != null) {
											Hibernate.initialize(o);
											methods[k].invoke(obj, o);
										}

									} catch (IllegalArgumentException e) {
										e.printStackTrace();
									} catch (IllegalAccessException e) {
										e.printStackTrace();
									} catch (InvocationTargetException e) {
										e.printStackTrace();
									}
								}
							}
						}
					}

				}
			}

		}
	}

	@Override
	public void merge(Object o) {
		getHibernateTemplate().update(o);
	}

	@Override
	public void persist(Object o) {
		getHibernateTemplate().save(o);
	}

	@Override
	public void updateByHql(String hql, Object... values) {
		getHibernateTemplate().bulkUpdate(hql, values);
	}

	@Override
	public void updateBySQL(final String sql, final Object... values) {

		getHibernateTemplate().execute(new HibernateCallback<Boolean>() {

			@Override
			public Boolean doInHibernate(Session session) throws HibernateException {

				SQLQuery query = session.createSQLQuery(sql);

				if (values != null && values.length > 0) {
					for (int i = 0; i < values.length; i++) {
						query.setParameter(i + 1, values[i]);
					}
				}
				query.executeUpdate();

				return true;
			}
		});

	}

}
