/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easycommons.commondao;

import cn.easyproject.easycommons.commondao.CommonDAO;
import cn.easyproject.easycommons.commondao.factory.HibernateSessionFactory;
import cn.easyproject.easycommons.commondao.util.EasyCriteria;
import cn.easyproject.easycommons.commondao.util.PageBean;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.jdbc.Work;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;
import org.springframework.stereotype.Repository;

@Repository(value="commonDAO")
public class CommonDAOSpringImpl
extends HibernateDaoSupport
implements CommonDAO {
    @Resource
    private SessionFactory mySessionFacotry;

    @PostConstruct
    public void injectSessionFactory() {
        super.setSessionFactory(this.mySessionFacotry);
    }

    @Override
    public void batchUpdateSQL(String sql, Object[] values) {
        this.getHibernateTemplate().bulkUpdate(sql, values);
    }

    @Override
    public void batchUpdateSQL(final String sql, final Object[][] values) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Boolean>(){

            public Boolean doInHibernate(Session session) throws HibernateException {
                session.doWork(new Work(){

                    public void execute(Connection connection) throws SQLException {
                        PreparedStatement pstmt = connection.prepareStatement(sql);
                        Object[][] objectArray = values;
                        int n = values.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object[] row = objectArray[n2];
                            int i = 0;
                            while (i < row.length) {
                                pstmt.setObject(i + 1, row[i]);
                                ++i;
                            }
                            pstmt.addBatch();
                            ++n2;
                        }
                        pstmt.executeBatch();
                    }
                });
                return true;
            }
        });
    }

    private List createQuery(String hql, boolean cacheable, String cacheRegion, Object ... values) {
        if (cacheable) {
            this.getHibernateTemplate().setCacheQueries(true);
            if (cacheRegion != null && !cacheRegion.equals("")) {
                this.getHibernateTemplate().setQueryCacheRegion(cacheRegion);
            }
        }
        List list = new ArrayList();
        list = values != null ? super.getHibernateTemplate().find(hql, values) : super.getHibernateTemplate().find(hql, new Object[0]);
        this.getHibernateTemplate().setCacheQueries(false);
        return list;
    }

    @Override
    public void remove(Class cls, Serializable id) {
        this.getHibernateTemplate().delete(this.getHibernateTemplate().get(cls, id));
    }

    @Override
    public void remove(Object o) {
        this.getHibernateTemplate().delete(o);
    }

    @Override
    public Integer deleteByValues(Class cls, String fieldName, Object[] values) {
        StringBuilder ins = new StringBuilder();
        ins.append("'");
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            ins.append(v).append("','");
            ++n2;
        }
        String hql = "delete from " + cls.getSimpleName() + " where " + fieldName + " in(" + ins.substring(0, ins.length() - 2) + ")";
        return this.getHibernateTemplate().bulkUpdate(hql, new Object[0]);
    }

    @Override
    public void deleteCascadeByValues(Class cls, String fieldName, Object[] values) {
        StringBuilder ins = new StringBuilder();
        ins.append("'");
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            ins.append(v).append("','");
            ++n2;
        }
        String hql = "from " + cls.getSimpleName() + " where " + fieldName + " in(" + ins.substring(0, ins.length() - 2) + ")";
        List list = this.getHibernateTemplate().find(hql, new Object[0]);
        for (Object o : list) {
            this.getHibernateTemplate().delete(o);
        }
    }

    @Override
    public void evict(Class cls) {
        HibernateSessionFactory.getSessionFactory().getCache().evict(cls);
    }

    @Override
    public void evict(Class cls, Serializable id) {
        HibernateSessionFactory.getSessionFactory().getCache().evict(cls, (Object)id);
    }

    @Override
    public void evictAll() {
        HibernateSessionFactory.getSessionFactory().getCache().evictAll();
    }

    @Override
    public void evictCollectionRegion(String collectionRegion) {
        HibernateSessionFactory.getSessionFactory().getCache().evictCollectionRegion(collectionRegion);
    }

    @Override
    public void evictCollectionRegion(String collectionRegion, Serializable id) {
        HibernateSessionFactory.getSessionFactory().getCache().evictCollection(collectionRegion, id);
    }

    @Override
    public void evictQueries() {
        if ("org.hibernate.cache.internal.StandardQueryCache" != null || !"".equals("org.hibernate.cache.internal.StandardQueryCache")) {
            HibernateSessionFactory.getSessionFactory().getCache().evictQueryRegion("org.hibernate.cache.internal.StandardQueryCache");
        } else {
            HibernateSessionFactory.getSessionFactory().getCache().evictQueryRegions();
        }
    }

    @Override
    public void evictQueries(String queryCacheRegion) {
        HibernateSessionFactory.getSessionFactory().getCache().evictQueryRegion(queryCacheRegion);
    }

    @Override
    public <T> T find(Class cls, Serializable id) {
        return (T)this.getHibernateTemplate().get(cls, id);
    }

    @Override
    public List find(String hql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.find(String.valueOf(hql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.find(hql, new Object[0]);
    }

    @Override
    public List find(String hql, Object ... values) {
        return this.createQuery(hql, false, null, values);
    }

    @Override
    public List findAll(Class cls) {
        String queryString = "from " + cls.getName();
        return this.createQuery(queryString, false, null, new Object[0]);
    }

    @Override
    public List findByCache(String hql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findByCache(String.valueOf(hql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findByCache(hql, new Object[0]);
    }

    @Override
    public List findByCache(String hql, Object ... values) {
        return this.createQuery(hql, true, null, values);
    }

    @Override
    public List findByCache(String hql, String queryCacheRegion, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findByCache(String.valueOf(hql) + " " + easyCriteria.getCondition(), queryCacheRegion, easyCriteria.getValues().toArray());
        }
        return this.findByCache(hql, queryCacheRegion, new Object[0]);
    }

    @Override
    public List findByCache(String hql, String queryCacheRegion, Object ... values) {
        return this.createQuery(hql, true, queryCacheRegion, values);
    }

    @Override
    public void findByPage(PageBean pageBean) {
        this.findByPage(pageBean, new ArrayList());
    }

    @Override
    public void findByPage(PageBean pageBean, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            pageBean.setCondition(easyCriteria.getCondition());
            this.findByPage(pageBean, easyCriteria.getValues());
        } else {
            this.findByPage(pageBean);
        }
    }

    @Override
    public void findByPage(final PageBean pageBean, final List values) {
        final String hql = pageBean.getAutoQuery();
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(hql);
                if (values != null && values.size() > 0) {
                    int i = 0;
                    while (i < values.size()) {
                        query.setParameter(i, values.get(i));
                        ++i;
                    }
                }
                query.setFirstResult(pageBean.getRowStart());
                query.setMaxResults(pageBean.getRowsPerPage());
                pageBean.setData(query.getResultList());
                Query cquery = session.createQuery(pageBean.getAutoCountQuery());
                if (values != null && values.size() > 0) {
                    int i = 0;
                    while (i < values.size()) {
                        cquery.setParameter(i, values.get(i));
                        ++i;
                    }
                }
                int maxRow = Integer.valueOf(cquery.getSingleResult().toString());
                pageBean.setRowsCount(maxRow);
                return null;
            }
        });
    }

    @Override
    public List findByProperty(Class cls, String propertyName, Object value) {
        String queryString = "from " + cls.getName() + " model where model." + propertyName + "= ?";
        return this.find(queryString, value);
    }

    @Override
    public List findByPropertyIgnoreCase(Class cls, String propertyName, String value) {
        String queryString = "from " + cls.getName() + " model where lower(model." + propertyName + ")= ?";
        return this.find(queryString, value.toLowerCase());
    }

    @Override
    public List findBySQL(String sql, Class resultClass, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findBySQL(String.valueOf(sql) + " " + easyCriteria.getCondition(), resultClass, easyCriteria.getValues().toArray());
        }
        return this.findBySQL(sql, resultClass, new Object[0]);
    }

    @Override
    public List findBySQL(final String sql, final Class resultClass, final Object ... values) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException {
                NativeQuery query = session.createNativeQuery(sql, resultClass);
                if (values != null & values.length > 0) {
                    int i = 0;
                    while (i < values.length) {
                        query.setParameter(i + 1, values[i]);
                        ++i;
                    }
                }
                return query.getResultList();
            }
        });
    }

    @Override
    public List findBySQL(String sql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findBySQL(String.valueOf(sql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findBySQL(sql, new Object[0]);
    }

    @Override
    public List findBySQL(final String sql, final Object ... values) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException {
                NativeQuery query = session.createNativeQuery(sql);
                if (values != null & values.length > 0) {
                    int i = 0;
                    while (i < values.length) {
                        query.setParameter(i + 1, values[i]);
                        ++i;
                    }
                }
                return query.getResultList();
            }
        });
    }

    @Override
    public int findCount(String hql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findCount(String.valueOf(hql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findCount(hql, new Object[0]);
    }

    @Override
    public int findCount(String hql, Object ... values) {
        return Integer.valueOf(this.getHibernateTemplate().find(hql, values).get(0).toString());
    }

    @Override
    public List findMapResultBySQL(String sql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findMapResultBySQL(String.valueOf(sql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findMapResultBySQL(sql, new Object[0]);
    }

    @Override
    public List findMapResultBySQL(final String sql, final Object ... values) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException {
                NativeQuery query = session.createNativeQuery(sql);
                if (values != null & values.length > 0) {
                    int i = 0;
                    while (i < values.length) {
                        query.setParameter(i + 1, values[i]);
                        ++i;
                    }
                }
                query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                return query.getResultList();
            }
        });
    }

    @Override
    public int findMaxPage(String hql, int rowsPerPage, EasyCriteria easyCriteria) {
        return (this.findCount(hql, easyCriteria) - 1) / rowsPerPage + 1;
    }

    @Override
    public int findMaxPage(String hql, int rowsPerPage, Object ... values) {
        return (this.findCount(hql, values) - 1) / rowsPerPage + 1;
    }

    @Override
    public List findNamedQuery(String name, Object ... values) {
        return this.getHibernateTemplate().findByNamedQuery(name, values);
    }

    @Override
    public List findNamedQueryByCache(String name, String queryCacheRegion, Object ... values) {
        this.getHibernateTemplate().setCacheQueries(true);
        if (queryCacheRegion != null && !queryCacheRegion.equals("")) {
            this.getHibernateTemplate().setQueryCacheRegion(queryCacheRegion);
        }
        List list = this.getHibernateTemplate().findByNamedQuery(name, values);
        this.getHibernateTemplate().setCacheQueries(false);
        return list;
    }

    @Override
    public List findTop(String hql, int topCount, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findTop(String.valueOf(hql) + " " + easyCriteria.getCondition(), topCount, easyCriteria.getValues().toArray());
        }
        return this.findTop(hql, topCount, new Object[0]);
    }

    @Override
    public List findTop(final String hql, final int topCount, final Object ... values) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException {
                Query q = session.createQuery(hql);
                q.setFirstResult(0);
                q.setMaxResults(topCount);
                if (values != null && values.length > 0) {
                    int i = 0;
                    while (i < values.length) {
                        q.setParameter(i, values[i]);
                        ++i;
                    }
                }
                return q.getResultList();
            }
        });
    }

    @Override
    public <T> T findVal(String hql, EasyCriteria easyCriteria) {
        List list = this.find(hql, easyCriteria);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public <T> T findVal(String hql, Object ... values) {
        List list = this.find(hql, values);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public Session getCurrentSession() {
        return HibernateSessionFactory.getSession();
    }

    @Override
    public void initialize(Object proxy) {
        if (!Hibernate.isInitialized((Object)proxy)) {
            Hibernate.initialize((Object)proxy);
        }
    }

    @Override
    public void initializeDeep(Collection collection) {
        if (collection == null) {
            return;
        }
        for (Object obj : collection) {
            Method[] methods = obj.getClass().getMethods();
            if (methods == null) continue;
            int j = 0;
            while (j < methods.length) {
                String getName = methods[j].getName();
                if (getName.length() > 3 && getName.startsWith("get")) {
                    String getFix = getName.substring(3, getName.length());
                    int k = 0;
                    while (k < methods.length) {
                        String setFix;
                        String setName = methods[k].getName();
                        if (setName.length() > 3 && setName.startsWith("set") && getFix.equals(setFix = setName.substring(3, setName.length()))) {
                            try {
                                Object o = methods[j].invoke(obj, new Object[0]);
                                if (o != null) {
                                    Hibernate.initialize((Object)o);
                                    methods[k].invoke(obj, o);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
    }

    @Override
    public void merge(Object o) {
        this.getHibernateTemplate().update(o);
    }

    @Override
    public void persist(Object o) {
        this.getHibernateTemplate().save(o);
    }

    @Override
    public void updateByHql(String hql, Object ... values) {
        this.getHibernateTemplate().bulkUpdate(hql, values);
    }

    @Override
    public void updateBySQL(final String sql, final Object ... values) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Boolean>(){

            public Boolean doInHibernate(Session session) throws HibernateException {
                NativeQuery query = session.createNativeQuery(sql);
                if (values != null && values.length > 0) {
                    int i = 0;
                    while (i < values.length) {
                        query.setParameter(i + 1, values[i]);
                        ++i;
                    }
                }
                query.executeUpdate();
                return true;
            }
        });
    }
}

