/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easycommons.commondao.util;

import java.io.Serializable;
import java.util.List;

public class PageBean<T>
implements Serializable {
    private static final long serialVersionUID = 5229229913348492552L;
    private static final int DEFAULT_PAGE_NO = 1;
    private static final int DEFAULT_ROWS_PER_PAGE = 10;
    private static final String DEFAULT_SELECT = "";
    private static final String DEFAULT_SORT_ORDER = "ASC";
    private String select = "";
    private int pageNo = 1;
    private int pageTotal;
    private int rowsCount;
    private int rowsPerPage = 10;
    private List<T> data;
    private String sortOrder = "ASC";
    private String sort = "";
    private String entityName = "";
    private StringBuffer conditions = new StringBuffer();
    private String lastSort = "";
    private String query;
    private String countQuery;
    private int rowStart;

    public String getAutoQuery() {
        if (this.isNotNullOrEmpty(this.query)) {
            return this.query;
        }
        String hql = String.valueOf(this.select) + " from " + this.entityName + " where 1=1 ";
        if (this.isNotNullOrEmpty(this.conditions.toString())) {
            hql = String.valueOf(hql) + this.conditions.toString();
        }
        if (this.isNotNullOrEmpty(this.sort)) {
            hql = String.valueOf(hql) + " order by " + this.sort;
            if (this.isNotNullOrEmpty(this.sortOrder)) {
                hql = String.valueOf(hql) + " " + this.sortOrder;
            }
        }
        if (this.isNotNullOrEmpty(this.sort)) {
            if (this.isNotNullOrEmpty(this.lastSort) && this.lastSort.trim().length() != 0) {
                hql = String.valueOf(hql) + "," + this.lastSort;
            }
        } else if (this.isNotNullOrEmpty(this.lastSort) && this.lastSort.trim().length() != 0) {
            hql = String.valueOf(hql) + " order by " + this.lastSort;
        }
        return hql;
    }

    public String getAutoCountQuery() {
        if (this.isNotNullOrEmpty(this.countQuery)) {
            return this.countQuery;
        }
        String hql = this.getAutoQuery();
        String queryString = DEFAULT_SELECT;
        int end = hql.length();
        if (hql.indexOf("order by") != -1) {
            end = hql.indexOf("order by");
        }
        if (hql.toUpperCase().indexOf("SELECT") != -1) {
            int i = hql.toUpperCase().indexOf("FROM");
            queryString = "select count(1) " + hql.substring(i, end);
        } else {
            queryString = "select count(1) " + hql.substring(0, end);
        }
        int j = queryString.toUpperCase().lastIndexOf("ORDER");
        if (j != -1) {
            queryString = queryString.substring(0, j);
        }
        return queryString;
    }

    public boolean isNotNullOrEmpty(String s) {
        return s != null && !s.trim().equals(DEFAULT_SELECT);
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo < 1 ? 1 : pageNo;
    }

    public int getPageTotal() {
        this.pageTotal = (this.rowsCount - 1) / this.getRowsPerPage() + 1;
        return this.pageTotal;
    }

    public void setPageTotal(int pageTotal) {
        this.pageTotal = pageTotal;
    }

    public int getRowsCount() {
        return this.rowsCount;
    }

    public void setRowsCount(int rowsCount) {
        this.rowsCount = rowsCount;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage <= 0 ? 5 : this.rowsPerPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public int getRowStart() {
        int ret = (this.pageNo - 1) * this.getRowsPerPage();
        return ret < 1 ? 0 : ret;
    }

    private void setRowStart(int rowStart) {
        this.rowStart = rowStart;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getCondition() {
        return this.conditions.toString();
    }

    public void setCondition(String condition) {
        this.conditions = new StringBuffer(condition);
    }

    public void addCondition(String condition) {
        this.conditions.append(condition);
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getLastSort() {
        return this.lastSort;
    }

    public void setLastSort(String lastSort) {
        this.lastSort = lastSort;
    }

    public String getQuery() {
        return this.query;
    }

    public String getCountQuery() {
        return this.countQuery;
    }

    public void setCountQuery(String countQuery) {
        this.countQuery = countQuery;
    }
}

