/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easycommons.commondao;

import cn.easyproject.easycommons.commondao.CommonDAO;
import cn.easyproject.easycommons.commondao.factory.HibernateSessionFactory;
import cn.easyproject.easycommons.commondao.util.EasyCriteria;
import cn.easyproject.easycommons.commondao.util.PageBean;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;

public class CommonDAOImpl
implements CommonDAO {
    @Override
    public void batchUpdateSQL(final String sql, final Object[] values) {
        Session session = HibernateSessionFactory.getSession();
        session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                block18: {
                    Statement pstmt = null;
                    try {
                        try {
                            connection.setAutoCommit(false);
                            pstmt = connection.prepareStatement(sql);
                            int i = 0;
                            while (i < values.length) {
                                pstmt.setObject(1, values[i]);
                                pstmt.addBatch();
                                ++i;
                            }
                            pstmt.executeBatch();
                            connection.commit();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (pstmt != null) {
                                try {
                                    pstmt.close();
                                }
                                catch (SQLException e2) {
                                    e2.printStackTrace();
                                }
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        if (session.isOpen()) {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public void batchUpdateSQL(final String sql, final Object[][] values) {
        Session session = HibernateSessionFactory.getSession();
        session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                block19: {
                    Statement pstmt = null;
                    try {
                        try {
                            connection.setAutoCommit(false);
                            pstmt = connection.prepareStatement(sql);
                            Object[][] objectArray = values;
                            int n = values.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object[] row = objectArray[n2];
                                int i = 0;
                                while (i < row.length) {
                                    pstmt.setObject(i + 1, row[i]);
                                    ++i;
                                }
                                pstmt.addBatch();
                                ++n2;
                            }
                            pstmt.executeBatch();
                            connection.commit();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (pstmt != null) {
                                try {
                                    pstmt.close();
                                }
                                catch (SQLException e2) {
                                    e2.printStackTrace();
                                }
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        if (session.isOpen()) {
            HibernateSessionFactory.closeSession();
        }
    }

    private Session beginTransaction() {
        Session session = HibernateSessionFactory.getSession();
        session.getTransaction().begin();
        return session;
    }

    private void close() {
        HibernateSessionFactory.closeSession();
    }

    private void commit(Session session) {
        session.getTransaction().commit();
    }

    private Query createNamedQuery(Session session, String name, boolean cacheable, String cacheRegion, Object ... values) {
        Query query = session.getNamedQuery(name.trim());
        if (cacheable) {
            query.setCacheable(true);
            if (cacheRegion != null && !cacheRegion.equals("")) {
                query.setCacheRegion(cacheRegion);
            }
        }
        if (values != null && values.length > 0) {
            int i = 0;
            while (i < values.length) {
                query.setParameter(i + 1, values[i]);
                ++i;
            }
        }
        return query;
    }

    private Query createNativeQuery(Session session, String sql, Class resultClass, boolean mapResult, Object ... values) {
        SQLQuery query = null;
        query = resultClass != null ? session.createSQLQuery(sql).addEntity(resultClass) : session.createSQLQuery(sql);
        if (mapResult) {
            query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        }
        if (values != null && values.length > 0) {
            int i = 0;
            while (i < values.length) {
                query.setParameter(i + 1, values[i]);
                ++i;
            }
        }
        return query;
    }

    private Query createQuery(Session session, String hql, boolean cacheable, String cacheRegion, Object ... values) {
        Query query = session.createQuery(hql);
        if (cacheable) {
            query.setCacheable(true);
            if (cacheRegion != null && !cacheRegion.equals("")) {
                query.setCacheRegion(cacheRegion);
            }
        }
        if (values != null && values.length > 0) {
            int i = 0;
            while (i < values.length) {
                query.setParameter(i, values[i]);
                ++i;
            }
        }
        return query;
    }

    @Override
    public Integer deleteByValues(Class cls, String idFieldName, Object[] values) {
        int res = 0;
        Session session = null;
        try {
            try {
                session = this.beginTransaction();
                StringBuilder ins = new StringBuilder();
                ins.append("'");
                Object[] objectArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    ins.append(v).append("','");
                    ++n2;
                }
                String hql = "delete from " + cls.getSimpleName() + " where " + idFieldName + " in(" + ins.substring(0, ins.length() - 2) + ")";
                res = session.createQuery(hql).executeUpdate();
                this.commit(session);
            }
            catch (RuntimeException e) {
                this.rollback(session);
                throw e;
            }
        }
        finally {
            this.close();
        }
        return res;
    }

    @Override
    public void deleteCascadeByValues(Class cls, String fieldName, Object[] values) {
        Session session = null;
        try {
            try {
                session = this.beginTransaction();
                StringBuilder ins = new StringBuilder();
                ins.append("'");
                Object[] objectArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    ins.append(v).append("','");
                    ++n2;
                }
                String hql = "from " + cls.getSimpleName() + " where " + fieldName + " in(" + ins.substring(0, ins.length() - 2) + ")";
                for (Object o : session.createQuery(hql).list()) {
                    session.delete(o);
                }
                this.commit(session);
            }
            catch (RuntimeException e) {
                this.rollback(session);
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void evict(Class cls) {
        HibernateSessionFactory.getSessionFactory().getCache().evictEntityRegion(cls);
    }

    @Override
    public void evict(Class cls, Serializable id) {
        HibernateSessionFactory.getSessionFactory().getCache().evictEntity(cls, id);
    }

    @Override
    public void evictAll() {
        HibernateSessionFactory.getSessionFactory().getCache().evictEntityRegions();
    }

    @Override
    public void evictCollectionRegion(String collectionRegion) {
        HibernateSessionFactory.getSessionFactory().getCache().evictCollectionRegion(collectionRegion);
    }

    @Override
    public void evictCollectionRegion(String collectionRegion, Serializable id) {
        HibernateSessionFactory.getSessionFactory().getCache().evictCollection(collectionRegion, id);
    }

    @Override
    public void evictQueries() {
        if ("org.hibernate.cache.internal.StandardQueryCache" != null || !"".equals("org.hibernate.cache.internal.StandardQueryCache")) {
            HibernateSessionFactory.getSessionFactory().getCache().evictQueryRegion("org.hibernate.cache.internal.StandardQueryCache");
        } else {
            HibernateSessionFactory.getSessionFactory().getCache().evictQueryRegions();
        }
    }

    @Override
    public void evictQueries(String queryCacheRegion) {
        HibernateSessionFactory.getSessionFactory().getCache().evictQueryRegion(queryCacheRegion);
    }

    @Override
    public <T> T find(Class cls, Serializable id) {
        Session session = null;
        try {
            session = HibernateSessionFactory.getSession();
            Object object = session.get(cls, id);
            return (T)object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public List find(String hql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.find(String.valueOf(hql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.find(hql, new Object[0]);
    }

    @Override
    public List find(String hql, Object ... values) {
        Session session = null;
        try {
            List list;
            session = HibernateSessionFactory.getSession();
            Query q = this.createQuery(session, hql, false, null, values);
            List list2 = list = q.list();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public List findAll(Class cls) {
        Session session = null;
        try {
            session = HibernateSessionFactory.getSession();
            String queryString = "from " + cls.getName();
            List list = session.createQuery(queryString).list();
            this.initialize(list);
            List list2 = list;
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public List findByCache(String hql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findByCache(String.valueOf(hql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findByCache(hql, new Object[0]);
    }

    @Override
    public List findByCache(String hql, Object ... values) {
        Session session = null;
        try {
            List list;
            session = HibernateSessionFactory.getSession();
            String cacheRegion = null;
            if ("org.hibernate.cache.internal.StandardQueryCache" != null || !"".equals("org.hibernate.cache.internal.StandardQueryCache")) {
                cacheRegion = "org.hibernate.cache.internal.StandardQueryCache";
            }
            Query q = this.createQuery(session, hql, true, cacheRegion, values);
            List list2 = list = q.list();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public List findByCache(String hql, String queryCacheRegion, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findByCache(String.valueOf(hql) + " " + easyCriteria.getCondition(), queryCacheRegion, easyCriteria.getValues().toArray());
        }
        return this.findByCache(hql, queryCacheRegion, new Object[0]);
    }

    @Override
    public List findByCache(String hql, String queryCacheRegion, Object ... values) {
        Session session = null;
        try {
            List list;
            session = HibernateSessionFactory.getSession();
            Query q = this.createQuery(session, hql, true, queryCacheRegion, values);
            List list2 = list = q.list();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public void findByPage(PageBean pageBean) {
        this.findByPage(pageBean, new ArrayList());
    }

    @Override
    public void findByPage(PageBean pageBean, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            pageBean.setCondition(easyCriteria.getCondition());
            this.findByPage(pageBean, easyCriteria.getValues());
        } else {
            this.findByPage(pageBean);
        }
    }

    @Override
    public void findByPage(PageBean pageBean, List values) {
        String hql = pageBean.getAutoQuery();
        Session session = null;
        try {
            session = HibernateSessionFactory.getSession();
            Query query = this.createQuery(session, hql, false, null, values.toArray());
            query.setFirstResult(pageBean.getRowStart());
            query.setMaxResults(pageBean.getRowsPerPage());
            pageBean.setData(query.list());
            Query cquery = this.createQuery(session, pageBean.getAutoCountQuery(), false, null, values.toArray());
            int maxRow = Integer.valueOf(cquery.uniqueResult().toString());
            pageBean.setRowsCount(maxRow);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public List findByProperty(Class cls, String propertyName, Object value) {
        String queryString = "from " + cls.getName() + " model where model." + propertyName + "= ?";
        return this.find(queryString, value);
    }

    @Override
    public List findByPropertyIgnoreCase(Class cls, String propertyName, String value) {
        String queryString = "from " + cls.getName() + " model where lower(model." + propertyName + ")= ?";
        return this.find(queryString, value.toLowerCase());
    }

    @Override
    public List findBySQL(String sql, Class resultClass, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findBySQL(String.valueOf(sql) + " " + easyCriteria.getCondition(), resultClass, easyCriteria.getValues().toArray());
        }
        return this.findBySQL(sql, resultClass, new Object[0]);
    }

    @Override
    public List findBySQL(String sql, Class resultClass, Object ... values) {
        Session session = null;
        try {
            List list;
            session = HibernateSessionFactory.getSession();
            Query q = this.createNativeQuery(session, sql, resultClass, false, values);
            List list2 = list = q.list();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public List findBySQL(String sql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findBySQL(String.valueOf(sql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findBySQL(sql, new Object[0]);
    }

    @Override
    public List findBySQL(String sql, Object ... values) {
        Session session = null;
        try {
            List list;
            session = HibernateSessionFactory.getSession();
            Query q = this.createNativeQuery(session, sql, null, false, values);
            List list2 = list = q.list();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public int findCount(String hql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findCount(String.valueOf(hql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findCount(hql, new Object[0]);
    }

    @Override
    public int findCount(String hql, Object ... values) {
        Session session = null;
        try {
            session = HibernateSessionFactory.getSession();
            Query q = this.createQuery(session, hql, false, null, values);
            int n = Integer.valueOf(q.uniqueResult().toString());
            return n;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public List findMapResultBySQL(String sql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findMapResultBySQL(String.valueOf(sql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findMapResultBySQL(sql, new Object[0]);
    }

    @Override
    public List findMapResultBySQL(String sql, Object ... values) {
        Session session = null;
        try {
            List list;
            session = HibernateSessionFactory.getSession();
            Query q = this.createNativeQuery(session, sql, null, true, values);
            List list2 = list = q.list();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public int findMaxPage(String hql, int rowsPerPage, EasyCriteria easyCriteria) {
        return (this.findCount(hql, easyCriteria) - 1) / rowsPerPage + 1;
    }

    @Override
    public int findMaxPage(String hql, int rowsPerPage, Object ... values) {
        return (this.findCount(hql, values) - 1) / rowsPerPage + 1;
    }

    @Override
    public List findNamedQuery(String name, Object ... values) {
        Session session = null;
        try {
            session = HibernateSessionFactory.getSession();
            Query q = this.createNamedQuery(session, name, false, null, values);
            List list = q.list();
            return list;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public List findNamedQueryByCache(String name, String queryCacheRegion, Object ... values) {
        Session session = null;
        try {
            session = HibernateSessionFactory.getSession();
            Query q = this.createNamedQuery(session, name, true, queryCacheRegion, values);
            List list = q.list();
            return list;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public List findTop(String hql, int topCount, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findTop(String.valueOf(hql) + " " + easyCriteria.getCondition(), topCount, easyCriteria.getValues().toArray());
        }
        return this.findTop(hql, topCount, new Object[0]);
    }

    @Override
    public List findTop(String hql, int topCount, Object ... values) {
        Session session = null;
        try {
            List list;
            session = HibernateSessionFactory.getSession();
            Query q = session.createQuery(hql);
            q.setFirstResult(0);
            q.setMaxResults(topCount);
            if (values != null && values.length > 0) {
                int i = 0;
                while (i < values.length) {
                    q.setParameter(i, values[i]);
                    ++i;
                }
            }
            List list2 = list = q.list();
            return list2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    @Override
    public <T> T findVal(String hql, EasyCriteria easyCriteria) {
        List list = this.find(hql, easyCriteria);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public <T> T findVal(String hql, Object ... values) {
        List list = this.find(hql, values);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public Session getCurrentSession() {
        return HibernateSessionFactory.getSession();
    }

    @Override
    public void initialize(Object proxy) {
        if (!Hibernate.isInitialized((Object)proxy)) {
            Hibernate.initialize((Object)proxy);
        }
    }

    @Override
    public void initializeDeep(Collection collection) {
        if (collection == null) {
            return;
        }
        for (Object obj : collection) {
            Method[] methods = obj.getClass().getMethods();
            if (methods == null) continue;
            int j = 0;
            while (j < methods.length) {
                String getName = methods[j].getName();
                if (getName.length() > 3 && getName.startsWith("get")) {
                    String getFix = getName.substring(3, getName.length());
                    int k = 0;
                    while (k < methods.length) {
                        String setFix;
                        String setName = methods[k].getName();
                        if (setName.length() > 3 && setName.startsWith("set") && getFix.equals(setFix = setName.substring(3, setName.length()))) {
                            try {
                                Object o = methods[j].invoke(obj, new Object[0]);
                                if (o != null) {
                                    Hibernate.initialize((Object)o);
                                    methods[k].invoke(obj, o);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
    }

    @Override
    public void merge(Object o) {
        Session session = null;
        try {
            try {
                session = this.beginTransaction();
                session.merge(o);
                this.commit(session);
            }
            catch (RuntimeException e) {
                this.rollback(session);
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void persist(Object o) {
        Session session = null;
        try {
            try {
                session = this.beginTransaction();
                session.persist(o);
                this.commit(session);
            }
            catch (RuntimeException e) {
                this.rollback(session);
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void remove(Class cls, Serializable id) {
        Session session = null;
        try {
            try {
                session = this.beginTransaction();
                session.delete(session.get(cls, id));
                this.commit(session);
            }
            catch (RuntimeException e) {
                this.rollback(session);
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void remove(Object o) {
        Session session = null;
        try {
            try {
                session = this.beginTransaction();
                session.delete(o);
                this.commit(session);
            }
            catch (RuntimeException e) {
                this.rollback(session);
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    private void rollback(Session session) {
        Transaction txn = session.getTransaction();
        if (txn != null && txn.isActive()) {
            txn.rollback();
        }
    }

    @Override
    public void updateByHql(String hql, Object ... values) {
        Session session = null;
        try {
            try {
                session = this.beginTransaction();
                Query query = session.createQuery(hql);
                if (values != null && values.length > 0) {
                    int i = 0;
                    while (i < values.length) {
                        query.setParameter(i, values[i]);
                        ++i;
                    }
                }
                query.executeUpdate();
                this.commit(session);
            }
            catch (RuntimeException e) {
                this.rollback(session);
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void updateBySQL(String sql, Object ... values) {
        Session session = null;
        try {
            try {
                session = this.beginTransaction();
                SQLQuery query = session.createSQLQuery(sql);
                if (values != null && values.length > 0) {
                    int i = 0;
                    while (i < values.length) {
                        query.setParameter(i + 1, values[i]);
                        ++i;
                    }
                }
                query.executeUpdate();
                this.commit(session);
            }
            catch (RuntimeException e) {
                this.rollback(session);
                throw e;
            }
        }
        finally {
            this.close();
        }
    }
}

