/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easybackup.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompressFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(DecompressFileUtil.class);

    public static boolean decompress(String compressType, File compressFile, File outDir, String encoding) {
        if ((compressType = compressType.toUpperCase()).equals("ZIP")) {
            if (outDir != null) {
                return DecompressFileUtil.decompressZip(compressFile, outDir);
            }
            return DecompressFileUtil.decompressZip(compressFile);
        }
        if (compressType.equals("TAR")) {
            if (outDir != null) {
                return DecompressFileUtil.decompressTar(compressFile, outDir, encoding);
            }
            return DecompressFileUtil.decompressTar(compressFile, encoding);
        }
        if (compressType.equals("GZIP") || compressType.equals("TAR.GZ")) {
            if (outDir != null) {
                return DecompressFileUtil.decompressGzip(compressFile, outDir, encoding);
            }
            return DecompressFileUtil.decompressGzip(compressFile, encoding);
        }
        throw new RuntimeException("compressType must in: TAR(*.tar), ZIP(*.zip), GZIP(*.tar.gz)");
    }

    public static boolean decompress(String compressType, File compressFile, File outDir) {
        return DecompressFileUtil.decompress(compressType, compressFile, outDir, null);
    }

    public static boolean decompress(String compressType, File compressFile, String encoding) {
        return DecompressFileUtil.decompress(compressType, compressFile, null, encoding);
    }

    public static boolean decompress(String compressType, File compressFile) {
        return DecompressFileUtil.decompress(compressType, compressFile, null, null);
    }

    public static boolean decompressGzip(File gzipFile) {
        return DecompressFileUtil.decompressGzip(gzipFile, "");
    }

    public static boolean decompressGzip(File gzipFile, File outDir) {
        return DecompressFileUtil.decompressGzip(gzipFile, outDir, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressGzip(File gzipFile, File outDir, String encoding) {
        boolean res = false;
        String outFileName = gzipFile.getName();
        if (gzipFile.getName().lastIndexOf(".") != -1) {
            outFileName = gzipFile.getName().substring(0, gzipFile.getName().lastIndexOf("."));
        }
        if (outDir.isFile()) {
            logger.error(outDir.getAbsolutePath() + " exists a file!");
            return false;
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        TarArchiveInputStream in = null;
        try {
            in = encoding == null || encoding.equals("") ? new TarArchiveInputStream((InputStream)new BufferedInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(gzipFile)))) : new TarArchiveInputStream((InputStream)new BufferedInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(gzipFile))), encoding);
            TarArchiveEntry zae = null;
            while ((zae = in.getNextTarEntry()) != null) {
                File outFile = new File(outDir, zae.getName());
                if (zae.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                outFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(outFile);
                IOUtils.copy((InputStream)in, (OutputStream)new BufferedOutputStream(out));
                ((OutputStream)out).close();
            }
            res = true;
        }
        catch (Exception e) {
            logger.error("decompressTar error.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error("decompressTar error.", (Throwable)e);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressGzip(File gzipFile, String encoding) {
        boolean res = false;
        TarArchiveInputStream in = null;
        try {
            in = encoding == null || encoding.equals("") ? new TarArchiveInputStream((InputStream)new BufferedInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(gzipFile)))) : new TarArchiveInputStream((InputStream)new BufferedInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(gzipFile))), encoding);
            TarArchiveEntry zae = null;
            while ((zae = in.getNextTarEntry()) != null) {
                File outFile = new File(gzipFile.getParent(), zae.getName());
                if (zae.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                outFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(outFile);
                IOUtils.copy((InputStream)in, (OutputStream)new BufferedOutputStream(out));
                ((OutputStream)out).close();
            }
            res = true;
        }
        catch (Exception e) {
            logger.error("decompress error. " + gzipFile.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error("decompress error. ", (Throwable)e);
                }
            }
        }
        return res;
    }

    public static boolean decompressTar(File tarFile) {
        return DecompressFileUtil.decompressTar(tarFile, "");
    }

    public static boolean decompressTar(File tarFile, File outDir) {
        return DecompressFileUtil.decompressTar(tarFile, outDir, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressTar(File tarFile, File outDir, String encoding) {
        boolean res = false;
        String outFileName = tarFile.getName();
        if (tarFile.getName().lastIndexOf(".") != -1) {
            outFileName = tarFile.getName().substring(0, tarFile.getName().lastIndexOf("."));
        }
        if (outDir.isFile()) {
            logger.error(outDir.getAbsolutePath() + " exists a file!");
            return false;
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        TarArchiveInputStream in = null;
        try {
            in = encoding == null || encoding.equals("") ? new TarArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(tarFile))) : new TarArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(tarFile)), encoding);
            TarArchiveEntry zae = null;
            while ((zae = in.getNextTarEntry()) != null) {
                File outFile = new File(outDir, zae.getName());
                if (zae.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                outFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(outFile);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                ((OutputStream)out).close();
            }
            res = true;
        }
        catch (Exception e) {
            logger.error("decompressTar error.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error("decompressTar error.", (Throwable)e);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressTar(File tarFile, String encoding) {
        boolean res = false;
        TarArchiveInputStream in = null;
        try {
            in = encoding == null || encoding.equals("") ? new TarArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(tarFile))) : new TarArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(tarFile)), encoding);
            TarArchiveEntry zae = null;
            while ((zae = in.getNextTarEntry()) != null) {
                File outFile = new File(tarFile.getParent(), zae.getName());
                if (zae.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                outFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(outFile);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                ((OutputStream)out).close();
            }
            res = true;
        }
        catch (Exception e) {
            logger.error("decompress error. " + tarFile.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error("decompress error. ", (Throwable)e);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressZip(File zipFile) {
        boolean res = false;
        ArchiveInputStream in = null;
        try {
            in = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)new BufferedInputStream(new FileInputStream(zipFile)));
            ZipArchiveEntry zae = null;
            while ((zae = (ZipArchiveEntry)in.getNextEntry()) != null) {
                File outFile = new File(zipFile.getParent(), zae.getName());
                if (zae.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                outFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(outFile);
                IOUtils.copy((InputStream)in, (OutputStream)new BufferedOutputStream(out));
                ((OutputStream)out).close();
            }
            res = true;
        }
        catch (Exception e) {
            logger.error("decompressZip error.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error("decompressZip error.", (Throwable)e);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressZip(File zipFile, File outDir) {
        boolean res = false;
        String outFileName = zipFile.getName();
        if (zipFile.getName().lastIndexOf(".") != -1) {
            outFileName = zipFile.getName().substring(0, zipFile.getName().lastIndexOf("."));
        }
        if (outDir.isFile()) {
            logger.error(outDir.getAbsolutePath() + " exists a file!");
            return false;
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        ArchiveInputStream in = null;
        try {
            in = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)new BufferedInputStream(new FileInputStream(zipFile)));
            ZipArchiveEntry zae = null;
            while ((zae = (ZipArchiveEntry)in.getNextEntry()) != null) {
                File outFile = new File(outDir, zae.getName());
                if (zae.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                outFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(outFile);
                IOUtils.copy((InputStream)in, (OutputStream)new BufferedOutputStream(out));
                ((OutputStream)out).close();
            }
            res = true;
        }
        catch (Exception e) {
            logger.error("decompressZip error.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error("decompressZip error.", (Throwable)e);
                }
            }
        }
        return res;
    }
}

