/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easybackup.job;

import cn.easyproject.easybackup.EasyBackup;
import cn.easyproject.easybackup.backup.StdBackupEngine;
import cn.easyproject.easybackup.job.JobManager;
import cn.easyproject.easybackup.util.SpringUtil;
import java.io.FileInputStream;
import java.io.IOException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ReloadConfigurationJob
extends QuartzJobBean {
    static Logger logger = LoggerFactory.getLogger(ReloadConfigurationJob.class);
    public static long propertiesLastModify;

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (EasyBackup.getPropertiesFile() != null) {
            try {
                long lastModify = EasyBackup.getPropertiesFile().lastModified();
                if (lastModify != propertiesLastModify) {
                    EasyBackup.getProperties().load(new FileInputStream(EasyBackup.getPropertiesFile()));
                    propertiesLastModify = lastModify;
                    JobManager jobManager = (JobManager)SpringUtil.get("jobManager");
                    jobManager.clear();
                    StdBackupEngine stdBackup = new StdBackupEngine();
                    stdBackup.start();
                    logger.info("the EasyBackup properties file [" + EasyBackup.getPropertiesFile().getName() + "] already reload.");
                }
            }
            catch (IOException e) {
                logger.error("Read EasyBackup properties file [" + EasyBackup.getPropertiesFile().getName() + "]  error.", (Throwable)e);
            }
        } else {
            logger.error("easybackup.properties file not found.");
        }
    }
}

