/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easybackup;

import cn.easyproject.easybackup.BackupRuntime;
import cn.easyproject.easybackup.backup.StdBackupEngine;
import cn.easyproject.easybackup.job.ReloadConfigurationJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class EasyBackup {
    static Logger logger = LoggerFactory.getLogger(EasyBackup.class);
    private static Properties properties = null;
    private static File propertiesFile;
    private static File userPropertiesFile;

    public void start() {
        if (!BackupRuntime.started) {
            this.loadProperties();
            if (propertiesFile != null) {
                StdBackupEngine stdBackup = new StdBackupEngine();
                stdBackup.start();
            }
        } else {
            logger.info("EasyBackup is already started!");
        }
    }

    private void loadProperties() {
        if (userPropertiesFile != null) {
            try {
                properties = new Properties();
                properties.load(new FileInputStream(userPropertiesFile));
                propertiesFile = userPropertiesFile;
                ReloadConfigurationJob.propertiesLastModify = propertiesFile.lastModified();
            }
            catch (IOException e) {
                logger.error("Read file:easybackup.properties error.", (Throwable)e);
            }
            return;
        }
        PathMatchingResourcePatternResolver rl = new PathMatchingResourcePatternResolver();
        Resource res = rl.getResource("file:easybackup.properties");
        Resource res2 = rl.getResource("classpath:easybackup.properties");
        if (!res.exists() && !res2.exists()) {
            logger.error("easybackup.properties not found.");
            return;
        }
        boolean loadProperties = false;
        if (res.exists()) {
            try {
                properties = new Properties();
                properties.load(res.getInputStream());
                propertiesFile = res.getFile();
                ReloadConfigurationJob.propertiesLastModify = propertiesFile.lastModified();
                loadProperties = true;
            }
            catch (IOException e) {
                logger.error("Read file:easybackup.properties error.", (Throwable)e);
            }
        }
        if (!loadProperties) {
            try {
                properties = new Properties();
                properties.load(res2.getInputStream());
                propertiesFile = res2.getFile();
                ReloadConfigurationJob.propertiesLastModify = propertiesFile.lastModified();
            }
            catch (IOException e) {
                logger.error("Read classpath:easybackup.properties error.", (Throwable)e);
            }
        }
    }

    public static void setPropertiesFile(File userPropertiesFile) {
        EasyBackup.userPropertiesFile = userPropertiesFile;
    }

    public static File getPropertiesFile() {
        return userPropertiesFile != null ? userPropertiesFile : propertiesFile;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static void main(String[] args) {
        new EasyBackup().start();
    }
}

