/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easybackup.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(CompressFileUtil.class);

    public static boolean compress(String compressType, File srcFile, File compressFile, String encoding) {
        if ((compressType = compressType.toUpperCase()).equals("ZIP")) {
            return CompressFileUtil.compressToZip(srcFile, compressFile);
        }
        if (compressType.equals("TAR")) {
            return CompressFileUtil.compressToTar(srcFile, compressFile, encoding);
        }
        if (compressType.equals("GZIP") || compressType.equals("TAR.GZ")) {
            return CompressFileUtil.compressToGzip(srcFile, compressFile, encoding);
        }
        throw new RuntimeException("compressType must in: TAR(*.tar), ZIP(*.zip), GZIP(*.tar.gz)");
    }

    public static boolean compress(String compressType, File srcFile, File compressFile) {
        return CompressFileUtil.compress(compressType, srcFile, compressFile, null);
    }

    public static boolean addNewFileToGzip(File newFile, File tarFile) {
        return CompressFileUtil.addNewFileToGzip(newFile, tarFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addNewFileToGzip(File newFile, File gzipFile, String encoding) {
        boolean res = false;
        File temp_file = new File(gzipFile.getParent(), gzipFile.getName() + ".temp");
        while (temp_file.exists()) {
            String temp_file_name = temp_file.getName() + ".temp";
            temp_file = new File(gzipFile.getParent(), temp_file_name);
        }
        TarArchiveOutputStream tos = null;
        TarArchiveInputStream in = null;
        BufferedInputStream bis = null;
        boolean flag = false;
        try {
            if (encoding != null && !encoding.equals("")) {
                tos = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new FileOutputStream(temp_file))), encoding);
                in = new TarArchiveInputStream((InputStream)new BufferedInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(gzipFile))), encoding);
            } else {
                tos = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new FileOutputStream(temp_file))));
                in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(gzipFile))));
            }
            tos.setLongFileMode(2);
            TarArchiveEntry zae = null;
            while ((zae = in.getNextTarEntry()) != null) {
                tos.putArchiveEntry((ArchiveEntry)zae);
                if (!zae.isDirectory()) {
                    IOUtils.copy((InputStream)in, (OutputStream)tos);
                }
                tos.closeArchiveEntry();
            }
            if (newFile.isDirectory()) {
                CompressFileUtil.tarDirectory(tos, newFile, newFile.getAbsolutePath());
            } else {
                zae = new TarArchiveEntry(newFile.getName());
                zae.setSize(newFile.length());
                tos.putArchiveEntry((ArchiveEntry)zae);
                bis = new BufferedInputStream(new FileInputStream(newFile));
                IOUtils.copy((InputStream)bis, (OutputStream)tos);
                tos.closeArchiveEntry();
                bis.close();
            }
            flag = true;
        }
        catch (Exception e) {
            logger.error("addNewFileToGzip error.", (Throwable)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.error("addNewFileToGzip error.", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error("addNewFileToGzip error.", (Throwable)e);
                }
            }
            if (tos != null) {
                try {
                    tos.close();
                }
                catch (Exception e) {
                    logger.error("addNewFileToGzip error.", (Throwable)e);
                }
            }
        }
        if (flag) {
            gzipFile.delete();
            temp_file.renameTo(gzipFile);
            res = true;
        } else {
            temp_file.delete();
        }
        return res;
    }

    public static boolean addNewFileToTar(File newFile, File tarFile) {
        return CompressFileUtil.addNewFileToTar(newFile, tarFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addNewFileToTar(File newFile, File tarFile, String encoding) {
        boolean res = false;
        File temp_file = new File(tarFile.getParent(), tarFile.getName() + ".temp");
        while (temp_file.exists()) {
            String temp_file_name = temp_file.getName() + ".temp";
            temp_file = new File(tarFile.getParent(), temp_file_name);
        }
        TarArchiveOutputStream tos = null;
        TarArchiveInputStream in = null;
        BufferedInputStream bis = null;
        boolean flag = false;
        try {
            if (encoding != null && !encoding.equals("")) {
                tos = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(temp_file)), encoding);
                in = new TarArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(tarFile)), encoding);
            } else {
                tos = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(temp_file)));
                in = new TarArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(tarFile)));
            }
            tos.setLongFileMode(2);
            TarArchiveEntry zae = null;
            while ((zae = in.getNextTarEntry()) != null) {
                tos.putArchiveEntry((ArchiveEntry)zae);
                if (!zae.isDirectory()) {
                    IOUtils.copy((InputStream)in, (OutputStream)tos);
                }
                tos.closeArchiveEntry();
            }
            if (newFile.isDirectory()) {
                CompressFileUtil.tarDirectory(tos, newFile, newFile.getAbsolutePath());
            } else {
                zae = new TarArchiveEntry(newFile.getName());
                zae.setSize(newFile.length());
                tos.putArchiveEntry((ArchiveEntry)zae);
                bis = new BufferedInputStream(new FileInputStream(newFile));
                IOUtils.copy((InputStream)bis, (OutputStream)tos);
                tos.closeArchiveEntry();
            }
            flag = true;
        }
        catch (Exception e) {
            logger.error("addNewFileToTar error.", (Throwable)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.error("addNewFileToGzip error.", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error("addNewFileToTar error.", (Throwable)e);
                }
            }
            if (tos != null) {
                try {
                    tos.close();
                }
                catch (Exception e) {
                    logger.error("addNewFileToTar error.", (Throwable)e);
                }
            }
        }
        if (flag) {
            tarFile.delete();
            temp_file.renameTo(tarFile);
            res = true;
        } else {
            temp_file.delete();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addNewFileToZip(File newFile, File zipFile) {
        boolean res = false;
        File temp_file = new File(zipFile.getParent(), zipFile.getName() + ".temp");
        while (temp_file.exists()) {
            String temp_file_name = temp_file.getName() + ".temp";
            temp_file = new File(zipFile.getParent(), temp_file_name);
        }
        ZipFile zf = null;
        ZipArchiveOutputStream zos = null;
        BufferedInputStream bis = null;
        boolean flag = false;
        try {
            ZipArchiveEntry zae;
            zf = new ZipFile(zipFile);
            zos = new ZipArchiveOutputStream(temp_file);
            Enumeration ze = zf.getEntries();
            while (ze.hasMoreElements()) {
                zae = (ZipArchiveEntry)ze.nextElement();
                zos.putArchiveEntry((ArchiveEntry)zae);
                if (!zae.isDirectory()) {
                    IOUtils.copy((InputStream)zf.getInputStream(zae), (OutputStream)zos);
                }
                zos.closeArchiveEntry();
            }
            if (newFile.isDirectory()) {
                CompressFileUtil.zipDirectory(zos, newFile, newFile.getAbsolutePath());
            } else {
                zae = new ZipArchiveEntry(newFile.getName());
                zos.putArchiveEntry((ArchiveEntry)zae);
                bis = new BufferedInputStream(new FileInputStream(newFile));
                IOUtils.copy((InputStream)bis, (OutputStream)zos);
                zos.closeArchiveEntry();
            }
            flag = true;
        }
        catch (Exception e) {
            logger.error("addNewFileToZip error.", (Throwable)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.error("addNewFileToGzip error.", (Throwable)e);
                }
            }
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (Exception e) {
                    logger.error("addNewFileToZip error.", (Throwable)e);
                }
            }
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception e) {
                    logger.error("addNewFileToZip error.", (Throwable)e);
                }
            }
        }
        if (flag) {
            zipFile.delete();
            temp_file.renameTo(zipFile);
            res = true;
        } else {
            temp_file.delete();
        }
        return res;
    }

    public static boolean compressToGzip(File srcFile, File gzipFile) {
        return CompressFileUtil.compressToGzip(srcFile, gzipFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressToGzip(File srcFile, File gzipFile, String encoding) {
        boolean res = false;
        TarArchiveOutputStream tos = null;
        BufferedInputStream bis = null;
        try {
            if (!gzipFile.getParentFile().exists()) {
                gzipFile.getParentFile().mkdirs();
            }
            tos = encoding != null && !encoding.equals("") ? new TarArchiveOutputStream((OutputStream)new BufferedOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new FileOutputStream(gzipFile))), encoding) : new TarArchiveOutputStream((OutputStream)new BufferedOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new FileOutputStream(gzipFile))));
            tos.setLongFileMode(2);
            if (srcFile.isDirectory()) {
                CompressFileUtil.tarDirectory(tos, srcFile, srcFile.getAbsolutePath());
            } else {
                TarArchiveEntry zae = new TarArchiveEntry(srcFile.getName());
                zae.setSize(srcFile.length());
                tos.putArchiveEntry((ArchiveEntry)zae);
                bis = new BufferedInputStream(new FileInputStream(srcFile));
                IOUtils.copy((InputStream)bis, (OutputStream)tos);
                tos.closeArchiveEntry();
            }
            res = true;
        }
        catch (Exception e) {
            logger.error("compressToGzip error.", (Throwable)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.error("addNewFileToGzip error.", (Throwable)e);
                }
            }
            if (tos != null) {
                try {
                    tos.close();
                }
                catch (Exception e2) {
                    logger.error("compressToGzip error.");
                }
            }
        }
        return res;
    }

    public static boolean compressToTar(File srcFile, File tarFile) {
        return CompressFileUtil.compressToTar(srcFile, tarFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressToTar(File srcFile, File tarFile, String encoding) {
        boolean res = false;
        TarArchiveOutputStream tos = null;
        BufferedInputStream bis = null;
        try {
            if (!tarFile.getParentFile().exists()) {
                tarFile.getParentFile().mkdirs();
            }
            tos = encoding != null && !encoding.equals("") ? new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(tarFile)), encoding) : new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(tarFile)));
            tos.setLongFileMode(2);
            if (srcFile.isDirectory()) {
                CompressFileUtil.tarDirectory(tos, srcFile, srcFile.getAbsolutePath());
            } else {
                TarArchiveEntry zae = new TarArchiveEntry(srcFile.getName());
                zae.setSize(srcFile.length());
                tos.putArchiveEntry((ArchiveEntry)zae);
                bis = new BufferedInputStream(new FileInputStream(srcFile));
                IOUtils.copy((InputStream)bis, (OutputStream)tos);
                tos.closeArchiveEntry();
            }
            res = true;
        }
        catch (Exception e) {
            logger.error("compressToTar error.", (Throwable)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.error("addNewFileToGzip error.", (Throwable)e);
                }
            }
            if (tos != null) {
                try {
                    tos.close();
                }
                catch (Exception e2) {
                    logger.error("compressToTar error.");
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressToZip(File srcFile, File zipFile) {
        boolean res = false;
        ZipArchiveOutputStream zos = null;
        BufferedInputStream bis = null;
        try {
            if (!zipFile.getParentFile().exists()) {
                zipFile.getParentFile().mkdirs();
            }
            zos = (ZipArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)new BufferedOutputStream(new FileOutputStream(zipFile)));
            if (srcFile.isDirectory()) {
                CompressFileUtil.zipDirectory(zos, srcFile, srcFile.getAbsolutePath());
            } else {
                ZipArchiveEntry zae = new ZipArchiveEntry(srcFile.getName());
                zos.putArchiveEntry((ArchiveEntry)zae);
                bis = new BufferedInputStream(new FileInputStream(srcFile));
                IOUtils.copy((InputStream)bis, (OutputStream)zos);
                zos.closeArchiveEntry();
            }
            res = true;
        }
        catch (Exception e) {
            logger.error("compressToZip error.", (Throwable)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.error("addNewFileToGzip error.", (Throwable)e);
                }
            }
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception e2) {
                    logger.error("compressToZip error.");
                }
            }
        }
        return res;
    }

    private static void tarDirectory(TarArchiveOutputStream zos, File file, String rootpath) throws IOException {
        if (file.isDirectory()) {
            TarArchiveEntry list;
            String nowfileName = file.getAbsolutePath().replace(rootpath, "");
            if (!nowfileName.equals("")) {
                String entryName = nowfileName.substring(1) + File.separator;
                TarArchiveEntry tae = new TarArchiveEntry(file, entryName);
                try {
                    tae.setSize(file.length());
                    zos.putArchiveEntry((ArchiveEntry)tae);
                    zos.closeArchiveEntry();
                }
                catch (Exception e) {
                    logger.error("tarDirectory error.", (Throwable)e);
                }
            }
            for (String f : list = file.list()) {
                CompressFileUtil.tarDirectory(zos, new File(file, f), rootpath);
            }
        } else {
            String entryName = file.getAbsolutePath().replace(rootpath + File.separator, "");
            TarArchiveEntry tae = new TarArchiveEntry(entryName);
            tae.setSize(file.length());
            zos.putArchiveEntry((ArchiveEntry)tae);
            BufferedInputStream bis = null;
            try {
                bis = new BufferedInputStream(new FileInputStream(file));
                IOUtils.copy((InputStream)bis, (OutputStream)zos);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
            zos.closeArchiveEntry();
        }
    }

    private static void zipDirectory(ZipArchiveOutputStream zos, File file, String rootpath) {
        if (file.isDirectory()) {
            ZipArchiveEntry list;
            String nowfileName = file.getAbsolutePath().replace(rootpath, "");
            if (!nowfileName.equals("")) {
                String entryName = nowfileName.substring(1) + File.separator;
                ZipArchiveEntry zae = new ZipArchiveEntry(file, entryName);
                try {
                    zos.putArchiveEntry((ArchiveEntry)zae);
                    zos.closeArchiveEntry();
                }
                catch (Exception e) {
                    logger.error("tarDirectory error.", (Throwable)e);
                }
            }
            for (String f : list = file.list()) {
                CompressFileUtil.zipDirectory(zos, new File(file, f), rootpath);
            }
        } else {
            String entryName = file.getAbsolutePath().replace(rootpath + File.separator, "");
            ZipArchiveEntry zae = new ZipArchiveEntry(entryName);
            try {
                zos.putArchiveEntry((ArchiveEntry)zae);
                BufferedInputStream bis = null;
                try {
                    bis = new BufferedInputStream(new FileInputStream(file));
                    IOUtils.copy((InputStream)bis, (OutputStream)zos);
                }
                catch (IOException e) {
                    throw e;
                }
                finally {
                    if (bis != null) {
                        bis.close();
                    }
                }
                zos.closeArchiveEntry();
            }
            catch (Exception e) {
                logger.error("tarDirectory error.", (Throwable)e);
            }
        }
    }
}

