/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easybackup.sender.mail;

import cn.easyproject.easybackup.configuration.BackupConfiguration;
import cn.easyproject.easybackup.sender.Sender;
import cn.easyproject.easybackup.util.CompressFileUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.util.FileSystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSender
implements Sender {
    static Logger logger = LoggerFactory.getLogger(MailSender.class);
    static Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
    private JavaMailSenderImpl sender = new JavaMailSenderImpl();

    @Override
    public void send(File targetFile, List<File> backupFiles, BackupConfiguration configuration) {
        if (configuration.getMailSender() == null || configuration.getMailReceiver() == null || configuration.getMailReceiver().length == 0) {
            logger.warn("You are not configuration Mail Sender or Receiver. Please Check your mail sender and recevier.");
            return;
        }
        try {
            logger.info(configuration.getType().name() + "-" + configuration.getName() + ", start send backup file [" + backupFiles + "] to mail[" + Arrays.toString(configuration.getMailReceiver()) + "]");
            this.sender.setUsername(configuration.getMailSender());
            this.sender.setPassword(configuration.getMailSenderPassword());
            this.sender.setHost(configuration.getMailSenderHost());
            this.sender.setPort(configuration.getMailSenderPort().intValue());
            Properties senderProperties = new Properties();
            senderProperties.setProperty("mail.smtp.auth", "true");
            if (configuration.getMailSenderSsl().booleanValue()) {
                senderProperties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            this.sender.setJavaMailProperties(senderProperties);
            MimeMessage mm = this.sender.createMimeMessage();
            MimeMessageHelper smm = new MimeMessageHelper(mm, true, "utf-8");
            smm.setFrom(configuration.getMailSender());
            smm.setTo(configuration.getMailReceiver());
            smm.setReplyTo(configuration.getMailSender());
            smm.setSubject(configuration.getMailSenderTitle());
            Template template = cfg.getTemplate(configuration.getMailSenderTemplate());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("targetFileName", targetFile.getName());
            data.put("type", configuration.getType().name());
            data.put("name", configuration.getName());
            data.put("value", configuration.getValue());
            data.put("backuptime", configuration.getLastBackupTime());
            data.put("backupConfiguration", configuration);
            String text = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, data);
            smm.setText(text, true);
            File backupFile = backupFiles.get(0);
            if (backupFile.isFile()) {
                smm.addAttachment(backupFile.getName(), backupFile);
                this.sender.send(mm);
            } else {
                File zipFile = new File(backupFile.getParent(), backupFile.getName() + ".zip");
                CompressFileUtil.compressToZip(backupFile, zipFile);
                smm.addAttachment(zipFile.getName(), zipFile);
                this.sender.send(mm);
                zipFile.delete();
            }
            if (configuration.getMailDeleteBackup().booleanValue()) {
                logger.info(configuration.getType().name() + "-" + configuration.getName() + " send over, delete backup file.");
                FileSystemUtils.deleteRecursively((File)backupFile);
            }
            logger.info(configuration.getType().name() + "-" + configuration.getName() + " already send mail to [" + Arrays.toString(configuration.getMailReceiver()) + "." + " last backup file name: " + configuration.getLastBackupFileName() + ", last backup file time: " + configuration.getLastBackupTime() + ", last backup file result: " + configuration.isLastBackupResult());
        }
        catch (MailException e) {
            logger.error(configuration.getType().name() + "-" + configuration.getName() + " send mail error, please check you sender configuration", (Throwable)e);
        }
        catch (MessagingException e) {
            logger.error(configuration.getType().name() + "-" + configuration.getName() + " send mail error, please check you sender configuration", (Throwable)e);
        }
        catch (IOException e) {
            logger.error(configuration.getType().name() + "-" + configuration.getName() + " send mail error, please check you sender configuration", (Throwable)e);
        }
        catch (TemplateException e) {
            logger.error(configuration.getType().name() + "-" + configuration.getName() + " send mail template error, please check you mail.tpl configuration", (Throwable)e);
        }
        catch (Exception e) {
            logger.error(configuration.getType().name() + "-" + configuration.getName() + " send mail error, please check you sender configuration", (Throwable)e);
        }
    }

    static {
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setDefaultEncoding("UTF-8");
        try {
            File directory = new File("");
            String courseFile = directory.getCanonicalPath();
            cfg.setDirectoryForTemplateLoading(new File(courseFile, "template"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

