/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easybackup.job;

import cn.easyproject.easybackup.backup.StdBackupEngine;
import cn.easyproject.easybackup.configuration.GlobalConfiguration;
import cn.easyproject.easybackup.job.JobManager;
import cn.easyproject.easybackup.util.SpringUtil;
import java.io.IOException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ReloadConfigurationJob
extends QuartzJobBean {
    static Logger logger = LoggerFactory.getLogger(ReloadConfigurationJob.class);
    public static long propertiesLastModify;

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        PathMatchingResourcePatternResolver rl = new PathMatchingResourcePatternResolver();
        Resource res = rl.getResource("file:easybackup.properties");
        if (res.exists()) {
            try {
                long lastModify = res.getFile().lastModified();
                if (lastModify != propertiesLastModify) {
                    GlobalConfiguration.properties.load(res.getInputStream());
                    propertiesLastModify = lastModify;
                    JobManager jobManager = (JobManager)SpringUtil.get("jobManager");
                    jobManager.clear();
                    StdBackupEngine stdBackup = new StdBackupEngine();
                    stdBackup.start();
                    logger.info("easybackup.properties already reload.");
                }
            }
            catch (IOException e) {
                logger.error("Read easybackup.properties error.", (Throwable)e);
            }
        } else {
            logger.error("easybackup.properties not found.");
        }
    }
}

