/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easybackup.job;

import cn.easyproject.easybackup.backup.interceptor.BackupAfter;
import cn.easyproject.easybackup.backup.interceptor.BackupBefore;
import cn.easyproject.easybackup.configuration.BackupConfiguration;
import cn.easyproject.easybackup.job.JobManager;
import cn.easyproject.easybackup.sender.Sender;
import cn.easyproject.easybackup.util.FreemarkerUtil;
import cn.easyproject.easybackup.util.SpringUtil;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

@DisallowConcurrentExecution
public class BackupJob
extends QuartzJobBean {
    private static Logger logger = LoggerFactory.getLogger(BackupJob.class);

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        File targetFile;
        long start = System.currentTimeMillis();
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        BackupConfiguration configuration = (BackupConfiguration)jobDataMap.get((Object)"configuration");
        if (configuration == null) {
            return;
        }
        JobManager jobManager = (JobManager)SpringUtil.get("jobManager");
        jobManager.pauseJob(context);
        this.commandExecute(configuration, configuration.getBeforeClass());
        if (configuration.getBefore().size() > 0) {
            for (BackupBefore before : configuration.getBefore()) {
                logger.debug(configuration.getType().name() + "-" + configuration.getName() + " execute before interceptor [" + before.getClass().getName() + "].");
                boolean res = before.execute(configuration);
                if (res) continue;
                logger.info(configuration.getType().name() + "-" + configuration.getName() + " BackupBefore interceptor class [" + before.getClass().getName() + "] " + " return false, the backup cancel.");
                jobManager.resumeJob(context);
                return;
            }
        }
        if ((targetFile = configuration.getTargetFile().getFile(configuration)) == null) {
            logger.error(configuration.getType().name() + "-" + configuration.getName() + " cancel backup, the file [" + targetFile + "] you want backup is null.");
            jobManager.resumeJob(context);
            return;
        }
        if (!targetFile.exists()) {
            logger.warn(configuration.getType().name() + "-" + configuration.getName() + " cancel backup, he file [" + targetFile + "] you want backup is not exists.");
            jobManager.resumeJob(context);
            return;
        }
        List<File> backupDirs = configuration.getBackupDir().getDir(configuration);
        if (backupDirs.size() == 0) {
            logger.error(configuration.getType().name() + "-" + configuration.getName() + " backup dir [" + configuration.getDir() + "] is empty.");
            jobManager.resumeJob(context);
            return;
        }
        String backupFileName = configuration.getBackupFile().getFile(configuration);
        if (backupFileName == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssS");
            backupFileName = "${targetFileName}-" + sdf.format(new Date());
        }
        if (configuration.getCompress().booleanValue()) {
            backupFileName = configuration.getCompressType().equalsIgnoreCase("gzip") ? backupFileName + ".tar.gz" : backupFileName + "." + configuration.getCompressType().toLowerCase();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("targetFileName", targetFile.getName());
        data.put("name", configuration.getName());
        data.put("type", (Object)configuration.getType());
        data.put("value", configuration.getValue());
        data.put("backuptime", new Date());
        data.put("backupConfiguration", configuration);
        backupFileName = FreemarkerUtil.formatTemplate(backupFileName, data);
        data.put("backupFileName", backupFileName);
        configuration.setLastBackupTime(new Date());
        configuration.setLastBackupFileName(backupFileName);
        boolean backupRes = true;
        ArrayList<File> backupFiles = new ArrayList<File>();
        for (File file : backupDirs) {
            File backupFile = new File(file, backupFileName);
            backupFiles.add(backupFile);
        }
        for (File file : backupFiles) {
            if (targetFile.equals(file)) {
                logger.warn(configuration.getType().name() + "-" + configuration.getName() + " Your targetFile equals backupFile, " + "backup success.");
                configuration.setLastBackupResult(true);
                continue;
            }
            boolean res = configuration.getBackup().execute(targetFile, file, configuration);
            backupRes = backupRes && res;
        }
        configuration.setLastBackupResult(backupRes);
        if (configuration.isLastBackupResult()) {
            logger.info(configuration.getType().name() + "-" + configuration.getName() + " backup success." + " last backup file name: " + configuration.getLastBackupFileName() + ", last backup file time: " + configuration.getLastBackupTime() + ", last backup file result: " + configuration.isLastBackupResult());
            if (configuration.isDeleteTargetFile()) {
                boolean isDelete = true;
                for (File backupFile : backupFiles) {
                    if (!targetFile.equals(backupFile)) continue;
                    isDelete = false;
                    break;
                }
                if (isDelete) {
                    logger.info(configuration.getType().name() + "-" + configuration.getName() + " delete targetFile");
                    boolean bl = targetFile.delete();
                    if (!bl) {
                        logger.info(configuration.getType().name() + "-" + configuration.getName() + " delete targetFile failure. maybe the file is locked, please delete manual.");
                    }
                }
            }
        } else {
            logger.warn(configuration.getType().name() + "-" + configuration.getName() + " backup failure." + " last backup file name: " + configuration.getLastBackupFileName() + ", last backup file time: " + configuration.getLastBackupTime() + ", last backup file result: " + configuration.isLastBackupResult());
        }
        this.commandExecute(configuration, configuration.getBeforeClass());
        if (configuration.getAfter().size() > 0) {
            for (BackupAfter backupAfter : configuration.getAfter()) {
                logger.debug(configuration.getType().name() + "-" + configuration.getName() + " execute after interceptor [" + backupAfter.getClass().getName() + "].");
                backupAfter.execute(configuration);
            }
        }
        if (configuration.getSenders().size() > 0) {
            configuration.setMailSenderTitle(FreemarkerUtil.formatTemplate(configuration.getMailSenderTitle(), data));
            configuration.setLastBackupTime(new Date());
        }
        for (Sender sender : configuration.getSenders()) {
            sender.send(targetFile, backupFiles, configuration);
        }
        long end = System.currentTimeMillis();
        logger.info(configuration.getType().name() + "-" + configuration.getName() + " backup completed, cost in " + (end - start) + " ms");
        jobManager.resumeJob(context);
    }

    private boolean commandExecute(BackupConfiguration configuration, String[] cmds) {
        boolean res = false;
        if (cmds == null || cmds.length == 0) {
            return true;
        }
        for (String cmd : cmds) {
            try {
                logger.debug(configuration.getType().name() + "-" + configuration.getName() + " execute command [" + cmds + "].");
                Process proc = Runtime.getRuntime().exec(cmd);
                proc.waitFor();
            }
            catch (IOException e) {
                logger.error(configuration.getType().name() + "-" + configuration.getName() + " execute command [" + cmd + "] error.", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error(configuration.getType().name() + "-" + configuration.getName() + " execute command [" + cmd + "] error.", (Throwable)e);
            }
        }
        return res;
    }
}

