/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easybackup.backup;

import cn.easyproject.easybackup.BackupType;
import cn.easyproject.easybackup.backup.BackupEngine;
import cn.easyproject.easybackup.backup.file.BackupDir;
import cn.easyproject.easybackup.backup.file.BackupFile;
import cn.easyproject.easybackup.backup.file.TargetFile;
import cn.easyproject.easybackup.backup.file.impl.DefaultBackupDir;
import cn.easyproject.easybackup.backup.file.impl.DefaultBackupFile;
import cn.easyproject.easybackup.backup.file.impl.DefaultTargtFile;
import cn.easyproject.easybackup.backup.impls.Backup;
import cn.easyproject.easybackup.backup.impls.FileBackup;
import cn.easyproject.easybackup.backup.interceptor.BackupAfter;
import cn.easyproject.easybackup.backup.interceptor.BackupBefore;
import cn.easyproject.easybackup.configuration.BackupConfiguration;
import cn.easyproject.easybackup.configuration.GlobalConfiguration;
import cn.easyproject.easybackup.job.JobManager;
import cn.easyproject.easybackup.sender.Sender;
import cn.easyproject.easybackup.sender.mail.MailSender;
import cn.easyproject.easybackup.util.EasyUtil;
import cn.easyproject.easybackup.util.SpringUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdBackupEngine
implements BackupEngine {
    static Logger logger = LoggerFactory.getLogger(StdBackupEngine.class);
    private static GlobalConfiguration globalConfig = new GlobalConfiguration();
    private static List<BackupConfiguration> backups = new ArrayList<BackupConfiguration>();

    private static String getCompressType(String type) {
        if ((type = type.trim().toUpperCase()).equals("ZIP") || type.equals("TAR") || type.equals("GZIP")) {
            return type;
        }
        return "ZIP";
    }

    public void initConfig() {
        Properties p = GlobalConfiguration.properties;
        String globalEnable = p.getProperty("easybackup.enable", "ON");
        String globalDeleteTargetFile = p.getProperty("easybackup.deleteTargetFile", "OFF");
        String globalBackupDir = p.getProperty("easybackup.dir", null);
        String globalBackupFile = p.getProperty("easybackup.file", null);
        String globalCompress = p.getProperty("easybackup.compress", "OFF");
        String globalCompressType = p.getProperty("easybackup.compressType", "ZIP");
        String globalCompressEncoding = p.getProperty("easybackup.compressEncoding", null);
        String globalCronExpression = p.getProperty("easybackup.cronexpression", "0 30 * * * ?");
        String globalCmdBefore = p.getProperty("easymonitor.cmd.before", null);
        String globalCmdAfter = p.getProperty("easymonitor.cmd.after", null);
        String globalBeforeClass = p.getProperty("easymonitor.cmd.before", null);
        String globalAfterClass = p.getProperty("easymonitor.cmd.after", null);
        String globalMailReceiver = p.getProperty("easybackup.mail.receiver", null);
        String globalMailSender = p.getProperty("easybackup.mail.sender", null);
        String globalMailSenderPassword = p.getProperty("easybackup.mail.sender.passowrd", null);
        String globalMailSenderHost = p.getProperty("easybackup.mail.sender.host", null);
        String globalMailSenderSsl = p.getProperty("easybackup.mail.sender.ssl", null);
        String globalMailSenderTitle = p.getProperty("easybackup.mail.sender.title", null);
        String globalMailSenderTemplate = p.getProperty("easybackup.mail.sender.template", null);
        String globalDeleteBackup = p.getProperty("easybackup.mail.deleteBackup", "OFF");
        Integer globalMailPort = 25;
        try {
            globalMailPort = Integer.valueOf(p.getProperty("easybackup.mail.sender.port", "25"));
        }
        catch (NumberFormatException e) {
            logger.warn("'easybackup.mail.sender.port' is not a integer, use default 25.");
        }
        globalConfig.setEnable(EasyUtil.isTrue(globalEnable));
        globalConfig.setCronExpression(globalCronExpression);
        globalConfig.setDir(EasyUtil.isNotEmpty(globalBackupDir) ? globalBackupDir.split("##") : null);
        globalConfig.setFile(globalBackupFile);
        globalConfig.setCompress(EasyUtil.isTrue(globalCompress));
        globalConfig.setCompressType(StdBackupEngine.getCompressType(globalCompressType));
        globalConfig.setCompressEncoding(globalCompressEncoding);
        globalConfig.setDeleteTargetFile(EasyUtil.isTrue(globalDeleteTargetFile));
        globalConfig.setCmdBefore(EasyUtil.isNotEmpty(globalCmdBefore) ? globalCmdBefore.split("##") : null);
        globalConfig.setCmdAfter(EasyUtil.isNotEmpty(globalCmdAfter) ? globalCmdAfter.split("##") : null);
        globalConfig.setBeforeClass(EasyUtil.isNotEmpty(globalBeforeClass) ? globalBeforeClass.split("##") : null);
        globalConfig.setAfterClass(EasyUtil.isNotEmpty(globalAfterClass) ? globalAfterClass.split("##") : null);
        globalConfig.setMailReceiver(EasyUtil.isNotEmpty(globalMailReceiver) ? globalMailReceiver.split("##") : null);
        globalConfig.setMailSender(globalMailSender);
        globalConfig.setMailSenderPassword(globalMailSenderPassword);
        globalConfig.setMailSenderHost(globalMailSenderHost);
        globalConfig.setMailSenderPort(globalMailPort);
        globalConfig.setMailSenderSsl(EasyUtil.isTrue(globalMailSenderSsl));
        globalConfig.setMailSenderTitle(globalMailSenderTitle);
        globalConfig.setMailSenderTemplate(globalMailSenderTemplate);
        globalConfig.setMailDeleteBackup(EasyUtil.isTrue(globalDeleteBackup));
        HashSet<String> configNames = new HashSet<String>();
        Enumeration<?> names = p.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (key.startsWith("easybackup.file.")) {
                if ((key = key.substring("easybackup.file.".length())).indexOf(".") != -1) continue;
                configNames.add("FILE:" + key);
                continue;
            }
            if (!key.startsWith("easybackup.user.") || (key = key.substring("easybackup.user.".length())).indexOf(".") != -1) continue;
            configNames.add("USER:" + key);
        }
        logger.debug("configNames: " + configNames);
        for (String name : configNames) {
            String[] senderImpls;
            BackupConfiguration configuration = new BackupConfiguration();
            String startWith = "easybackup.url.";
            if (name.startsWith("FILE:")) {
                startWith = "easybackup.file.";
                name = name.substring("FILE:".length());
                configuration.setType(BackupType.FILE);
                configuration.setBackup(new FileBackup());
            } else if (name.startsWith("USER:")) {
                startWith = "easybackup.user.";
                name = name.substring("USER:".length());
                configuration.setType(BackupType.USER);
            }
            String value = startWith + name;
            String backupClass = startWith + name + ".backupClass";
            String enable = startWith + name + ".enable";
            String dir = startWith + name + ".dir";
            String file = startWith + name + ".file";
            String targetFileClass = startWith + name + ".targetFileClass";
            String dirClass = startWith + name + ".dirClass";
            String fileClass = startWith + name + ".fileClass";
            String compress = startWith + name + ".compress";
            String compressType = startWith + name + ".compressType";
            String compressEncoding = startWith + name + ".compressEncoding";
            String cronexpression = startWith + name + ".cronexpression";
            String deleteTargetFile = startWith + name + ".deleteTargetFile";
            String cmdBefore = startWith + name + ".cmd.before";
            String cmdAfter = startWith + name + ".cmd.after";
            String beforeClass = startWith + name + ".cmd.beforeClass";
            String afterClass = startWith + name + ".cmd.afterClass";
            String receiver = startWith + name + ".mail.receiver";
            String sender = startWith + name + ".mail.sender";
            String senderPassowrd = startWith + name + ".mail.sender.passowrd";
            String senderHost = startWith + name + ".mail.sender.host";
            String senderPort = startWith + name + ".mail.sender.port";
            String senderSsl = startWith + name + ".mail.sender.ssl";
            String senderTitle = startWith + name + ".mail.sender.title";
            String senderTemplate = startWith + name + ".mail.sender.template";
            String deleteBackup = startWith + name + ".mail.deleteBackup";
            String senders = startWith + name + ".senders";
            value = p.getProperty(value, null);
            backupClass = p.getProperty(backupClass, null);
            enable = p.getProperty(enable, null);
            dir = p.getProperty(dir, null);
            file = p.getProperty(file, null);
            targetFileClass = p.getProperty(targetFileClass, null);
            dirClass = p.getProperty(dirClass, null);
            fileClass = p.getProperty(fileClass, null);
            deleteTargetFile = p.getProperty(deleteTargetFile, null);
            compress = p.getProperty(compress, null);
            compressType = p.getProperty(compressType, null);
            compressEncoding = p.getProperty(compressEncoding, null);
            cronexpression = p.getProperty(cronexpression, null);
            cmdBefore = p.getProperty(cmdBefore, null);
            cmdAfter = p.getProperty(cmdAfter, null);
            beforeClass = p.getProperty(beforeClass, null);
            afterClass = p.getProperty(afterClass, null);
            receiver = p.getProperty(receiver, null);
            sender = p.getProperty(sender, null);
            senderPassowrd = p.getProperty(senderPassowrd, null);
            senderHost = p.getProperty(senderHost, null);
            senderPort = p.getProperty(senderPort, null);
            senderSsl = p.getProperty(senderSsl, null);
            senderTitle = p.getProperty(senderTitle, null);
            senderTemplate = p.getProperty(senderTemplate, null);
            deleteBackup = p.getProperty(deleteBackup, null);
            senders = p.getProperty(senders, null);
            Integer backupMailPort = globalConfig.getMailSenderPort();
            if (senderPort != null) {
                try {
                    backupMailPort = Integer.valueOf(senderPort);
                }
                catch (NumberFormatException e) {
                    logger.warn("'" + startWith + name + ".mail.sender.interval' is not a integer, use default " + backupMailPort + ".", (Throwable)e);
                }
            }
            if (backupMailPort == null) {
                backupMailPort = 25;
            }
            configuration.setName(name);
            configuration.setValue(value);
            configuration.setEnable(enable != null ? EasyUtil.isTrue(enable) : globalConfig.getEnable());
            configuration.setDeleteTargetFile(deleteTargetFile != null ? EasyUtil.isTrue(deleteTargetFile) : globalConfig.isDeleteTargetFile());
            configuration.setDir(dir != null ? dir.split("##") : globalConfig.getDir());
            configuration.setFile(file != null ? file : globalConfig.getFile());
            configuration.setCompress(compress != null ? EasyUtil.isTrue(compress) : globalConfig.getCompress());
            configuration.setCompressType(compressType != null ? StdBackupEngine.getCompressType(compressType) : globalConfig.getCompressType());
            configuration.setCompressEncoding(compressEncoding != null ? compressEncoding : globalCompressEncoding);
            configuration.setCronExpression(cronexpression != null ? cronexpression : globalConfig.getCronExpression());
            configuration.setMailReceiver(receiver != null ? receiver.split("##") : globalConfig.getMailReceiver());
            configuration.setMailSender(sender != null ? sender : globalConfig.getMailSender());
            configuration.setMailSenderPassword(senderPassowrd != null ? senderPassowrd : globalConfig.getMailSenderPassword());
            configuration.setMailSenderHost(senderHost != null ? senderHost : globalConfig.getMailSenderHost());
            configuration.setMailSenderPort(backupMailPort);
            configuration.setMailSenderSsl(senderSsl != null ? EasyUtil.isTrue(senderSsl) : globalConfig.getMailSenderSsl());
            configuration.setMailSenderTitle(senderTitle != null ? senderTitle : globalConfig.getMailSenderTitle());
            configuration.setMailSenderTemplate(senderTemplate != null ? senderTemplate : globalConfig.getMailSenderTemplate());
            configuration.setMailDeleteBackup(deleteBackup != null ? EasyUtil.isTrue(deleteBackup) : globalConfig.getMailDeleteBackup());
            configuration.setCmdBefore(cmdBefore != null ? cmdBefore.split("##") : globalConfig.getCmdBefore());
            configuration.setCmdAfter(cmdAfter != null ? cmdAfter.split("##") : globalConfig.getCmdAfter());
            configuration.setBeforeClass(beforeClass != null ? beforeClass.split("##") : globalConfig.getBeforeClass());
            configuration.setAfterClass(afterClass != null ? afterClass.split("##") : globalConfig.getAfterClass());
            if (configuration.getBeforeClass() != null && configuration.getBeforeClass().length > 0) {
                for (String cls : configuration.getBeforeClass()) {
                    try {
                        BackupBefore before = (BackupBefore)Class.forName(cls.trim()).newInstance();
                        configuration.getBefore().add(before);
                    }
                    catch (InstantiationException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the beforeClass [" + cls + "] is not implements 'cn.easyproject.easybackup.backup.interceptor.BackupBefore' interface.", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the beforeClass [" + cls + "] is IllegalAccessException.", (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the beforeClass [" + cls + "] is not found.", (Throwable)e);
                    }
                }
            }
            if (configuration.getAfterClass() != null && configuration.getAfterClass().length > 0) {
                for (String cls : configuration.getAfterClass()) {
                    try {
                        BackupAfter after = (BackupAfter)Class.forName(cls.trim()).newInstance();
                        configuration.getAfter().add(after);
                    }
                    catch (InstantiationException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the afterClass [" + cls + "] is not implements 'cn.easyproject.easybackup.backup.interceptor.BackupAfter' interface.", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the afterClass [" + cls + "] is IllegalAccessException.", (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the afterClass [" + cls + "] is not found.", (Throwable)e);
                    }
                }
            }
            if (configuration.getType() == BackupType.FILE) {
                configuration.setTargetFile(new DefaultTargtFile());
                configuration.setBackupDir(new DefaultBackupDir());
                configuration.setBackupFile(new DefaultBackupFile());
                configuration.setBackup(new FileBackup());
                if (!EasyUtil.isNotEmpty(configuration.getValue())) {
                    logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "Backup file value is empty, the backup is cancel.", (Throwable)new RuntimeException("Backup file value is empty!"));
                    continue;
                }
            } else {
                if (!EasyUtil.isNotEmpty(configuration.getValue()) && !EasyUtil.isNotEmpty(configuration.getFileClass())) {
                    logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "Backup file value is empty, the backup is cancel.", (Throwable)new RuntimeException("Backup file value is empty!"));
                    continue;
                }
                if (EasyUtil.isNotEmpty(targetFileClass)) {
                    boolean flag = false;
                    ReflectiveOperationException e2 = null;
                    try {
                        TargetFile targetFile = (TargetFile)Class.forName(targetFileClass.trim()).newInstance();
                        configuration.setTargetFile(targetFile);
                        flag = true;
                    }
                    catch (InstantiationException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the targeFileClass [" + targetFileClass + "] is not implements 'cn.easyproject.easybackup.backup.file.TargetFile' interface.", (Throwable)e);
                        e2 = e;
                    }
                    catch (IllegalAccessException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the targeFileClass [" + targetFileClass + "] is IllegalAccessException.", (Throwable)e);
                        e2 = e;
                    }
                    catch (ClassNotFoundException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the targeFileClass [" + targetFileClass + "] is not found.", (Throwable)e);
                        e2 = e;
                    }
                    if (!flag) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "' targeFileClass [" + targetFileClass + "] error, the backup is cancel.", (Throwable)e2);
                        continue;
                    }
                } else {
                    configuration.setTargetFile(new DefaultTargtFile());
                }
                if (EasyUtil.isNotEmpty(backupClass)) {
                    boolean flag = false;
                    ReflectiveOperationException e2 = null;
                    try {
                        Backup backup = (Backup)Class.forName(backupClass.trim()).newInstance();
                        configuration.setBackup(backup);
                        flag = true;
                    }
                    catch (InstantiationException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the backupClass [" + backupClass + "] is not implements 'cn.easyproject.easybackup.backup.file.TargetFile' interface.", (Throwable)e);
                        e2 = e;
                    }
                    catch (IllegalAccessException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the backupClass [" + backupClass + "] is IllegalAccessException.", (Throwable)e);
                        e2 = e;
                    }
                    catch (ClassNotFoundException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the backupClass [" + backupClass + "] is not found.", (Throwable)e);
                        e2 = e;
                    }
                    if (!flag) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "' backupClass [" + backupClass + "] error, the backup is cancel.", (Throwable)e2);
                        continue;
                    }
                } else {
                    configuration.setBackup(new FileBackup());
                }
                if (EasyUtil.isNotEmpty(dirClass)) {
                    boolean flag = false;
                    ReflectiveOperationException e2 = null;
                    try {
                        BackupDir backupDir = (BackupDir)Class.forName(dirClass.trim()).newInstance();
                        configuration.setBackupDir(backupDir);
                        flag = true;
                    }
                    catch (InstantiationException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the dirClass [" + dirClass + "] is not implements 'cn.easyproject.easybackup.backup.file.TargetFile' interface.", (Throwable)e);
                        e2 = e;
                    }
                    catch (IllegalAccessException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the dirClass [" + dirClass + "] is IllegalAccessException.", (Throwable)e);
                        e2 = e;
                    }
                    catch (ClassNotFoundException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the dirClass [" + dirClass + "] is not found.", (Throwable)e);
                        e2 = e;
                    }
                    if (!flag) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "' dirClass [" + dirClass + "] error, the backup is cancel.", (Throwable)e2);
                        continue;
                    }
                } else {
                    configuration.setBackupDir(new DefaultBackupDir());
                }
                if (EasyUtil.isNotEmpty(fileClass)) {
                    boolean flag = false;
                    ReflectiveOperationException e2 = null;
                    try {
                        BackupFile backupFile = (BackupFile)Class.forName(fileClass.trim()).newInstance();
                        configuration.setBackupFile(backupFile);
                        flag = true;
                    }
                    catch (InstantiationException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the fileClass [" + fileClass + "] is not implements 'cn.easyproject.easybackup.backup.file.TargetFile' interface.", (Throwable)e);
                        e2 = e;
                    }
                    catch (IllegalAccessException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the fileClass [" + fileClass + "] is IllegalAccessException.", (Throwable)e);
                        e2 = e;
                    }
                    catch (ClassNotFoundException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the fileClass [" + fileClass + "] is not found.", (Throwable)e);
                        e2 = e;
                    }
                    if (!flag) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "' fileClass [" + fileClass + "] error, the backup is cancel.", (Throwable)e2);
                        continue;
                    }
                } else {
                    configuration.setBackupFile(new DefaultBackupFile());
                }
            }
            if (!EasyUtil.isNotEmpty(configuration.getMailSenderTemplate())) {
                logger.warn("Not configuration '" + startWith + name + ".mail.sender.template'. Use default 'mail.tpl'");
                configuration.setMailSenderTemplate("mail.tpl");
            }
            if (senders != null && (senderImpls = senders.split("##")).length > 0) {
                for (String cls : senderImpls) {
                    if ("".equals(cls)) continue;
                    try {
                        Sender userSender = (Sender)Class.forName(cls).newInstance();
                        configuration.getSenders().add(userSender);
                    }
                    catch (InstantiationException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the Sender class [" + cls + "] is not implements 'cn.easyproject.easybackup.sender.Sender' interface.", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the Sender class [" + cls + "] is IllegalAccessException.", (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error(configuration.getType().name() + "-" + configuration.getName() + ": '" + configuration.getValue() + "', the Sender class [" + cls + "] is not found.", (Throwable)e);
                    }
                }
            }
            if (configuration.getMailSender() != null && configuration.getMailReceiver() != null && configuration.getMailReceiver().length != 0) {
                configuration.getSenders().add(new MailSender());
            }
            backups.add(configuration);
        }
    }

    public void initJob() {
        JobManager jobManager = (JobManager)SpringUtil.get("jobManager");
        if (backups.size() == 0) {
            logger.info("No running backup services");
        }
        for (BackupConfiguration configuration : backups) {
            logger.info(configuration.toString());
            jobManager.addJob(configuration);
        }
        jobManager.reloadConfigurationJob();
    }

    public void start() {
        this.initConfig();
        this.initJob();
    }
}

