/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easybackup;

import cn.easyproject.easybackup.backup.StdBackupEngine;
import cn.easyproject.easybackup.configuration.GlobalConfiguration;
import cn.easyproject.easybackup.job.ReloadConfigurationJob;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class EasyBackup {
    static Logger logger = LoggerFactory.getLogger(EasyBackup.class);

    public void start() {
        PathMatchingResourcePatternResolver rl = new PathMatchingResourcePatternResolver();
        Resource res = rl.getResource("file:easybackup.properties");
        if (res.exists()) {
            GlobalConfiguration.properties = new Properties();
            try {
                GlobalConfiguration.properties.load(res.getInputStream());
                ReloadConfigurationJob.propertiesLastModify = res.getFile().lastModified();
                StdBackupEngine stdBackup = new StdBackupEngine();
                stdBackup.start();
            }
            catch (IOException e) {
                logger.error("Read easybackup.properties error.", (Throwable)e);
            }
        } else {
            logger.error("easybackup.properties not found.");
        }
    }

    public static void main(String[] args) {
        new EasyBackup().start();
    }
}

