/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.storage;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobContainerPermissions;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.file.CloudFile;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.file.CloudFileDirectory;
import com.microsoft.azure.storage.file.CloudFileShare;
import com.microsoft.azure.storage.queue.CloudQueue;
import com.microsoft.azure.storage.queue.CloudQueueClient;
import com.microsoft.azure.storage.queue.CloudQueueMessage;
import com.microsoft.azure.storage.queue.MessageUpdateFields;
import com.microsoft.azure.storage.table.CloudTable;
import com.microsoft.azure.storage.table.CloudTableClient;
import com.microsoft.azure.storage.table.EntityProperty;
import com.microsoft.azure.storage.table.EntityResolver;
import com.microsoft.azure.storage.table.TableBatchOperation;
import com.microsoft.azure.storage.table.TableEntity;
import com.microsoft.azure.storage.table.TableOperation;
import com.microsoft.azure.storage.table.TableQuery;
import com.microsoft.azure.storage.table.TableResult;
import com.microsoft.azure.storage.table.TableServiceEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageUtil {
    public static CloudBlobClient blobClientCreate(String connectionString) throws InvalidKeyException, URISyntaxException {
        CloudStorageAccount account = CloudStorageAccount.parse((String)connectionString);
        return account.createCloudBlobClient();
    }

    public static CloudBlobContainer blobContainerCreate(CloudBlobClient serviceClient, String containerName) throws URISyntaxException, StorageException {
        CloudBlobContainer container = serviceClient.getContainerReference(containerName);
        container.createIfNotExists();
        return container;
    }

    public static boolean blobDelete(CloudBlobClient serviceClient, String containerName, String blobName) throws URISyntaxException, StorageException, FileNotFoundException, IOException {
        CloudBlobContainer container = serviceClient.getContainerReference(containerName);
        return StorageUtil.blobDelete(container, blobName);
    }

    public static boolean blobDelete(CloudBlobContainer container, String blobName) throws URISyntaxException, StorageException, FileNotFoundException, IOException {
        CloudBlockBlob blob = container.getBlockBlobReference(blobName);
        return blob.deleteIfExists();
    }

    public static boolean blobDeleteContainer(CloudBlobClient serviceClient, String containerName) throws URISyntaxException, StorageException {
        CloudBlobContainer container = serviceClient.getContainerReference(containerName);
        return container.deleteIfExists();
    }

    public static void blobDownload(CloudBlobClient serviceClient, String containerName, String blobName, File destinationFile) throws URISyntaxException, StorageException, FileNotFoundException, IOException {
        CloudBlobContainer container = serviceClient.getContainerReference(containerName);
        StorageUtil.blobDownload(container, blobName, destinationFile);
    }

    public static void blobDownload(CloudBlobContainer container, String blobName, File destinationFile) throws URISyntaxException, StorageException, FileNotFoundException, IOException {
        CloudBlockBlob blob = container.getBlockBlobReference(blobName);
        blob.downloadToFile(destinationFile.getAbsolutePath());
    }

    public static void blobSetPublic(CloudBlobClient serviceClient, String containerName) throws StorageException, URISyntaxException {
        CloudBlobContainer container = serviceClient.getContainerReference(containerName);
        StorageUtil.blobSetPublic(container);
    }

    public static void blobSetPublic(CloudBlobContainer container) throws StorageException {
        BlobContainerPermissions containerPermissions = new BlobContainerPermissions();
        containerPermissions.setPublicAccess(BlobContainerPublicAccessType.CONTAINER);
        container.uploadPermissions(containerPermissions);
    }

    public static void blobUpload(CloudBlobClient serviceClient, String containerName, String blobName, File sourceFile) throws URISyntaxException, StorageException, FileNotFoundException, IOException {
        CloudBlobContainer container = serviceClient.getContainerReference(containerName);
        StorageUtil.blobUpload(container, blobName, sourceFile);
    }

    public static void blobUpload(CloudBlobContainer container, String blobName, File sourceFile) throws URISyntaxException, StorageException, FileNotFoundException, IOException {
        CloudBlockBlob blob = container.getBlockBlobReference(blobName);
        blob.upload((InputStream)new FileInputStream(sourceFile), sourceFile.length());
    }

    public static CloudFileClient fileClientCreate(String connectionString) throws InvalidKeyException, URISyntaxException {
        CloudStorageAccount account = CloudStorageAccount.parse((String)connectionString);
        return account.createCloudFileClient();
    }

    public static void fileCreateDirectory(CloudFileClient fileClient, String shareName, String directioyName) throws URISyntaxException, StorageException, IOException {
        CloudFileShare share = StorageUtil.fileShareCreate(fileClient, shareName);
        StorageUtil.fileCreateDirectory(share, directioyName);
    }

    public static void fileCreateDirectory(CloudFileShare share, String directioyName) throws URISyntaxException, StorageException, IOException {
        CloudFileDirectory rootDir = share.getRootDirectoryReference();
        CloudFileDirectory sampleDir = rootDir.getDirectoryReference(directioyName);
        sampleDir.createIfNotExists();
    }

    public static boolean fileDelete(CloudFileClient fileClient, String shareName, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileShare share = StorageUtil.fileShareCreate(fileClient, shareName);
        return StorageUtil.fileDelete(share, fileName);
    }

    public static boolean fileDelete(CloudFileClient fileClient, String shareName, String directoryName, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileShare share = StorageUtil.fileShareCreate(fileClient, shareName);
        return StorageUtil.fileDelete(share, directoryName, fileName);
    }

    public static boolean fileDelete(CloudFileShare share, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileDirectory rootDir = share.getRootDirectoryReference();
        CloudFile file = rootDir.getFileReference(fileName);
        return file.deleteIfExists();
    }

    public static boolean fileDelete(CloudFileShare share, String directoryName, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileDirectory rootDir = share.getRootDirectoryReference();
        CloudFileDirectory containerDir = rootDir.getDirectoryReference(directoryName);
        CloudFile file = containerDir.getFileReference(fileName);
        return file.deleteIfExists();
    }

    public static boolean fileDeleteShare(CloudFileClient fileClient, String shareName) throws URISyntaxException, StorageException {
        CloudFileShare share = fileClient.getShareReference(shareName);
        return share.deleteIfExists();
    }

    public static boolean fileDirectoryDelete(CloudFileClient fileClient, String shareName, String directory) throws URISyntaxException, StorageException, IOException {
        CloudFileShare share = fileClient.getShareReference(shareName);
        return StorageUtil.fileDirectoryDelete(share, directory);
    }

    public static boolean fileDirectoryDelete(CloudFileShare share, String directory) throws URISyntaxException, StorageException, IOException {
        CloudFileDirectory rootDir = share.getRootDirectoryReference();
        return rootDir.getDirectoryReference(directory).deleteIfExists();
    }

    public static CloudFile fileDownload(CloudFileClient fileClient, String shareName, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileShare share = StorageUtil.fileShareCreate(fileClient, shareName);
        return StorageUtil.fileDownload(share, fileName);
    }

    public static CloudFile fileDownload(CloudFileClient fileClient, String shareName, String directoryName, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileShare share = StorageUtil.fileShareCreate(fileClient, shareName);
        return StorageUtil.fileDownload(share, directoryName, fileName);
    }

    public static CloudFile fileDownload(CloudFileShare share, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileDirectory rootDir = share.getRootDirectoryReference();
        CloudFile file = rootDir.getFileReference(fileName);
        return file;
    }

    public static CloudFile fileDownload(CloudFileShare share, String directoryName, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileDirectory rootDir = share.getRootDirectoryReference();
        CloudFileDirectory sampleDir = rootDir.getDirectoryReference(directoryName);
        CloudFile file = sampleDir.getFileReference(fileName);
        return file;
    }

    public static CloudFileShare fileShareCreate(CloudFileClient fileClient, String shareName) throws URISyntaxException, StorageException {
        CloudFileShare share = fileClient.getShareReference("sampleshare");
        share.createIfNotExists();
        return share;
    }

    public static void fileUpload(CloudFileClient fileClient, String shareName, String filePath, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileShare share = StorageUtil.fileShareCreate(fileClient, shareName);
        StorageUtil.fileUpload(share, filePath, fileName);
    }

    public static void fileUpload(CloudFileClient fileClient, String shareName, String directory, String filePath, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileShare share = StorageUtil.fileShareCreate(fileClient, shareName);
        StorageUtil.fileUpload(share, directory, filePath, fileName);
    }

    public static void fileUpload(CloudFileShare share, String filePath, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileDirectory rootDir = share.getRootDirectoryReference();
        CloudFile cloudFile = rootDir.getFileReference(fileName);
        cloudFile.uploadFromFile(filePath);
    }

    public static void fileUpload(CloudFileShare share, String directory, String filePath, String fileName) throws URISyntaxException, StorageException, IOException {
        CloudFileDirectory rootDir = share.getRootDirectoryReference();
        CloudFileDirectory dir = rootDir.getDirectoryReference(directory);
        dir.createIfNotExists();
        CloudFile cloudFile = dir.getFileReference(fileName);
        cloudFile.uploadFromFile(filePath);
    }

    public static void queueAddMessage(CloudQueue queue, String message) throws URISyntaxException, StorageException {
        CloudQueueMessage queueMessage = new CloudQueueMessage(message);
        queue.addMessage(queueMessage);
    }

    public static void queueAddMessage(CloudQueue queue, String message, int timeToLiveInSeconds, int initialVisibilityDelayInSeconds) throws URISyntaxException, StorageException {
        CloudQueueMessage queueMessage = new CloudQueueMessage(message);
        queue.addMessage(queueMessage, timeToLiveInSeconds, initialVisibilityDelayInSeconds, null, null);
    }

    public static void queueAddMessage(CloudQueueClient queueClient, String queueName, String message) throws URISyntaxException, StorageException {
        CloudQueue queue = queueClient.getQueueReference(queueName);
        StorageUtil.queueAddMessage(queue, message);
    }

    public static void queueAddMessage(CloudQueueClient queueClient, String queueName, String message, int timeToLiveInSeconds, int initialVisibilityDelayInSeconds) throws URISyntaxException, StorageException {
        CloudQueue queue = queueClient.getQueueReference(queueName);
        StorageUtil.queueAddMessage(queue, message, timeToLiveInSeconds, initialVisibilityDelayInSeconds);
    }

    public static CloudQueueClient queueClientCreate(String connectionString) throws InvalidKeyException, URISyntaxException {
        CloudStorageAccount account = CloudStorageAccount.parse((String)connectionString);
        return account.createCloudQueueClient();
    }

    public static CloudQueue queueCreate(CloudQueueClient queueClient, String queueName) throws URISyntaxException, StorageException {
        CloudQueue queue = queueClient.getQueueReference(queueName);
        queue.createIfNotExists();
        return queue;
    }

    public static void queueDelete(CloudQueue queue) throws StorageException, URISyntaxException {
        queue.deleteIfExists();
    }

    public static void queueDelete(CloudQueueClient queueClient, String queueName) throws StorageException, URISyntaxException {
        CloudQueue queue = queueClient.getQueueReference(queueName);
        StorageUtil.queueDelete(queue);
    }

    public static long queueGetApproximateMessageCount(CloudQueue queue) throws StorageException {
        queue.downloadAttributes();
        long cachedMessageCount = queue.getApproximateMessageCount();
        return cachedMessageCount;
    }

    public static long queueGetApproximateMessageCount(CloudQueueClient queueClient, String queueName) throws StorageException, URISyntaxException {
        CloudQueue queue = queueClient.getQueueReference(queueName);
        return StorageUtil.queueGetApproximateMessageCount(queue);
    }

    public static void queueModify(CloudQueue queue, int maxNumberOfMessageToPeek, String originMessage, String newMessage, int visibilityTimeoutInSeconds) throws StorageException {
        for (CloudQueueMessage message : queue.retrieveMessages(maxNumberOfMessageToPeek, 1, null, null)) {
            if (!message.getMessageContentAsString().equals(originMessage)) continue;
            message.setMessageContent(newMessage);
            EnumSet<MessageUpdateFields> updateFields = EnumSet.of(MessageUpdateFields.CONTENT, MessageUpdateFields.VISIBILITY);
            queue.updateMessage(message, visibilityTimeoutInSeconds, updateFields, null, null);
            break;
        }
    }

    public static void queueModify(CloudQueueClient queueClient, String queueName, int maxNumberOfMessageToPeek, String originMessage, String newMessage, int visibilityTimeoutInSeconds) throws StorageException, URISyntaxException {
        CloudQueue queue = queueClient.getQueueReference(queueName);
        StorageUtil.queueModify(queue, maxNumberOfMessageToPeek, originMessage, newMessage, visibilityTimeoutInSeconds);
    }

    public static String queuePeekMessage(CloudQueue queue) throws URISyntaxException, StorageException {
        CloudQueueMessage peekedMessage = queue.peekMessage();
        return peekedMessage != null ? peekedMessage.getMessageContentAsString() : null;
    }

    public static String queuePeekMessage(CloudQueueClient queueClient, String queueName) throws URISyntaxException, StorageException {
        CloudQueue queue = queueClient.getQueueReference(queueName);
        return StorageUtil.queuePeekMessage(queue);
    }

    public static CloudQueueMessage queueRetrieveThenDelete(CloudQueue queue) throws StorageException {
        CloudQueueMessage retrievedMessage = queue.retrieveMessage();
        if (retrievedMessage != null) {
            queue.deleteMessage(retrievedMessage);
        }
        return retrievedMessage;
    }

    public static CloudQueueMessage queueRetrieveThenDelete(CloudQueueClient queueClient, String queueName) throws StorageException, URISyntaxException {
        CloudQueue queue = queueClient.getQueueReference(queueName);
        return StorageUtil.queueRetrieveThenDelete(queue);
    }

    public static ArrayList<TableResult> tableBatchInsertOrReplace(CloudTable cloudTable, List<TableEntity> tableEntites) throws StorageException {
        TableBatchOperation batchOperation = new TableBatchOperation();
        for (TableEntity entity : tableEntites) {
            batchOperation.insertOrReplace(entity);
        }
        return cloudTable.execute(batchOperation);
    }

    public static ArrayList<TableResult> tableBatchInsertOrReplace(CloudTableClient tableClient, String tableName, List<TableEntity> tableEntites) throws StorageException, URISyntaxException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tableBatchInsertOrReplace(cloudTable, tableEntites);
    }

    public static CloudTableClient tableClientCreate(String connectionString) throws InvalidKeyException, URISyntaxException {
        CloudStorageAccount account = CloudStorageAccount.parse((String)connectionString);
        return account.createCloudTableClient();
    }

    public static CloudTable tableCreate(CloudTableClient tableClient, String tableName) throws URISyntaxException, StorageException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        cloudTable.createIfNotExists();
        return cloudTable;
    }

    public static TableResult tableDelete(CloudTable cloudTable, Class<? extends TableEntity> clazzType, String partitionKey, String rowKey) throws StorageException {
        TableOperation retrieve = TableOperation.retrieve((String)partitionKey, (String)rowKey, clazzType);
        TableServiceEntity entity = (TableServiceEntity)cloudTable.execute(retrieve).getResultAsType();
        TableOperation delete = TableOperation.delete((TableEntity)entity);
        return cloudTable.execute(delete);
    }

    public static TableResult tableDelete(CloudTable cloudTable, TableEntity tableEntity) throws StorageException {
        TableOperation delete = TableOperation.delete((TableEntity)tableEntity);
        return cloudTable.execute(delete);
    }

    public static TableResult tableDelete(CloudTableClient tableClient, String tableName, Class<? extends TableEntity> clazzType, String partitionKey, String rowKey) throws StorageException, URISyntaxException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tableDelete(cloudTable, clazzType, partitionKey, rowKey);
    }

    public static TableResult tableInsertOrMerge(CloudTable cloudTable, TableEntity tableEntity) throws StorageException {
        TableOperation insertOrMerge = TableOperation.insertOrMerge((TableEntity)tableEntity);
        return cloudTable.execute(insertOrMerge);
    }

    public static TableResult tableInsertOrMerge(CloudTableClient tableClient, String tableName, TableEntity tableEntity) throws StorageException, URISyntaxException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tableInsertOrMerge(cloudTable, tableEntity);
    }

    public static TableResult tableInsertOrReplace(CloudTable cloudTable, TableEntity tableEntity) throws StorageException {
        TableOperation insertOrReplace = TableOperation.insertOrReplace((TableEntity)tableEntity);
        return cloudTable.execute(insertOrReplace);
    }

    public static TableResult tableInsertOrReplace(CloudTableClient tableClient, String tableName, TableEntity tableEntity) throws StorageException, URISyntaxException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tableInsertOrReplace(cloudTable, tableEntity);
    }

    public static <T extends TableEntity> Iterable<T> tablePartitionQuery(CloudTable cloudTable, String partitionKey, String partitionName, Class<T> clazzType) {
        String partitionFilter = TableQuery.generateFilterCondition((String)partitionKey, (String)"eq", (String)partitionName);
        System.out.println(partitionFilter);
        TableQuery partitionQuery = TableQuery.from(clazzType).where(partitionFilter);
        return cloudTable.execute(partitionQuery);
    }

    public static <T extends TableEntity> Iterable<T> tablePartitionQuery(CloudTable cloudTable, String partitionKey, String partitionName, Class<T> clazzType, String queryComparisons) {
        String partitionFilter = TableQuery.generateFilterCondition((String)partitionKey, (String)queryComparisons, (String)partitionName);
        TableQuery partitionQuery = TableQuery.from(clazzType).where(partitionFilter);
        return cloudTable.execute(partitionQuery);
    }

    public static <T extends TableEntity> Iterable<T> tablePartitionQuery(CloudTableClient tableClient, String tableName, String partitionKey, String partitionName, Class<T> clazzType) throws URISyntaxException, StorageException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tablePartitionQuery(cloudTable, partitionKey, partitionName, clazzType);
    }

    public static <T extends TableEntity> Iterable<T> tablePartitionQuery(CloudTableClient tableClient, String tableName, String partitionKey, String partitionName, Class<T> clazzType, String queryComparisons) throws URISyntaxException, StorageException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tablePartitionQuery(cloudTable, partitionKey, partitionName, clazzType, queryComparisons);
    }

    public static <R> Iterable<R> tableProjectionQuery(CloudTable cloudTable, String[] columns, Class<? extends TableEntity> clazzType, EntityResolver<R> resolver) {
        TableQuery projectionQuery = TableQuery.from(clazzType).select(columns);
        return cloudTable.execute(projectionQuery, resolver);
    }

    public static <R> Iterable<R> tableProjectionQuery(CloudTableClient tableClient, String tableName, String[] columns, Class<? extends TableEntity> clazzType, EntityResolver<R> resolver) throws URISyntaxException, StorageException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tableProjectionQuery(cloudTable, columns, clazzType, resolver);
    }

    public static Iterable<String[]> tableProjectionQueryResultArrays(CloudTable cloudTable, final String[] columns, Class<? extends TableEntity> clazzType) {
        TableQuery projectionQuery = TableQuery.from(clazzType).select(columns);
        EntityResolver<String[]> resolver = new EntityResolver<String[]>(){

            public String[] resolve(String PartitionKey, String RowKey, Date timeStamp, HashMap<String, EntityProperty> properties, String etag) {
                String[] values = new String[columns.length];
                int i = 0;
                while (i < columns.length) {
                    values[i] = properties.get(columns[i]).getValueAsString();
                    ++i;
                }
                return values;
            }
        };
        return cloudTable.execute(projectionQuery, (EntityResolver)resolver);
    }

    public static Iterable<String[]> tableProjectionQueryResultArrays(CloudTableClient tableClient, String tableName, String[] columns, Class<? extends TableEntity> clazzType) throws URISyntaxException, StorageException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tableProjectionQueryResultArrays(cloudTable, columns, clazzType);
    }

    public static Iterable<List<String>> tableProjectionQueryResultLists(CloudTable cloudTable, final String[] columns, Class<? extends TableEntity> clazzType) {
        TableQuery projectionQuery = TableQuery.from(clazzType).select(columns);
        EntityResolver<List<String>> resolver = new EntityResolver<List<String>>(){

            public List<String> resolve(String PartitionKey, String RowKey, Date timeStamp, HashMap<String, EntityProperty> properties, String etag) {
                ArrayList<String> values = new ArrayList<String>();
                int i = 0;
                while (i < columns.length) {
                    values.add(properties.get(columns[i]).getValueAsString());
                    ++i;
                }
                return values;
            }
        };
        return cloudTable.execute(projectionQuery, (EntityResolver)resolver);
    }

    public static Iterable<List<String>> tableProjectionQueryResultLists(CloudTableClient tableClient, String tableName, String[] columns, Class<? extends TableEntity> clazzType) throws URISyntaxException, StorageException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tableProjectionQueryResultLists(cloudTable, columns, clazzType);
    }

    public static Iterable<Map<String, String>> tableProjectionQueryResultMaps(CloudTable cloudTable, final String[] columns, Class<? extends TableEntity> clazzType) {
        TableQuery projectionQuery = TableQuery.from(clazzType).select(columns);
        EntityResolver<Map<String, String>> resolver = new EntityResolver<Map<String, String>>(){

            public Map<String, String> resolve(String PartitionKey, String RowKey, Date timeStamp, HashMap<String, EntityProperty> properties, String etag) {
                HashMap<String, String> values = new HashMap<String, String>();
                int i = 0;
                while (i < columns.length) {
                    values.put(columns[i], properties.get(columns[i]).getValueAsString());
                    ++i;
                }
                return values;
            }
        };
        return cloudTable.execute(projectionQuery, (EntityResolver)resolver);
    }

    public static Iterable<Map<String, String>> tableProjectionQueryResultMaps(CloudTableClient tableClient, String tableName, String[] columns, Class<? extends TableEntity> clazzType) throws URISyntaxException, StorageException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tableProjectionQueryResultMaps(cloudTable, columns, clazzType);
    }

    public static <T extends TableEntity> Iterable<T> tableQueryByCombinedFilter(CloudTable cloudTable, Class<T> clazzType, String combinedFilter) {
        TableQuery rangeQuery = TableQuery.from(clazzType).where(combinedFilter);
        return cloudTable.execute(rangeQuery);
    }

    public static <T extends TableEntity> Iterable<T> tableQueryByCombinedFilter(CloudTableClient tableClient, String tableName, Class<T> clazzType, String combinedFilter) throws URISyntaxException, StorageException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tableQueryByCombinedFilter(cloudTable, clazzType, combinedFilter);
    }

    public static <T extends TableEntity> T tableQueryOneEntity(CloudTable cloudTable, Class<T> clazzType, String partitionKey, String rowKey) throws StorageException {
        TableOperation retrieve = TableOperation.retrieve((String)partitionKey, (String)rowKey, clazzType);
        return (T)((TableEntity)cloudTable.execute(retrieve).getResultAsType());
    }

    public static <T extends TableEntity> T tableQueryOneEntity(CloudTableClient tableClient, String tableName, Class<T> clazzType, String partitionKey, String rowKey) throws StorageException, URISyntaxException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tableQueryOneEntity(cloudTable, clazzType, partitionKey, rowKey);
    }

    public static TableResult tableReplaceEntity(CloudTable cloudTable, TableEntity entity) throws StorageException {
        TableOperation replaceEntity = TableOperation.replace((TableEntity)entity);
        return cloudTable.execute(replaceEntity);
    }

    public static TableResult tableReplaceEntity(CloudTableClient tableClient, String tableName, TableEntity entity) throws StorageException, URISyntaxException {
        CloudTable cloudTable = tableClient.getTableReference(tableName);
        return StorageUtil.tableReplaceEntity(cloudTable, entity);
    }
}

