/*
 * Decompiled with CFR 0.152.
 */
package cn.easylib.domain.rules;

import cn.easylib.domain.rules.IRule;
import java.lang.reflect.Method;

public abstract class PropertyRule<T, V>
implements IRule<T> {
    private final String property;
    private String[] properties;

    protected PropertyRule(String property) {
        this.property = property;
        this.parseProperty();
    }

    protected String getProperty() {
        return this.property;
    }

    private void parseProperty() {
        this.properties = this.property.split("\\.");
    }

    protected V getObjectAttrValue(T model) {
        Object value = this.getObjectValue(model);
        if (value == null) {
            return null;
        }
        return (V)value;
    }

    private Object getObjectValue(T model) {
        Object objectValue = model;
        for (String p : this.properties) {
            String pro = p.replaceFirst(p.substring(0, 1), p.substring(0, 1).toUpperCase());
            if (objectValue == null) {
                return null;
            }
            try {
                Method m = this.getMethod(objectValue.getClass(), "get" + pro);
                m.setAccessible(true);
                objectValue = m.invoke(objectValue, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        return objectValue;
    }

    private Method getMethod(Class<?> c, String method) {
        Method m = null;
        try {
            m = c.getDeclaredMethod(method, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                m = c.getMethod(method, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                if (c.getSuperclass() == null) {
                    return m;
                }
                m = this.getMethod(c.getSuperclass(), method);
            }
        }
        return m;
    }
}

