/*
 * Decompiled with CFR 0.152.
 */
package cn.easylib.domain.rules;

import cn.easylib.domain.rules.PropertyRule;

public class NumberShouldGreaterThanRule<T, V extends Number>
extends PropertyRule<T, V> {
    private V value = null;

    public NumberShouldGreaterThanRule(String property, V value) {
        super(property);
        this.value = value;
    }

    @Override
    public boolean isSatisfy(T model) {
        Number v = (Number)this.getObjectAttrValue(model);
        if (this.value == null) {
            return false;
        }
        String name = this.value.getClass().getName();
        if (Integer.class.getName() == name) {
            return v.intValue() > ((Number)this.value).intValue();
        }
        if (Long.class.getName() == name) {
            return v.doubleValue() > ((Number)this.value).doubleValue();
        }
        if (Short.class.getName() == name) {
            return v.shortValue() > ((Number)this.value).shortValue();
        }
        if (Float.class.getName() == name) {
            return v.floatValue() > ((Number)this.value).floatValue();
        }
        if (Double.class.getName() == name) {
            return v.doubleValue() > ((Number)this.value).doubleValue();
        }
        if (Byte.class.getName() == name) {
            return v.byteValue() > ((Number)this.value).byteValue();
        }
        return false;
    }
}

