/*
 * Decompiled with CFR 0.152.
 */
package cn.easylib.domain.rules;

import cn.easylib.domain.rules.PropertyRule;

public class NumberEqualRule<T, V extends Number>
extends PropertyRule<T, V> {
    private final V value;

    public NumberEqualRule(String property, V value) {
        super(property);
        this.value = value;
    }

    @Override
    public boolean isSatisfy(T model) {
        Number v = (Number)this.getObjectAttrValue(model);
        if (this.value == null) {
            return false;
        }
        String name = this.value.getClass().getName();
        if (Integer.class.getName().equals(name)) {
            return v.intValue() == ((Number)this.value).intValue();
        }
        if (Long.class.getName().equals(name)) {
            return v.doubleValue() == ((Number)this.value).doubleValue();
        }
        if (Short.class.getName().equals(name)) {
            return v.shortValue() == ((Number)this.value).shortValue();
        }
        if (Float.class.getName().equals(name)) {
            return v.floatValue() == ((Number)this.value).floatValue();
        }
        if (Double.class.getName().equals(name)) {
            return v.doubleValue() == ((Number)this.value).doubleValue();
        }
        if (Byte.class.getName().equals(name)) {
            return v.byteValue() == ((Number)this.value).byteValue();
        }
        return false;
    }
}

