/*
 * Decompiled with CFR 0.152.
 */
package cn.easylib.domain.event;

import cn.easylib.domain.application.subscriber.DefaultOrderedPerformManager;
import cn.easylib.domain.application.subscriber.IDomainEventManager;
import cn.easylib.domain.application.subscriber.IDomainEventSubscriber;
import cn.easylib.domain.application.subscriber.IExecuteCondition;
import cn.easylib.domain.application.subscriber.IOrderedPerformManager;
import cn.easylib.domain.application.subscriber.ISubscriber;
import cn.easylib.domain.application.subscriber.SubscriberInfo;
import cn.easylib.domain.event.DefaultExecuteCondition;
import cn.easylib.domain.event.IDomainEvent;
import cn.easylib.domain.event.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;

public class ThreadPoolTaskDomainEventManager
implements IDomainEventManager {
    private final ConcurrentHashMap<String, List<SubscriberInfo>> subscribersMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ScheduledThreadPoolExecutor> taskTheadMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> domainEventAndThreadMap = new ConcurrentHashMap();
    private final IOrderedPerformManager performManager;
    private static final DefaultExecuteCondition<IDomainEvent> condition = new DefaultExecuteCondition();
    private final int maxRetryTimes;
    private final int retryDelayTime;
    private final int initThreadCount;

    public ThreadPoolTaskDomainEventManager() {
        this(60, 3, 1500, new DefaultOrderedPerformManager());
    }

    public ThreadPoolTaskDomainEventManager(int initThreadCount, int maxRetryTimes, int retryDelayTime, IOrderedPerformManager iOrderedPerformManager) {
        this.initThreadCount = initThreadCount;
        this.maxRetryTimes = maxRetryTimes;
        this.retryDelayTime = retryDelayTime;
        this.performManager = iOrderedPerformManager;
        ThreadFactory threadFactory = this.createThreadFactory();
        for (int i = 0; i < this.initThreadCount; ++i) {
            ScheduledThreadPoolExecutor threadPoolExecutor = new ScheduledThreadPoolExecutor(5, threadFactory);
            this.taskTheadMap.put(i, threadPoolExecutor);
        }
    }

    public ThreadPoolTaskDomainEventManager(int initThreadCount, int maxRetryTimes, int retryDelayTime) {
        this(initThreadCount, maxRetryTimes, retryDelayTime, new DefaultOrderedPerformManager());
    }

    private ThreadFactory createThreadFactory() {
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("domain-event-thread-" + this.threadNumber.getAndIncrement());
                return thread;
            }
        };
    }

    @Override
    public Map<String, List<String>> allEvents() {
        return this.subscribersMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().map(SubscriberInfo::getAlias).collect(Collectors.toList())));
    }

    @Override
    public void registerDomainEvent(Class<?> domainEventType) {
        String domainEventName = domainEventType.getName();
        this.subscribersMap.computeIfAbsent(domainEventName, s -> new ArrayList());
        this.domainEventAndThreadMap.computeIfAbsent(domainEventName, s -> RandomUtils.nextInt((int)0, (int)this.initThreadCount));
    }

    @Override
    public void registerSubscriber(ISubscriber subscriber, String alias) {
        this.registerSubscriber(subscriber, alias, "");
    }

    @Override
    public void registerSubscriber(ISubscriber subscriber, String alias, String dependSubscriber) {
        this.registerSubscriber(subscriber, alias, condition, dependSubscriber);
    }

    @Override
    public void registerSubscriber(ISubscriber subscriber, String alias, IExecuteCondition condition) {
        this.registerSubscriber(subscriber, alias, condition, "");
    }

    @Override
    public void registerSubscriber(ISubscriber subscriber, String alias, IExecuteCondition condition, String dependSubscriber) {
        String domainEventName = subscriber.subscribedToEventType().getName();
        if (this.subscribersMap.containsKey(domainEventName)) {
            this.subscribersMap.get(domainEventName).add(new SubscriberInfo(subscriber, alias, condition));
        }
        if (this.performManager != null) {
            this.performManager.registerSubscriber(subscriber.subscribedToEventType().getName(), alias, dependSubscriber);
        }
    }

    @Override
    public <T extends IDomainEvent> void publishEvent(T obj) {
        String domainEventName = obj.getClass().getName();
        List<SubscriberInfo> subscriberInfoList = this.subscribersMap.get(domainEventName);
        if (subscriberInfoList == null) {
            return;
        }
        if (this.performManager != null) {
            List<String> rootSubscribers = this.performManager.selectRootSubscribers(domainEventName);
            subscriberInfoList = subscriberInfoList.stream().filter(s -> rootSubscribers.contains(s.getAlias())).collect(Collectors.toList());
        }
        Integer pooledIndex = this.domainEventAndThreadMap.get(domainEventName);
        ScheduledThreadPoolExecutor threadPoolExecutor = this.taskTheadMap.get(pooledIndex);
        for (SubscriberInfo sub : subscriberInfoList) {
            IDomainEventSubscriber subscribedTo = (IDomainEventSubscriber)sub.getSubscriber();
            if (subscribedTo == null || !this.executeCheck(obj, sub.getCondition())) continue;
            Task<T> task = new Task<T>(subscribedTo, obj, this.maxRetryTimes, this.retryDelayTime, threadPoolExecutor, s -> {
                if (this.performManager != null) {
                    List<String> nextSubscriberList = this.performManager.selectNextSubscribers(domainEventName, sub.getAlias());
                    nextSubscriberList.forEach(ss -> this.publishEvent(obj, (String)ss, false));
                }
            });
            threadPoolExecutor.schedule(task, 0L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public <T extends IDomainEvent> void publishEvent(T obj, String subscriber) {
        this.publishEvent(obj, subscriber, false);
    }

    @Override
    public <T extends IDomainEvent> void publishEvent(T obj, String subscriber, boolean onlyThis) {
        String domainEventName = obj.getClass().getName();
        List<SubscriberInfo> subscriberInfoList = this.subscribersMap.get(domainEventName);
        if (subscriberInfoList == null) {
            return;
        }
        Integer pooledIndex = this.domainEventAndThreadMap.get(domainEventName);
        if (pooledIndex == null) {
            return;
        }
        ScheduledThreadPoolExecutor threadPoolExecutor = this.taskTheadMap.get(pooledIndex);
        for (SubscriberInfo sub : subscriberInfoList) {
            IDomainEventSubscriber subscribedTo = (IDomainEventSubscriber)sub.getSubscriber();
            if (subscribedTo == null || !sub.getAlias().equals(subscriber) || !this.executeCheck(obj, sub.getCondition())) continue;
            Task<T> task = new Task<T>(subscribedTo, obj, this.maxRetryTimes, this.retryDelayTime, threadPoolExecutor, s -> {
                if (this.performManager != null && !onlyThis) {
                    List<String> nextSubscriberList = this.performManager.selectNextSubscribers(domainEventName, sub.getAlias());
                    nextSubscriberList.forEach(ss -> this.publishEvent(obj, (String)ss, false));
                }
            });
            threadPoolExecutor.schedule(task, 0L, TimeUnit.MILLISECONDS);
            break;
        }
    }

    private boolean executeCheck(IDomainEvent t, IExecuteCondition iExecuteCondition) {
        try {
            return iExecuteCondition.isExecute(t);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void close() {
        for (ScheduledThreadPoolExecutor executor : this.taskTheadMap.values()) {
            executor.shutdown();
        }
    }
}

