/*
 * Decompiled with CFR 0.152.
 */
package cn.easylib.domain.base;

import cn.easylib.domain.base.Action;
import cn.easylib.domain.base.ActionException;
import cn.easylib.domain.base.EntityAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;

public class EntityActionCollector {
    private final HashMap<String, Action> actionHashMap = new HashMap();
    private final EntityAction entityAction;

    public EntityActionCollector(EntityAction entityAction) {
        this.entityAction = entityAction;
    }

    public void put(Action action) {
        if (!this.entityAction.populateActions().containsKey(action.getActionCode())) {
            throw new ActionException("not find action in EntityAction");
        }
        this.actionHashMap.put(action.getActionCode(), action);
    }

    public boolean containActions(Action ... actions) {
        return this.actionHashMap.keySet().containsAll(Arrays.stream(actions).map(Action::getActionCode).collect(Collectors.toList()));
    }

    public boolean containAction(Action action) {
        return this.actionHashMap.containsKey(action.getActionCode());
    }

    public boolean notContainAction(Action action) {
        return !this.actionHashMap.containsKey(action.getActionCode());
    }
}

