/*
 * Decompiled with CFR 0.152.
 */
package cn.easylib.domain.base;

import cn.easylib.domain.base.BrokeRuleAggregateException;
import cn.easylib.domain.base.BrokenRule;
import cn.easylib.domain.base.BrokenRuleException;
import cn.easylib.domain.base.BrokenRuleMessage;
import cn.easylib.domain.base.EmptyBrokenRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BrokenRuleObject {
    private final List<BrokenRule> brokenRules = new ArrayList<BrokenRule>();
    private final BrokenRuleMessage brokenRuleMessage = this.getBrokenRuleMessages();
    private static final EmptyBrokenRule emptyBrokenRule = new EmptyBrokenRule();

    protected abstract BrokenRuleMessage getBrokenRuleMessages();

    protected abstract String takeEntityInfo();

    public abstract Boolean validate();

    public List<BrokenRule> getBrokenRules() {
        return Collections.unmodifiableList(this.brokenRules);
    }

    public void addBrokenRule(String messageKey) {
        String message = this.brokenRuleMessage.getRuleDescription(messageKey);
        BrokenRule rule = new BrokenRule(messageKey, message);
        this.brokenRules.add(rule);
    }

    public void addBrokenRule(String messageKey, String property) {
        String message = this.brokenRuleMessage.getRuleDescription(messageKey);
        BrokenRule rule = new BrokenRule(messageKey, message, property);
        this.brokenRules.add(rule);
    }

    public void addBrokenRule(String messageKey, String property, String alias) {
        String message = this.brokenRuleMessage.getRuleDescription(messageKey);
        BrokenRule rule = new BrokenRule(messageKey, message, property, alias, null);
        this.brokenRules.add(rule);
    }

    public void addParamBrokenRule(String messageKey, Object[] params, boolean isAutoFormat) {
        this.addParamBrokenRule(messageKey, "", params, "", isAutoFormat);
    }

    public void addParamBrokenRule(String messageKey, String property, Object[] params, String alias, boolean isAutoFormat) {
        String message = this.brokenRuleMessage.getRuleDescription(messageKey);
        String realMessage = isAutoFormat ? String.format(message, params) : message;
        BrokenRule rule = new BrokenRule(messageKey, realMessage, property, alias, params);
        this.brokenRules.add(rule);
    }

    public BrokenRule findBrokenRule(String property) {
        BrokenRule rule = null;
        for (BrokenRule b : this.brokenRules) {
            if (!b.getProperty().equals(property)) continue;
            rule = b;
            break;
        }
        if (rule == null) {
            return emptyBrokenRule;
        }
        return rule;
    }

    public void throwBrokenRuleException() {
        BrokenRuleException brokenRuleException = this.exceptionCause();
        if (brokenRuleException != null) {
            throw brokenRuleException;
        }
    }

    public BrokenRuleException exceptionCause() {
        if (this.getBrokenRules().size() > 0) {
            BrokenRule brokenRule = this.getBrokenRules().get(0);
            return new BrokenRuleException(brokenRule.getName(), brokenRule.getDescription(), this.takeEntityInfo(), brokenRule.getExtraData());
        }
        return null;
    }

    public BrokeRuleAggregateException aggregateExceptionCause() {
        if (this.getBrokenRules().size() > 0) {
            ArrayList<BrokenRuleException> brokenRuleExceptions = new ArrayList<BrokenRuleException>();
            for (BrokenRule message : this.getBrokenRules()) {
                BrokenRuleException brokenRuleException = new BrokenRuleException(message.getName(), message.getDescription(), this.takeEntityInfo(), message.getExtraData());
                brokenRuleExceptions.add(brokenRuleException);
            }
            return new BrokeRuleAggregateException(brokenRuleExceptions);
        }
        return null;
    }

    public void throwBrokeRuleAggregateException() {
        BrokeRuleAggregateException brokeRuleAggregateException = this.aggregateExceptionCause();
        if (brokeRuleAggregateException != null) {
            throw brokeRuleAggregateException;
        }
    }

    public void clearBrokenRules() {
        this.brokenRules.clear();
    }
}

