/*
 * Decompiled with CFR 0.152.
 */
package cn.easylib.domain.application.subscriber;

import cn.easylib.domain.application.subscriber.IOrderedPerformManager;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefaultOrderedPerformManager
implements IOrderedPerformManager {
    private static final String ROOT_NAME = "_root_";
    private final ConcurrentMap<String, HashSet<OrderData>> maps = new ConcurrentHashMap<String, HashSet<OrderData>>();

    @Override
    public void registerSubscriber(String eventName, String currentSubscriberAlias, String parentSubscriberAlias) {
        if (this.maps.containsKey(eventName)) {
            ((HashSet)this.maps.get(eventName)).add(new OrderData(parentSubscriberAlias, currentSubscriberAlias));
        } else {
            HashSet<OrderData> orderDataHashSet = new HashSet<OrderData>();
            orderDataHashSet.add(new OrderData(parentSubscriberAlias, currentSubscriberAlias));
            this.maps.put(eventName, orderDataHashSet);
        }
    }

    @Override
    public List<String> selectNextSubscribers(String eventName, String subscriberAlias) {
        return Optional.ofNullable(this.maps.get(eventName)).orElse(new HashSet()).stream().filter(s -> s.currentSubscriberAlias.equals(subscriberAlias)).map(s -> s.childSubscriberAlias).collect(Collectors.toList());
    }

    @Override
    public List<String> selectRootSubscribers(String eventName) {
        return this.selectNextSubscribers(eventName, ROOT_NAME);
    }

    static class OrderData {
        public final String currentSubscriberAlias;
        public final String childSubscriberAlias;

        public OrderData(String currentSubscriberAlias, String childSubscriberAlias) {
            this.currentSubscriberAlias = StringUtils.isEmpty((CharSequence)currentSubscriberAlias) ? DefaultOrderedPerformManager.ROOT_NAME : currentSubscriberAlias;
            this.childSubscriberAlias = childSubscriberAlias;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderData orderData = (OrderData)o;
            return this.currentSubscriberAlias.equals(orderData.currentSubscriberAlias) && this.childSubscriberAlias.equals(orderData.childSubscriberAlias);
        }

        public int hashCode() {
            return Objects.hash(this.currentSubscriberAlias, this.childSubscriberAlias);
        }
    }
}

