/*
 * Decompiled with CFR 0.152.
 */
package cn.easygd.dynaguard.parser;

import cn.easygd.dynaguard.core.path.ChainFilePathParser;
import cn.easygd.dynaguard.domain.enums.FreeMarkTypeEnum;
import cn.easygd.dynaguard.domain.exception.ValidationChainParserException;
import cn.easygd.dynaguard.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SpringChainFilePathParser
implements ChainFilePathParser {
    public List<String> parse(List<String> pathList) {
        ArrayList result = Lists.newArrayList();
        for (String path : pathList) {
            String wildcardMatch = FileUtils.getWildcardMatch((String)path);
            if (FileUtils.isAbsolutePath((String)path).booleanValue()) {
                List localFilePathList = FileUtils.getFileAbsolutePath((String)path, (String)wildcardMatch).stream().map(source -> "file:" + source).collect(Collectors.toList());
                result.addAll(localFilePathList);
                continue;
            }
            if (!path.startsWith("classpath:") && !path.startsWith("classpath*:")) {
                path = "classpath:" + path;
            }
            try {
                Resource[] resources;
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                for (Resource resource : resources = resolver.getResources(path)) {
                    result.add(resource.getURL().toString());
                }
            }
            catch (IOException e) {
                throw new ValidationChainParserException("path parse exception : " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public String getParserName() {
        return FreeMarkTypeEnum.SPRING.getType();
    }
}

