/*
 * Decompiled with CFR 0.152.
 */
package cn.easygd.dynaguard;

import cn.easygd.dynaguard.core.annotation.DynamicGuard;
import cn.easygd.dynaguard.core.chain.ValidationChain;
import cn.easygd.dynaguard.core.chain.ValidationChainManager;
import cn.easygd.dynaguard.domain.SpringValidationContext;
import cn.easygd.dynaguard.domain.context.ChainOptions;
import cn.easygd.dynaguard.domain.context.ValidationContext;
import cn.easygd.dynaguard.domain.enums.GuardMode;
import cn.easygd.dynaguard.domain.guard.CounterThreshold;
import cn.easygd.dynaguard.domain.guard.GuardThreshold;
import cn.easygd.dynaguard.domain.guard.InterceptRateThreshold;
import cn.easygd.dynaguard.utils.JsonUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationMethodInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ValidationMethodInterceptor.class);
    private ValidationChainManager validationChainManager;

    @Nullable
    public Object invoke(@Nonnull MethodInvocation invocation) throws Throwable {
        String chainId;
        Method method = invocation.getMethod();
        DynamicGuard dynamicGuard = method.getAnnotation(DynamicGuard.class);
        if (dynamicGuard == null) {
            log.info("dynamicGuard annotation can't find skip validation");
            return invocation.proceed();
        }
        String group = dynamicGuard.group();
        ValidationChain chain = this.validationChainManager.getChain(group, chainId = (String)StringUtils.defaultIfBlank((CharSequence)dynamicGuard.chainId(), (CharSequence)this.generateDefaultChainId(method)));
        if (chain == null) {
            log.info("chain can't find group : [{}] , chainId : [{}]", (Object)group, (Object)chainId);
            return invocation.proceed();
        }
        SpringValidationContext context = new SpringValidationContext();
        Parameter[] parameters = method.getParameters();
        Object[] arguments = invocation.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            context.put(parameters[i].getName(), arguments[i]);
        }
        ChainOptions.Builder builder = ChainOptions.builder();
        builder.chainRuleMode(dynamicGuard.chainRuleMode());
        if (dynamicGuard.enableGuard()) {
            builder.enableGuard(Boolean.valueOf(true)).guardMode(dynamicGuard.guardMode());
            String guardThreshold = dynamicGuard.guardThreshold();
            if (StringUtils.isNotBlank((CharSequence)guardThreshold)) {
                if (GuardMode.COUNTER == dynamicGuard.guardMode()) {
                    builder.guardThreshold((GuardThreshold)JsonUtils.parse((String)guardThreshold, CounterThreshold.class));
                } else if (GuardMode.RATE == dynamicGuard.guardMode()) {
                    builder.guardThreshold((GuardThreshold)JsonUtils.parse((String)guardThreshold, InterceptRateThreshold.class));
                }
            }
        }
        context.setChainOptions(builder.build());
        chain.execute((ValidationContext)context);
        return invocation.proceed();
    }

    private String generateDefaultChainId(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        String packageName = declaringClass.getPackage().getName();
        String className = declaringClass.getSimpleName();
        String methodName = method.getName();
        return String.format("%s.%s.%s", packageName, className, methodName);
    }

    public void setValidationChainManager(ValidationChainManager validationChainManager) {
        this.validationChainManager = validationChainManager;
    }
}

