/*
 * Decompiled with CFR 0.152.
 */
package cn.easygd.dynaguard.config;

import cn.easygd.dynaguard.config.ValidationProperty;
import cn.easygd.dynaguard.domain.config.ValidationChainConfig;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@EnableConfigurationProperties(value={ValidationProperty.class})
@PropertySource(value={"classpath:validation.properties"})
public class ValidationChainPropertyAutoConfiguration {
    @Bean
    public ValidationChainConfig validationChainConfig(ValidationProperty property) {
        ValidationChainConfig config = new ValidationChainConfig();
        config.setParserList(property.getParser());
        config.setPathParserName(property.getPathParserName());
        config.setValidationMethodList(property.getValidationMethod());
        config.setChainFilePath((List)Lists.newArrayList((Object[])property.getChainFilePath().split(",")));
        config.setEnableSecurityStrategy(property.getEnableSecurityStrategy());
        config.setEnableBizTrace(property.getEnableBizTrace());
        config.setEnableGuard(property.getEnableGuard());
        config.setGuardMode(property.getGuardMode());
        config.setSqlChainDataMap(property.getSqlChainDataMap());
        config.setXmlChainDataMap(property.getXmlChainDataMap());
        config.setJsonChainDataMap(property.getJsonChainDataMap());
        return config;
    }
}

